/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.threed;

import com.agfa.hap.geometry.api.threed.ILine;
import com.agfa.hap.geometry.api.threed.IPolygon;
import com.agfa.hap.geometry.impl.threed.Line;
import java.util.List;
import javax.vecmath.Point3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Polygon
implements IPolygon {
    private static final Logger LOGGER = LoggerFactory.getLogger(Polygon.class);
    private List<Point3d> points = null;
    private int intersectIndex = -1;

    public Polygon(List<Point3d> list) {
        if (list == null) {
            LOGGER.warn("List of points is NULL.");
        } else if (list.size() < 3) {
            LOGGER.warn("List of points only contains " + list.size() + " points.");
        }
        this.points = list;
    }

    @Override
    public List<Point3d> getPoints() {
        return this.points;
    }

    @Override
    public int getIntersectIndex() {
        return this.intersectIndex;
    }

    @Override
    public Point3d intersectFirst(ILine iLine) {
        if (this.points == null) {
            return null;
        }
        int n = this.points.size();
        if (n <= 1) {
            return null;
        }
        int n2 = n - 1;
        while (n2 > 0) {
            Line line = new Line(this.points.get(n2 - 1), this.points.get(n2), true);
            Point3d point3d = iLine.intersect(line);
            if (point3d != null) {
                this.intersectIndex = n2 - 1;
                return point3d;
            }
            --n2;
        }
        this.intersectIndex = -1;
        return null;
    }
}

