/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce;

import com.agfa.pacs.data.dicom.comm.DicomCompositeCFindSCU;
import com.agfa.pacs.data.dicom.lw.datainfo.AbstractDicomDataInfoNode;
import com.agfa.pacs.data.export.tce.TeachingFile;
import com.agfa.pacs.data.export.tce.TeachingFileProperty;
import com.agfa.pacs.data.export.tce.TeachingFilePropertyValue;
import com.agfa.pacs.data.export.tce.keyword.IKeyword;
import com.agfa.pacs.data.export.tce.keyword.IKeywordProvider;
import com.agfa.pacs.data.export.tce.keyword.Keyword;
import com.agfa.pacs.data.export.tce.property.TeachingFileConfigProperty;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.util.DateUtils;

public class TeachingFileUtilities {
    private static final ALogger log = ALogger.getLogger(TeachingFileUtilities.class);

    public static <T> T convert(Object object, Class<T> clazz) throws Exception {
        if (String.class.isAssignableFrom(clazz)) {
            if (Code.class.isAssignableFrom(object.getClass())) {
                return (T)((Code)object).getCodeValue();
            }
            return (T)object.toString();
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            if (Integer.class.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            if (Code.class.isAssignableFrom(object.getClass())) {
                return (T)Integer.valueOf(((Code)object).getCodeValue());
            }
            return (T)Integer.valueOf(object.toString());
        }
        if (Date.class.isAssignableFrom(clazz)) {
            if (Date.class.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            if (Code.class.isAssignableFrom(object.getClass())) {
                try {
                    return (T)DateUtils.parseDA(null, (String)((Code)object).getCodeValue(), (boolean)true);
                }
                catch (Exception exception) {
                    log.warn("Unparsable date", (Throwable)exception);
                    return null;
                }
            }
            try {
                return (T)DateUtils.parseDA(null, (String)object.toString(), (boolean)true);
            }
            catch (Exception exception) {
                log.warn("Unparsable date", (Throwable)exception);
                return null;
            }
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            if (clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            if (Code.class.isAssignableFrom(object.getClass())) {
                Code code = (Code)object;
                String string = code.getCodeValue();
                T[] TArray = clazz.getEnumConstants();
                int n = TArray.length;
                int n2 = 0;
                while (n2 < n) {
                    T t = TArray[n2];
                    if (TeachingFilePropertyValue.DicomEnum.class.isAssignableFrom(t.getClass()) ? code.equals((Object)((TeachingFilePropertyValue.DicomEnum)t).toDicomCode()) : ((Enum)t).name().equals(string)) {
                        return t;
                    }
                    ++n2;
                }
            } else {
                T[] TArray = clazz.getEnumConstants();
                int n = TArray.length;
                int n3 = 0;
                while (n3 < n) {
                    T t = TArray[n3];
                    if (TeachingFilePropertyValue.DicomEnum.class.isAssignableFrom(clazz) && object.toString().equals(((TeachingFilePropertyValue.DicomEnum)t).toDicomString())) {
                        return t;
                    }
                    if (((Enum)t).name().equals(object.toString())) {
                        return t;
                    }
                    ++n3;
                }
            }
            throw new ClassCastException("Unable to cast enum (" + clazz + "): No enum constant found for name '" + object.toString() + "'!");
        }
        throw new ClassCastException("Unable to cast from class " + object.getClass() + " to class " + clazz);
    }

    public static Collection<TeachingFile<TeachingFile.ObjectReference>> query(AbstractDicomDataInfoNode abstractDicomDataInfoNode, TeachingFile<?> teachingFile) throws Exception {
        Attributes attributes = teachingFile.toQueryDataset();
        try (DicomCompositeCFindSCU dicomCompositeCFindSCU = new DicomCompositeCFindSCU(abstractDicomDataInfoNode.getDicomNode(), DicomCompositeCFindSCU.DefaultStandardQueryClassUIDs);){
            dicomCompositeCFindSCU.connect();
            List list = dicomCompositeCFindSCU.cFind(attributes);
            if (list != null) {
                ArrayList<TeachingFile<TeachingFile.ObjectReference>> arrayList = new ArrayList<TeachingFile<TeachingFile.ObjectReference>>();
                for (Attributes attributes2 : list) {
                    arrayList.add(TeachingFile.fromDatasetQuery(attributes2, abstractDicomDataInfoNode));
                }
                ArrayList<TeachingFile<TeachingFile.ObjectReference>> arrayList2 = arrayList;
                return arrayList2;
            }
            List<TeachingFile<TeachingFile.ObjectReference>> list2 = Collections.emptyList();
            return list2;
        }
    }

    public static <T> T convert(Object object, Class<T> clazz, IKeywordProvider iKeywordProvider) throws Exception {
        if (IKeyword.class.isAssignableFrom(clazz)) {
            if (IKeyword.class.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            if (Code.class.isAssignableFrom(object.getClass())) {
                IKeyword iKeyword = null;
                if (iKeywordProvider != null) {
                    iKeyword = iKeywordProvider.findKeyword((Code)object);
                }
                if (iKeyword == null) {
                    iKeyword = Keyword.createCode((Code)object);
                }
                return (T)iKeyword;
            }
            IKeyword iKeyword = null;
            if (iKeywordProvider != null) {
                iKeyword = iKeywordProvider.findKeyword(object.toString());
            }
            if (iKeyword == null) {
                iKeyword = Keyword.createText(object.toString());
            }
            return (T)iKeyword;
        }
        return TeachingFileUtilities.convert(object, clazz);
    }

    public static List<TeachingFileProperty<?>> extractProperties(Collection<TeachingFileConfigProperty> collection) {
        if (collection != null && !collection.isEmpty()) {
            ArrayList arrayList = new ArrayList(collection.size());
            for (TeachingFileConfigProperty teachingFileConfigProperty : collection) {
                arrayList.add(teachingFileConfigProperty.getProperty());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

