/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.auditing.IAuditing;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.data.export.tce.ITeachingFileConfig;
import com.agfa.pacs.data.export.tce.TCEProviderFactory;
import com.agfa.pacs.data.export.tce.TeachingFile;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.EventTypeCode;
import org.dcm4che3.audit.ParticipantObjectDescription;
import org.dcm4che3.audit.ParticipantObjectIDTypeCode;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.PersonName;

public class TeachingFileAuditManager {
    private static final ALogger log = ALogger.getLogger(TeachingFileAuditManager.class);
    private static TeachingFileAuditManager instance;
    private IAuditing delegate;

    private TeachingFileAuditManager() {
        ITeachingFileConfig iTeachingFileConfig = TCEProviderFactory.getInstance().getConfiguration();
        this.delegate = Audit.getInstance().createAlternativeAuditing(iTeachingFileConfig.getAuditApplicationName(), iTeachingFileConfig.getAuditHost(), iTeachingFileConfig.getAuditPort(), iTeachingFileConfig.getAuditProtocol());
    }

    public static final synchronized TeachingFileAuditManager getInstance() {
        if (instance == null) {
            instance = new TeachingFileAuditManager();
        }
        return instance;
    }

    public void logTFCreated(TeachingFile<Attributes> teachingFile) {
        if (TCEProviderFactory.getInstance().getConfiguration().isAuditingEnabled()) {
            try {
                AuditMessage auditMessage = this.createTFCreatedMessage(teachingFile, this.getStudyUIDs(teachingFile), teachingFile.getTargetNode());
                Audit.getInstance().logAuditMessage(auditMessage, "0");
                if (this.delegate.isUseable()) {
                    this.delegate.logAuditMessage(auditMessage, "0");
                }
            }
            catch (Exception exception) {
                log.warn("Unable to log teaching-file created event!", (Throwable)exception);
            }
        }
    }

    public void logTFViewed(TeachingFile<TeachingFile.ObjectReference> teachingFile) {
        if (TCEProviderFactory.getInstance().getConfiguration().isAuditingEnabled()) {
            try {
                if (this.delegate.isUseable()) {
                    this.delegate.logAuditMessage(this.createTFViewedMessage(teachingFile, this.getStudyUIDs2(teachingFile), false), "0");
                }
            }
            catch (Exception exception) {
                log.warn("Unable to log teaching-file viewed event!", (Throwable)exception);
            }
        }
    }

    public void logTFImagesViewed(TeachingFile<IObjectInfo> teachingFile) {
        if (TCEProviderFactory.getInstance().getConfiguration().isAuditingEnabled()) {
            try {
                if (this.delegate.isUseable()) {
                    this.delegate.logAuditMessage(this.createTFViewedMessage(teachingFile, this.getStudyUIDs3(teachingFile), true), "0");
                }
            }
            catch (Exception exception) {
                log.warn("Unable to log teaching-file viewed event!", (Throwable)exception);
            }
        }
    }

    private List<String> getStudyUIDs(TeachingFile<Attributes> teachingFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = (String)teachingFile.getClientProperty(TeachingFile.ClientProperty.ATFI_STUID);
        if (string != null) {
            arrayList.add(string);
        }
        for (Attributes attributes : teachingFile.getReferencedObjects()) {
            String string2 = attributes.getString(0x20000D);
            if (string2 == null || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private List<String> getStudyUIDs2(TeachingFile<TeachingFile.ObjectReference> teachingFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = (String)teachingFile.getClientProperty(TeachingFile.ClientProperty.ATFI_STUID);
        if (string != null) {
            arrayList.add(string);
        }
        for (TeachingFile.ObjectReference objectReference : teachingFile.getReferencedObjects()) {
            String string2 = objectReference.studyUID;
            if (string2 == null || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private List<String> getStudyUIDs3(TeachingFile<IObjectInfo> teachingFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = (String)teachingFile.getClientProperty(TeachingFile.ClientProperty.ATFI_STUID);
        if (string != null) {
            arrayList.add(string);
        }
        for (IObjectInfo iObjectInfo : teachingFile.getReferencedObjects()) {
            String string2 = iObjectInfo.getStudyUID();
            if (string2 == null || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private AuditMessage createTFViewedMessage(TeachingFile<?> teachingFile, List<String> list, boolean bl) {
        AuditMessage auditMessage = new AuditMessage();
        EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.DICOMInstancesAccessed, (String)"R", (Calendar)Calendar.getInstance(), (String)"0", null, (EventTypeCode[])new EventTypeCode[0]);
        auditMessage.setEventIdentification(eventIdentification);
        this.addStudies(auditMessage, list);
        return auditMessage;
    }

    private void addStudies(AuditMessage auditMessage, List<String> list) {
        if (list != null) {
            for (String string : list) {
                ParticipantObjectIdentification participantObjectIdentification = new ParticipantObjectIdentification();
                ParticipantObjectDescription participantObjectDescription = new ParticipantObjectDescription();
                participantObjectDescription.getParticipantObjectContainsStudy().add(AuditMessages.createParticipantObjectContainsStudy((String)string));
                participantObjectIdentification.setParticipantObjectDescription(participantObjectDescription);
                participantObjectIdentification.setParticipantObjectID(string);
                participantObjectIdentification.setParticipantObjectIDTypeCode((ParticipantObjectIDTypeCode)AuditMessages.ParticipantObjectIDTypeCode.StudyInstanceUID);
                participantObjectIdentification.setParticipantObjectTypeCode("2");
                participantObjectIdentification.setParticipantObjectTypeCodeRole("3");
                auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification);
            }
        }
    }

    private AuditMessage createTFCreatedMessage(TeachingFile<Attributes> teachingFile, List<String> list, IDicomNode iDicomNode) {
        AuditMessage auditMessage = new AuditMessage();
        EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.Export, (String)"E", null, (String)"0", null, (EventTypeCode[])new EventTypeCode[0]);
        auditMessage.setEventIdentification(eventIdentification);
        if (iDicomNode != null) {
            ActiveParticipant activeParticipant = new ActiveParticipant();
            activeParticipant.setUserName("TFA");
            activeParticipant.setNetworkAccessPointID(iDicomNode.getHost());
            activeParticipant.setAlternativeUserID(iDicomNode.getCalledAET());
            auditMessage.getActiveParticipant().add(activeParticipant);
        }
        this.addPatient(auditMessage, teachingFile);
        this.addStudies(auditMessage, list);
        return auditMessage;
    }

    private void addPatient(AuditMessage auditMessage, TeachingFile<Attributes> teachingFile) {
        List<Attributes> list = teachingFile.getReferencedObjects();
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null) {
            for (Attributes attributes : list) {
                try {
                    String string = attributes.getString(0x100020);
                    String string2 = attributes.getString(0x100021);
                    String string3 = String.valueOf(string) + string2;
                    if (hashSet.contains(string3)) continue;
                    hashSet.add(string3);
                    String string4 = attributes.getString(0x100010);
                    if (string4 != null) {
                        string4 = PersonNameUtilities.personNameToHRReverse((PersonName)new PersonName(string4));
                    }
                    ParticipantObjectIdentification participantObjectIdentification = new ParticipantObjectIdentification();
                    participantObjectIdentification.setParticipantObjectName(string4);
                    participantObjectIdentification.setParticipantObjectID(string);
                    participantObjectIdentification.setParticipantObjectIDTypeCode((ParticipantObjectIDTypeCode)AuditMessages.ParticipantObjectIDTypeCode.PatientNumber);
                    participantObjectIdentification.setParticipantObjectTypeCode("1");
                    participantObjectIdentification.setParticipantObjectTypeCodeRole("1");
                    auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification);
                }
                catch (Exception exception) {}
            }
        }
    }
}

