/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce;

import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.QueryRetrieveLevel;
import com.agfa.pacs.data.dicom.comm.DicomCompositeCStoreSCU;
import com.agfa.pacs.data.dicom.config.DicomConfigurationFactory;
import com.agfa.pacs.data.dicom.lw.datainfo.AbstractDicomDataInfoNode;
import com.agfa.pacs.data.export.tce.ITeachingFileConfig;
import com.agfa.pacs.data.export.tce.Messages;
import com.agfa.pacs.data.export.tce.TCEProviderFactory;
import com.agfa.pacs.data.export.tce.TeachingFileDicomCode;
import com.agfa.pacs.data.export.tce.TeachingFileDicomTag;
import com.agfa.pacs.data.export.tce.TeachingFileProperty;
import com.agfa.pacs.data.export.tce.TeachingFilePropertyValue;
import com.agfa.pacs.data.export.tce.TeachingFileUtilities;
import com.agfa.pacs.data.export.tce.anatomy.Anatomy;
import com.agfa.pacs.data.export.tce.keyword.IKeyword;
import com.agfa.pacs.data.export.tce.pathology.Pathology;
import com.agfa.pacs.data.export.tce.property.TeachingFileConfigProperty;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectData;
import com.agfa.pacs.listtext.dicomobject.iod.sr.StructuredReportInformationObject;
import com.agfa.pacs.listtext.dicomobject.module.ko.KeyObjectDocumentModule;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentContent;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.dicomobject.sr.contenttree.DocumentContentTree;
import com.agfa.pacs.listtext.dicomobject.sr.contenttree.DocumentContentTreeNode;
import com.agfa.pacs.listtext.dicomobject.type.RelationshipType;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DateRange;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class TeachingFile<T> {
    private static final ALogger log = ALogger.getLogger(TeachingFile.class);
    private static final int[] STUDY_TAGS = new int[]{524320, 524336, 528432, 0x20000D};
    private static final int[] PATIENT_TAGS = new int[]{0x100010, 0x100020, 0x100021, 0x100030, 0x100040, 0x101002};
    private static final String WILDCARD = "*";
    private IDicomNode target;
    private AbstractDicomDataInfoNode source;
    private Map<TeachingFileProperty<? extends Object>, TeachingFilePropertyValue<? extends Object>> values = new HashMap<TeachingFileProperty<? extends Object>, TeachingFilePropertyValue<? extends Object>>();
    private List<T> refs;
    private Map<ClientProperty, Object> clientProperties;

    private TeachingFile() {
    }

    public static TeachingFile<ObjectReference> createQueryInstance() {
        return TeachingFile.createQueryInstance(null, false);
    }

    public static TeachingFile<Attributes> createExportInstance() {
        TeachingFile<Attributes> teachingFile = new TeachingFile<Attributes>();
        return teachingFile;
    }

    public static TeachingFile<IObjectInfo> createResolvedTeachingFile(TeachingFile<ObjectReference> teachingFile, List<IObjectInfo> list) {
        TeachingFile<IObjectInfo> teachingFile2 = new TeachingFile<IObjectInfo>();
        teachingFile2.source = teachingFile.source;
        super.initValues(teachingFile);
        teachingFile2.refs = list;
        return teachingFile2;
    }

    public static TeachingFile<ObjectReference> createQueryInstance(Collection<ISeriesInfo> collection) {
        return TeachingFile.createQueryInstance(collection, true);
    }

    private static TeachingFile<ObjectReference> createQueryInstance(Collection<ISeriesInfo> collection, boolean bl) {
        TeachingFile<ObjectReference> teachingFile = new TeachingFile<ObjectReference>();
        if (collection != null) {
            super.fillQuery(collection, bl);
        }
        return teachingFile;
    }

    public static TeachingFile<ObjectReference> fromDataset(Attributes attributes, AbstractDicomDataInfoNode abstractDicomDataInfoNode) {
        Object object;
        ReferencedSeries referencedSeries;
        Object object2;
        List list3;
        TeachingFile<ObjectReference> teachingFile = new TeachingFile<ObjectReference>();
        teachingFile.source = abstractDicomDataInfoNode;
        StructuredReportInformationObject structuredReportInformationObject = StructuredReportInformationObject.createInstance((Attributes)attributes);
        DocumentContentTree documentContentTree = new DocumentContentTree(structuredReportInformationObject.getContent());
        List list2 = documentContentTree.getRoot().children();
        if (list2 != null) {
            for (List list3 : list2) {
                DocumentContent documentContent = list3.getDocumentContent();
                object2 = documentContent.getConceptName();
                try {
                    referencedSeries = TeachingFileProperty.find((Code)object2);
                    if (referencedSeries == null) continue;
                    object = null;
                    if (DocumentContent.CodeContent.class.isAssignableFrom(documentContent.getClass())) {
                        object = ((DocumentContent.CodeContent)documentContent).getConcept();
                    } else if (DocumentContent.TextContent.class.isAssignableFrom(documentContent.getClass())) {
                        object = ((DocumentContent.TextContent)documentContent).getTextValue();
                    }
                    if (object != null) {
                        super.addValuesUnchecked((TeachingFileProperty)referencedSeries, object);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.warn("Reading content item '" + object2.toString() + "' discarded: Type of content not supported (" + documentContent.getValueType().dicom() + ")");
                }
                catch (Exception exception) {
                    if (log.isDebugEnabled()) {
                        log.warn("Reading content item '" + object2.toString() + "' failed! Skipped...", (Throwable)exception);
                        continue;
                    }
                    log.warn("Reading content item '" + object2.toString() + "' failed! Skipped...");
                }
            }
        }
        if ((list3 = structuredReportInformationObject.getGeneral().currentRequestedProcedureEvidences()) != null) {
            for (SOPInstanceReference sOPInstanceReference : list3) {
                object2 = sOPInstanceReference.referencedSeries();
                if (object2 == null) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    referencedSeries = (ReferencedSeries)object.next();
                    String[] stringArray = referencedSeries.getRetrieveAETs();
                    List list4 = referencedSeries.referencedSOP();
                    if (list4 == null) continue;
                    for (ReferencedSOP referencedSOP : list4) {
                        teachingFile.addReferencedObject(new ObjectReference(sOPInstanceReference.getStudyInstanceUID(), referencedSeries.getSeriesInstanceUID(), referencedSOP.getSOPInstanceUID(), referencedSOP.getSOPClassUID(), stringArray != null && stringArray.length > 0 ? stringArray[0] : null));
                    }
                }
            }
        }
        return teachingFile;
    }

    public static TeachingFile<ObjectReference> fromDatasetQuery(Attributes attributes, AbstractDicomDataInfoNode abstractDicomDataInfoNode) {
        TeachingFile<ObjectReference> teachingFile = new TeachingFile<ObjectReference>();
        teachingFile.source = abstractDicomDataInfoNode;
        teachingFile.putClientProperty(ClientProperty.ATFI_STUID, attributes.getString(0x20000D));
        teachingFile.putClientProperty(ClientProperty.ATFI_SUID, attributes.getString(0x20000E));
        teachingFile.putClientProperty(ClientProperty.ATFI_IUID, attributes.getString(524312));
        if (attributes.containsValue(0x700080)) {
            teachingFile.setValues(TeachingFileProperty.Title, attributes.getString(0x700080));
        } else {
            teachingFile.setValues(TeachingFileProperty.Title, Messages.getString("TeachingFileProperty.Title.DefaultTitle"));
        }
        if (attributes.containsValue(7340161)) {
            teachingFile.setValues(TeachingFileProperty.Abstract, attributes.getString(7340161));
        }
        if (attributes.containsValue(7340164)) {
            teachingFile.setValues(TeachingFileProperty.AuthorName, PersonNameUtilities.personNameToHRReverse((PersonName)new PersonName(attributes.getString(7340164), true)));
        }
        if (attributes.containsValue(524323)) {
            teachingFile.setValues(TeachingFileProperty.CreatedOn, attributes.getDate(524323));
        }
        return teachingFile;
    }

    public boolean hasValue(TeachingFileProperty<?> teachingFileProperty) {
        TeachingFilePropertyValue<? extends Object> teachingFilePropertyValue = this.values.get(teachingFileProperty);
        return teachingFilePropertyValue != null && teachingFilePropertyValue.hasValues();
    }

    public <U> U getValue(TeachingFileProperty<U> teachingFileProperty) {
        TeachingFilePropertyValue<? extends Object> teachingFilePropertyValue = this.values.get(teachingFileProperty);
        return (U)(teachingFilePropertyValue != null ? teachingFilePropertyValue.getValue() : null);
    }

    public <U> List<U> getValuesAsList(TeachingFileProperty<U> teachingFileProperty) {
        TeachingFilePropertyValue<? extends Object> teachingFilePropertyValue = this.values.get(teachingFileProperty);
        return teachingFilePropertyValue != null ? teachingFilePropertyValue.getValuesAsList() : null;
    }

    public <U> U[] getValues(TeachingFileProperty<U> teachingFileProperty) {
        TeachingFilePropertyValue<? extends Object> teachingFilePropertyValue = this.values.get(teachingFileProperty);
        return teachingFilePropertyValue != null ? teachingFilePropertyValue.getValues() : null;
    }

    public <U> void setValues(TeachingFileProperty<U> teachingFileProperty, U ... UArray) {
        this.values.put(teachingFileProperty, teachingFileProperty.createValue(UArray));
    }

    public <U> void setValuesUnchecked(TeachingFileProperty<U> teachingFileProperty, Object ... objectArray) throws Exception {
        this.values.put(teachingFileProperty, teachingFileProperty.createValueUnchecked(objectArray));
    }

    public boolean removeAllValues(TeachingFileProperty<?> teachingFileProperty) {
        return this.values.remove(teachingFileProperty) != null;
    }

    public <U> boolean removeValues(TeachingFileProperty<U> teachingFileProperty, U ... UArray) {
        TeachingFilePropertyValue<? extends Object> teachingFilePropertyValue = this.values.get(teachingFileProperty);
        if (teachingFilePropertyValue != null) {
            return teachingFilePropertyValue.removeValues(UArray);
        }
        return false;
    }

    public <U> void addValues(TeachingFileProperty<U> teachingFileProperty, U ... UArray) {
        TeachingFilePropertyValue<? extends Object> teachingFilePropertyValue = this.values.get(teachingFileProperty);
        if (teachingFilePropertyValue == null) {
            this.setValues(teachingFileProperty, UArray);
        } else {
            teachingFilePropertyValue.addValues(UArray);
        }
    }

    private <U> void addValuesUnchecked(TeachingFileProperty<U> teachingFileProperty, Object ... objectArray) throws Exception {
        TeachingFilePropertyValue<? extends Object> teachingFilePropertyValue = this.values.get(teachingFileProperty);
        if (teachingFilePropertyValue == null) {
            this.setValuesUnchecked(teachingFileProperty, objectArray);
        } else if (objectArray != null) {
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                teachingFilePropertyValue.addValues(TeachingFileUtilities.convert(object, teachingFileProperty.getValueType().getValueClass(), teachingFileProperty.getKeywordProvider()));
                ++n2;
            }
        }
    }

    public List<T> getReferencedObjects() {
        if (this.refs != null) {
            return Collections.unmodifiableList(this.refs);
        }
        return Collections.emptyList();
    }

    void addReferencedObject(T t) {
        if (this.refs == null) {
            this.refs = new ArrayList<T>();
        }
        this.refs.add(t);
    }

    public IDicomNode getTargetNode() {
        return this.target;
    }

    public void setTarget(IDicomNode iDicomNode) {
        this.target = iDicomNode;
    }

    public AbstractDicomDataInfoNode getSourceNode() {
        return this.source;
    }

    private void initValues(TeachingFile<?> teachingFile) {
        this.values.clear();
        if (teachingFile.values != null) {
            for (Map.Entry<TeachingFileProperty<? extends Object>, TeachingFilePropertyValue<? extends Object>> entry : teachingFile.values.entrySet()) {
                this.values.put(entry.getKey(), entry.getValue().copy());
            }
        }
    }

    public Object getClientProperty(ClientProperty clientProperty) {
        if (this.clientProperties != null) {
            return this.clientProperties.get((Object)clientProperty);
        }
        return null;
    }

    public void removeClientProperty(ClientProperty clientProperty) {
        if (this.clientProperties != null) {
            this.clientProperties.remove((Object)clientProperty);
            if (this.clientProperties.isEmpty()) {
                this.clientProperties = null;
            }
        }
    }

    public void putClientProperty(ClientProperty clientProperty, Object object) {
        if (object == null) {
            this.removeClientProperty(clientProperty);
        } else {
            if (this.clientProperties == null) {
                this.clientProperties = new HashMap<ClientProperty, Object>();
            }
            this.clientProperties.put(clientProperty, object);
        }
    }

    public void fillForExport(List<Attributes> list) {
        this.setValues(TeachingFileProperty.CreatedOn, new Date());
        ITeachingFileConfig iTeachingFileConfig = TCEProviderFactory.getInstance().getConfiguration();
        this.fill(iTeachingFileConfig.getProperties().getExportProperties(), list);
    }

    private void fillQuery(Collection<ISeriesInfo> collection, boolean bl) {
        ITeachingFileConfig iTeachingFileConfig = TCEProviderFactory.getInstance().getConfiguration();
        if (bl && iTeachingFileConfig.isAutoQueryEnabled() && iTeachingFileConfig.isAutoQueryAgeEnabled()) {
            this.putClientProperty(ClientProperty.CONTENT_DATE_FROM, iTeachingFileConfig.getAutoQueryAge().toFromDate());
        }
        this.fill(iTeachingFileConfig.getProperties().getQueryProperties(), DataInfoUtilities.toAttributesMerged(collection));
    }

    Collection<Attributes> createManifestObjects(Attributes attributes) {
        Attributes attributes2;
        Iterator<Object> iterator;
        Object object2;
        Attributes attributes32;
        if (!(this.refs.get(0) instanceof Attributes)) {
            throw new UnsupportedOperationException();
        }
        KeyObjectData keyObjectData = new KeyObjectData();
        keyObjectData.setDocumentTitle(TeachingFilePropertyValue.Purpose.ForTeaching.toDicomCode());
        keyObjectData.setObservationDateTime(new Date());
        keyObjectData.addCurrentEvidenceReference(attributes.getString(524310), attributes.getString(524312), attributes.getString(0x20000E), attributes.getString(0x20000D));
        keyObjectData.referencedComposites().add(new ReferencedSOP(attributes.getString(524310), attributes.getString(524312)));
        List<T> list = this.getReferencedObjects();
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, SOPInstanceReference> hashMap = new HashMap<String, SOPInstanceReference>();
        HashMap<String, Iterator<Object>> hashMap2 = new HashMap<String, Iterator<Object>>();
        for (Attributes attributes32 : list) {
            keyObjectData.addCurrentEvidenceReference(attributes32.getString(524310), attributes32.getString(524312), attributes32.getString(0x20000E), attributes32.getString(0x20000D));
            if (UIDUtilities.isType((String)attributes32.getString(524310), (UIDType)UIDType.Image)) {
                keyObjectData.referencedImages().add(new SRReferencedImage(attributes32.getString(524310), attributes32.getString(524312), null));
            } else if (UIDUtilities.isType((String)attributes32.getString(524310), (UIDType)UIDType.Composite)) {
                keyObjectData.referencedComposites().add(new ReferencedSOP(attributes32.getString(524310), attributes32.getString(524312)));
            }
            object2 = (SOPInstanceReference)hashMap.get(attributes32.getString(0x20000D));
            if (object2 == null) {
                object2 = new SOPInstanceReference(attributes32.getString(0x20000D));
                hashMap.put(attributes32.getString(0x20000D), (SOPInstanceReference)object2);
            }
            if ((iterator = (ReferencedSeries)hashMap2.get(attributes32.getString(0x20000E))) == null) {
                iterator = new ReferencedSeries(attributes32.getString(0x20000E));
                hashMap2.put(attributes32.getString(0x20000E), iterator);
                object2.addReferencedSeries(iterator);
            }
            iterator.addReferencedSOPs(Collections.singletonList(new ReferencedSOP(attributes32.getString(524310), attributes32.getString(524312))));
        }
        if (hashMap.size() > 1) {
            for (Attributes attributes32 : hashMap.values()) {
                keyObjectData.identicalDocuments().add(attributes32);
            }
        }
        attributes32 = keyObjectData.toInformationObject().toDataset();
        this.setSOPCommonData(attributes32, (Attributes)list.get(0));
        attributes32.setString(524384, VR.CS, "KO");
        attributes32.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.59");
        ArrayList arrayList = new ArrayList(hashMap.size());
        for (Object object2 : hashMap.keySet()) {
            attributes2 = new Attributes(attributes32);
            attributes2.setString(0x20000D, VR.UI, (String)object2);
            attributes2.setString(0x20000E, VR.UI, UIDUtils.createUID());
            attributes2.setString(524312, VR.UI, UIDUtils.createUID());
            if (log.isTraceEnabled()) {
                log.trace("--- Created manifest (KO) ---");
                log.trace(attributes2.toString());
            }
            arrayList.add(attributes2);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2 = (Attributes)iterator.next();
            attributes2 = new KeyObjectDocumentModule();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                Attributes attributes4 = (Attributes)iterator2.next();
                if (object2 == attributes4) continue;
                ReferencedSOP referencedSOP = new ReferencedSOP(attributes4.getString(524310), attributes4.getString(524312));
                ReferencedSeries referencedSeries = new ReferencedSeries(attributes4.getString(0x20000E));
                referencedSeries.addReferencedSOPs(Collections.singletonList(referencedSOP));
                SOPInstanceReference sOPInstanceReference = new SOPInstanceReference(attributes4.getString(0x20000D));
                sOPInstanceReference.addReferencedSeries(referencedSeries);
                attributes2.identicalDocuments().add(sOPInstanceReference);
            }
            attributes2.writeTo((Attributes)object2);
        }
        return arrayList;
    }

    private void fill(Collection<TeachingFileConfigProperty> collection, Collection<Attributes> collection2) {
        if (collection != null) {
            block2: for (TeachingFileConfigProperty teachingFileConfigProperty : collection) {
                try {
                    TeachingFileConfigProperty.PropertyValue propertyValue = teachingFileConfigProperty.getPropertyValue();
                    if (TeachingFileConfigProperty.PropertyValueType.Empty.equals((Object)propertyValue.getValueType())) continue;
                    if (TeachingFileConfigProperty.PropertyValueType.Constant.equals((Object)propertyValue.getValueType())) {
                        this.values.put(teachingFileConfigProperty.getProperty(), teachingFileConfigProperty.getProperty().createValueUnchecked(propertyValue.getValue()));
                        continue;
                    }
                    if (!TeachingFileConfigProperty.PropertyValueType.DicomTag.equals((Object)propertyValue.getValueType())) continue;
                    TeachingFileDicomTag teachingFileDicomTag = (TeachingFileDicomTag)propertyValue.getValue();
                    if (teachingFileDicomTag == null) {
                        log.warn("utom. filling teaching-file with property '" + teachingFileConfigProperty + "' discarded: You have configured to fill by dicom tag, however, please check if really have specified a dicom tag to use!");
                        continue;
                    }
                    int n = teachingFileDicomTag.getTag();
                    for (Attributes attributes : collection2) {
                        Object object;
                        int n2;
                        Object object2;
                        if (n == 524384 || n == 524385) {
                            String[] stringArray;
                            if (n == 524384) {
                                String[] stringArray2 = new String[1];
                                stringArray = stringArray2;
                                stringArray2[0] = attributes.getString(n);
                            } else {
                                stringArray = object2 = attributes.getStrings(n);
                            }
                            if (object2 == null) continue;
                            String[] stringArray3 = object2;
                            int n3 = ((String[])object2).length;
                            n2 = 0;
                            while (n2 < n3) {
                                object = stringArray3[n2];
                                if (!(object == null || "KO".equalsIgnoreCase((String)object) || "PR".equals(object) || "SR".equals(object))) {
                                    this.addValuesUnchecked(teachingFileConfigProperty.getProperty(), object);
                                }
                                ++n2;
                            }
                            continue;
                        }
                        if (TeachingFileProperty.PatientAge.equals(teachingFileConfigProperty.getProperty()) && n == 0x100030) {
                            if (!attributes.containsValue(0x100030)) continue;
                            object2 = Calendar.getInstance();
                            object = Calendar.getInstance();
                            ((Calendar)object).setTime(attributes.getDate(0x100030));
                            n2 = 0;
                            while (((Calendar)object).before(object2)) {
                                ++n2;
                                ((Calendar)object).add(5, 1);
                            }
                            this.values.put(teachingFileConfigProperty.getProperty(), teachingFileConfigProperty.getProperty().createValueUnchecked(n2));
                            continue;
                        }
                        object2 = DicomUtils.getObject((Attributes)attributes, (int)n);
                        if (object2 == null) continue;
                        this.values.put(teachingFileConfigProperty.getProperty(), teachingFileConfigProperty.getProperty().createValueUnchecked(object2));
                        continue block2;
                    }
                }
                catch (Exception exception) {
                    log.warn("Autom. filling teaching-file with property '" + teachingFileConfigProperty + "' failed!", (Throwable)exception);
                }
            }
        }
    }

    private DocumentContentTreeNode createTextNode(Code code, String string, RelationshipType relationshipType, boolean bl) {
        if (bl) {
            string = this.checkToAddWildcards(string);
        }
        return DocumentContentTreeNode.createText((Code)code, (String)string, (RelationshipType)relationshipType);
    }

    private DocumentContentTreeNode createCodeNode(Code code, Code code2, RelationshipType relationshipType) {
        return DocumentContentTreeNode.createCode((Code)code, (Code)code2, (RelationshipType)relationshipType);
    }

    private DocumentContentTreeNode createTextOrCodeNode(Code code, IKeyword iKeyword, RelationshipType relationshipType, boolean bl, TeachingFileProperty<?> teachingFileProperty) {
        if (iKeyword != null) {
            String string = iKeyword.getText();
            Code code2 = iKeyword.getDicomCode();
            if ((iKeyword instanceof Anatomy || iKeyword instanceof Pathology) && teachingFileProperty.getKeywordProvider() != null && !teachingFileProperty.isKeywordProviderExclusive()) {
                string = iKeyword.toString();
            }
            if (code2 != null) {
                if (teachingFileProperty.getKeywordProvider() != null && teachingFileProperty.isKeywordProviderExclusive()) {
                    return this.createCodeNode(code, code2, relationshipType);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("(").append(code2.getCodeValue()).append(")");
                stringBuilder.append(" ");
                stringBuilder.append(code2.getCodeMeaning());
                return this.createTextNode(code, stringBuilder.toString(), relationshipType, bl);
            }
            if (string != null && !string.trim().isEmpty()) {
                return this.createTextNode(code, string.trim(), relationshipType, bl);
            }
        }
        return null;
    }

    private String checkToAddWildcards(String string) {
        if (string != null) {
            if (!string.startsWith(WILDCARD)) {
                string = WILDCARD + string;
            }
            if (!string.endsWith(WILDCARD)) {
                string = String.valueOf(string) + WILDCARD;
            }
        }
        return string;
    }

    private DocumentContentTree createDocumentContentTree(TeachingFile<?> teachingFile, boolean bl) {
        List<String> list;
        String string;
        TeachingFilePropertyValue.Purpose purpose;
        String string2;
        TeachingFilePropertyValue.PatientSex patientSex;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        DocumentContentTreeNode documentContentTreeNode;
        IKeyword iKeyword;
        IKeyword iKeyword2;
        Object object12;
        DocumentContentTreeNode documentContentTreeNode2 = DocumentContentTreeNode.createContainer((Code)TeachingFileDicomCode.AdditionalTeachingFileInformation, null, (RelationshipType)RelationshipType.Contains);
        String string3 = teachingFile.getValue(TeachingFileProperty.AuthorName);
        String string4 = teachingFile.getValue(TeachingFileProperty.AuthorAffiliation);
        String string5 = teachingFile.getValue(TeachingFileProperty.AuthorContact);
        if (string3 != null) {
            object12 = this.createTextNode(TeachingFileProperty.AuthorName.getCode(), string3, RelationshipType.Contains, bl);
            documentContentTreeNode2.addChild(object12);
            if (string4 != null) {
                object12.addChild(this.createTextNode(TeachingFileProperty.AuthorAffiliation.getCode(), string4, RelationshipType.HasProperties, bl));
            }
            if (string5 != null) {
                object12.addChild(this.createTextNode(TeachingFileProperty.AuthorContact.getCode(), string5, RelationshipType.HasProperties, bl));
            }
        }
        if (string4 != null) {
            documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.AuthorAffiliation.getCode(), string4, RelationshipType.Contains, bl));
        }
        if (string5 != null) {
            documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.AuthorContact.getCode(), string5, RelationshipType.Contains, bl));
        }
        if ((object12 = teachingFile.getValue(TeachingFileProperty.Abstract)) != null) {
            documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.Abstract.getCode(), (String)object12, RelationshipType.Contains, bl));
        }
        if ((iKeyword2 = teachingFile.getValue(TeachingFileProperty.Anatomy)) != null && !Anatomy.Unspecified.equals(iKeyword2) && (iKeyword = this.createTextOrCodeNode(TeachingFileProperty.Anatomy.getCode(), iKeyword2, RelationshipType.Contains, bl, TeachingFileProperty.Anatomy)) != null) {
            documentContentTreeNode2.addChild((DocumentContentTreeNode)iKeyword);
        }
        if ((iKeyword = teachingFile.getValue(TeachingFileProperty.Pathology)) != null && !Pathology.Unspecified.equals(iKeyword) && (documentContentTreeNode = this.createTextOrCodeNode(TeachingFileProperty.Pathology.getCode(), iKeyword, RelationshipType.Contains, bl, TeachingFileProperty.Pathology)) != null) {
            documentContentTreeNode2.addChild(documentContentTreeNode);
        }
        if ((documentContentTreeNode = teachingFile.getValuesAsList(TeachingFileProperty.Keywords)) != null && !documentContentTreeNode.isEmpty()) {
            object11 = documentContentTreeNode.iterator();
            while (object11.hasNext()) {
                object10 = (IKeyword)object11.next();
                object9 = this.createTextOrCodeNode(TeachingFileProperty.Keywords.getCode(), (IKeyword)object10, RelationshipType.Contains, bl, TeachingFileProperty.Keywords);
                if (object9 == null) continue;
                documentContentTreeNode2.addChild((DocumentContentTreeNode)object9);
            }
        }
        if ((object10 = teachingFile.getValue(TeachingFileProperty.History)) != null) {
            documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.History.getCode(), (String)object10, RelationshipType.Contains, bl));
        }
        if ((object11 = teachingFile.getValuesAsList(TeachingFileProperty.Findings)) != null) {
            object8 = object11.iterator();
            while (object8.hasNext()) {
                object9 = (IKeyword)object8.next();
                object7 = this.createTextOrCodeNode(TeachingFileProperty.Findings.getCode(), (IKeyword)object9, RelationshipType.Contains, bl, TeachingFileProperty.Findings);
                if (object7 == null) continue;
                documentContentTreeNode2.addChild(object7);
            }
        }
        if ((object9 = teachingFile.getValue(TeachingFileProperty.Discussion)) != null) {
            documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.Discussion.getCode(), (String)object9, RelationshipType.Contains, bl));
        }
        if ((object8 = teachingFile.getValuesAsList(TeachingFileProperty.DifferentialDiagnosis)) != null) {
            object6 = object8.iterator();
            while (object6.hasNext()) {
                object7 = (IKeyword)object6.next();
                object5 = this.createTextOrCodeNode(TeachingFileProperty.DifferentialDiagnosis.getCode(), (IKeyword)object7, RelationshipType.Contains, bl, TeachingFileProperty.DifferentialDiagnosis);
                if (object5 == null) continue;
                documentContentTreeNode2.addChild((DocumentContentTreeNode)object5);
            }
        }
        if ((object7 = teachingFile.getValuesAsList(TeachingFileProperty.Diagnosis)) != null) {
            object5 = object7.iterator();
            while (object5.hasNext()) {
                object6 = (IKeyword)object5.next();
                object4 = this.createTextOrCodeNode(TeachingFileProperty.Diagnosis.getCode(), (IKeyword)object6, RelationshipType.Contains, bl, TeachingFileProperty.Diagnosis);
                if (object4 == null) continue;
                documentContentTreeNode2.addChild(object4);
            }
        }
        if ((object6 = teachingFile.getValue(TeachingFileProperty.DiagnosisConfirmed)) != null) {
            documentContentTreeNode2.addChild(this.createCodeNode(TeachingFileProperty.DiagnosisConfirmed.getCode(), ((TeachingFilePropertyValue.YesNo)object6).toDicomCode(), RelationshipType.Contains));
        }
        if ((object5 = teachingFile.getValuesAsList(TeachingFileProperty.OrganSystems)) != null) {
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object4 = (IKeyword)object3.next();
                object2 = this.createTextOrCodeNode(TeachingFileProperty.OrganSystems.getCode(), (IKeyword)object4, RelationshipType.Contains, bl, TeachingFileProperty.OrganSystems);
                if (object2 == null) continue;
                documentContentTreeNode2.addChild((DocumentContentTreeNode)object2);
            }
        }
        if ((object4 = teachingFile.getValuesAsList(TeachingFileProperty.AcquisitionModalities)) != null && !object4.isEmpty()) {
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object3 = (String)object2.next();
                if (object3 == null) continue;
                object = CodeDictionary.AcquisitionModality.getCodeForValue((String)object3);
                if (object != null) {
                    documentContentTreeNode2.addChild(this.createCodeNode(TeachingFileProperty.AcquisitionModalities.getCode(), (Code)object, RelationshipType.Contains));
                    continue;
                }
                documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.AcquisitionModalities.getCode(), (String)object3, RelationshipType.Contains, bl));
            }
        }
        if ((object3 = teachingFile.getValue(TeachingFileProperty.Category)) != null) {
            documentContentTreeNode2.addChild(this.createCodeNode(TeachingFileProperty.Category.getCode(), ((TeachingFilePropertyValue.Category)object3).toDicomCode(), RelationshipType.Contains));
        }
        if ((object2 = teachingFile.getValue(TeachingFileProperty.Level)) != null) {
            documentContentTreeNode2.addChild(this.createCodeNode(TeachingFileProperty.Level.getCode(), ((TeachingFilePropertyValue.Level)object2).toDicomCode(), RelationshipType.Contains));
        }
        if ((object = teachingFile.getValue(TeachingFileProperty.PatientAge)) != null) {
            documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.PatientAge.getCode(), ((Integer)object).toString(), RelationshipType.Contains, bl));
        }
        if ((patientSex = teachingFile.getValue(TeachingFileProperty.PatientSex)) != null) {
            documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.PatientSex.getCode(), patientSex.toDicomString(), RelationshipType.Contains, bl));
        }
        if ((string2 = teachingFile.getValue(TeachingFileProperty.PatientSpecies)) != null) {
            documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.PatientSpecies.getCode(), string2, RelationshipType.Contains, bl));
        }
        if ((purpose = teachingFile.getValue(TeachingFileProperty.Purpose)) != null) {
            documentContentTreeNode2.addChild(this.createCodeNode(TeachingFileProperty.Purpose.getCode(), purpose.toDicomCode(), RelationshipType.Contains));
        }
        if ((string = teachingFile.getValue(TeachingFileProperty.Title)) != null) {
            documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.Title.getCode(), string, RelationshipType.Contains, bl));
        }
        if ((list = teachingFile.getValuesAsList(TeachingFileProperty.BibliographicReferences)) != null && !list.isEmpty()) {
            for (String string6 : list) {
                documentContentTreeNode2.addChild(this.createTextNode(TeachingFileProperty.BibliographicReferences.getCode(), string6, RelationshipType.Contains, bl));
            }
        }
        return new DocumentContentTree(documentContentTreeNode2);
    }

    private void setSOPCommonData(Attributes attributes, Attributes attributes2) {
        Date date = new Date();
        attributes.setString(524293, VR.CS, DicomConfigurationFactory.getConfiguration().getDefaultCharacterSet());
        attributes.setString(524312, VR.UI, UIDUtils.createUID());
        attributes.setInt(2097171, VR.IS, new int[]{1});
        attributes.setDate(524323, VR.DA, new Date[]{date});
        attributes.setDate(524339, VR.TM, new Date[]{date});
        attributes.setString(0x20000E, VR.UI, UIDUtils.createUID());
        attributes.setDate(524321, VR.DA, new Date[]{date});
        attributes.setDate(524337, VR.TM, new Date[]{date});
        attributes.setInt(0x200011, VR.IS, new int[]{1});
        attributes.setString(524400, VR.LO, Product.getProductVendor());
        attributes.setString(528528, VR.LO, Product.getProductName());
        attributes.setString(1576992, VR.LO, Product.getVersionString());
        attributes.addSelected(attributes2, PATIENT_TAGS);
    }

    public void saveModified(IDicomNode iDicomNode) throws DicomException {
        Attributes attributes = this.createSRTCEObject();
        DicomCompositeCStoreSCU dicomCompositeCStoreSCU = null;
        String string = attributes.getString(524310);
        try {
            dicomCompositeCStoreSCU = new DicomCompositeCStoreSCU(iDicomNode, string);
            dicomCompositeCStoreSCU.connect();
            dicomCompositeCStoreSCU.store(attributes);
        }
        catch (Throwable throwable) {
            if (dicomCompositeCStoreSCU != null) {
                try {
                    dicomCompositeCStoreSCU.close();
                }
                catch (DicomException dicomException) {}
            }
            throw throwable;
        }
        if (dicomCompositeCStoreSCU != null) {
            try {
                dicomCompositeCStoreSCU.close();
            }
            catch (DicomException dicomException) {}
        }
    }

    Attributes createSRTCEObject() {
        Attributes attributes2;
        Object object2;
        DocumentContentTree documentContentTree = this.createDocumentContentTree(this, false);
        StructuredReportInformationObject structuredReportInformationObject = StructuredReportInformationObject.createBasicTextSR(null);
        structuredReportInformationObject.getGeneral().readFrom(new Attributes());
        documentContentTree.putTo(structuredReportInformationObject.getContent());
        List<T> list = this.getReferencedObjects();
        List<T> list2 = null;
        if (list.get(0) instanceof Attributes) {
            list2 = list;
        } else if (list.get(0) instanceof ObjectReference) {
            list2 = new ArrayList<T>(list.size());
            for (Object object2 : list) {
                list2.add(((ObjectReference)object2).toAttribute());
            }
        } else {
            throw new IllegalArgumentException("Unsupported Teaching File type");
        }
        if (list2.isEmpty()) {
            return null;
        }
        object2 = new HashMap();
        HashMap hashMap = new HashMap();
        for (Attributes attributes2 : list2) {
            ReferencedSeries referencedSeries;
            SOPInstanceReference sOPInstanceReference = (SOPInstanceReference)object2.get(attributes2.getString(0x20000D));
            if (sOPInstanceReference == null) {
                sOPInstanceReference = new SOPInstanceReference(attributes2.getString(0x20000D));
                object2.put(attributes2.getString(0x20000D), sOPInstanceReference);
                structuredReportInformationObject.getGeneral().currentRequestedProcedureEvidences().add(sOPInstanceReference);
            }
            if ((referencedSeries = (ReferencedSeries)hashMap.get(attributes2.getString(0x20000E))) == null) {
                referencedSeries = new ReferencedSeries(attributes2.getString(0x20000E));
                hashMap.put(attributes2.getString(0x20000E), referencedSeries);
                sOPInstanceReference.addReferencedSeries(referencedSeries);
            }
            referencedSeries.addReferencedSOPs(Collections.singletonList(new ReferencedSOP(attributes2.getString(524310), attributes2.getString(524312))));
        }
        attributes2 = structuredReportInformationObject.toDataset();
        this.setSOPCommonData(attributes2, (Attributes)list2.get(0));
        attributes2.setString(0x700080, VR.CS, this.getValue(TeachingFileProperty.Title));
        attributes2.setString(7340161, VR.LO, this.getValue(TeachingFileProperty.Abstract));
        attributes2.setString(7340164, VR.PN, this.getValue(TeachingFileProperty.AuthorName));
        attributes2.setString(524384, VR.CS, "SR");
        attributes2.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.11");
        attributes2.addSelected((Attributes)list2.get(0), STUDY_TAGS);
        if (log.isTraceEnabled()) {
            log.trace("--- Created ATFI (SR) ---");
            log.trace(attributes2.toString());
        }
        return attributes2;
    }

    public Attributes toQueryDataset() {
        Date date;
        Attributes attributes = new Attributes();
        attributes.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.11");
        attributes.setString(524370, VR.CS, QueryRetrieveLevel.Image.dicom());
        attributes.setNull(524312, VR.UI);
        attributes.setNull(0x20000E, VR.UI);
        attributes.setNull(0x20000D, VR.UI);
        attributes.setNull(0x700080, VR.CS);
        attributes.setNull(7340161, VR.LO);
        attributes.setNull(524339, VR.TM);
        attributes.setNull(7340164, VR.PN);
        Date date2 = (Date)this.getClientProperty(ClientProperty.CONTENT_DATE_FROM);
        Date date3 = (Date)this.getClientProperty(ClientProperty.CONTENT_DATE_UNTIL);
        if (date2 == null && date3 == null) {
            attributes.setNull(524323, VR.DA);
        } else {
            if (date2 == null) {
                date2 = new Date(0L);
            }
            if (date3 == null) {
                date3 = new Date();
            }
            if (date3.compareTo(date2) < 0) {
                date = date2;
                date2 = date3;
                date3 = date;
            }
            attributes.setDateRange(524323, VR.DA, new DateRange(date2, date3));
        }
        date = this.createDocumentContentTree(this, true);
        attributes.addAll(date.toContent().toDataset());
        return attributes;
    }

    public static enum ClientProperty {
        DEVELOPMENT_KEYWORDS,
        RETRIEVED,
        ATFI_IUID,
        ATFI_SUID,
        ATFI_STUID,
        CONTENT_DATE_FROM,
        CONTENT_DATE_UNTIL;

    }

    public static class ObjectReference {
        final String studyUID;
        public final String seriesInstanceUID;
        public final String instanceUID;
        public final String sopClassUID;
        public final String retrieveAET;

        private ObjectReference(String string, String string2, String string3, String string4, String string5) {
            this.studyUID = string;
            this.seriesInstanceUID = string2;
            this.instanceUID = string3;
            this.sopClassUID = string4;
            this.retrieveAET = string5;
        }

        public Attributes toAttribute() {
            Attributes attributes = new Attributes();
            attributes.setString(0x20000D, VR.UI, this.studyUID);
            attributes.setString(524312, VR.UI, this.studyUID);
            attributes.setString(0x20000E, VR.UI, this.seriesInstanceUID);
            attributes.setString(524310, VR.UI, this.sopClassUID);
            return attributes;
        }
    }
}

