/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.setaside;

import com.agfa.pacs.base.util.FileServiceUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.listtext.setaside.ISetAsideHandler;
import com.agfa.pacs.listtext.setaside.Messages;
import com.agfa.pacs.listtext.setaside.SetAsideDialogException;
import com.agfa.pacs.listtext.setaside.SetAsideHandlerFactory;
import com.agfa.pacs.listtext.setaside.SetAsideState;
import com.agfa.pacs.listtext.swingx.controls.IMessageDialogVisualizer;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.IURLProvider;
import com.agfa.pacs.login.URLProviderFactory;
import java.awt.Component;
import java.io.InputStream;

public class SetAsideManager
extends FileServiceUtil
implements IMessageDialogVisualizer {
    private static final ALogger log = ALogger.getLogger(SetAsideManager.class);
    private static final String SET_ASIDE_SCOPE = "set-aside";
    private static SetAsideManager instance = null;
    private ISetAsideHandler[] handlers = SetAsideHandlerFactory.getInstance().getHandlers();
    private boolean showOverrideAckDialog = true;
    private boolean showStoreSuccessDialog = true;
    private IMessageDialogVisualizer dialogVisualizer = this;
    private volatile boolean isRestoringState;

    private SetAsideManager() {
        super(SET_ASIDE_SCOPE);
    }

    public static synchronized SetAsideManager getInstance() {
        if (instance == null) {
            instance = new SetAsideManager();
        }
        return instance;
    }

    public void setMessageDialogVisualizer(IMessageDialogVisualizer iMessageDialogVisualizer) {
        this.dialogVisualizer = iMessageDialogVisualizer;
    }

    public void store(SetAsideContext setAsideContext) throws Exception {
        this.store(setAsideContext, false);
    }

    public void store(SetAsideContext setAsideContext, boolean bl) throws Exception {
        block15: {
            if (!this.serviceable()) {
                log.error("Store current set-aside status failed: Service is not serviceable at " + this.serviceUrl);
                if (!bl) {
                    this.showNotServiceableDialog(setAsideContext.getUIContext(), this.serviceUrl);
                }
            } else {
                boolean bl2 = true;
                if (this.available(setAsideContext) && !bl && this.showOverrideAckDialog) {
                    bl2 = this.showOverrideAckDialog(setAsideContext.getUIContext());
                }
                if (bl2) {
                    try {
                        SetAsideState setAsideState = this.updateState(setAsideContext);
                        try {
                            this.saveData(setAsideState, true, true);
                            log.info("Set-Aside state successfully saved");
                            if (!bl && this.showStoreSuccessDialog) {
                                this.showStoreSuccessDialog(setAsideContext.getUIContext());
                            }
                        }
                        catch (Exception exception) {
                            log.error("Storing set-aside state information failed!", (Throwable)exception);
                            if (!bl) {
                                this.showStoreErrorDialog(setAsideContext.getUIContext());
                            }
                        }
                    }
                    catch (SetAsideDialogException setAsideDialogException) {
                        log.error("Collecting set-aside state information failed!", (Throwable)setAsideDialogException);
                        if (!bl) {
                            if (setAsideDialogException.supportsErrorDialogDisplay()) {
                                this.showStoreErrorDialog(setAsideContext.getUIContext(), setAsideDialogException.getErrorDialogTitle(), setAsideDialogException.getErrorDialogMessage());
                            } else {
                                this.showStoreErrorDialog(setAsideContext.getUIContext());
                            }
                        }
                    }
                    catch (Exception exception) {
                        log.error("Collecting set-aside state information failed!", (Throwable)exception);
                        if (bl) break block15;
                        this.showStoreErrorDialog(setAsideContext.getUIContext());
                    }
                }
            }
        }
    }

    public void restore(SetAsideContext setAsideContext) throws Exception {
        block19: {
            if (!this.serviceable()) {
                log.error("Store current set-aside status failed: Service is not serviceable at " + this.serviceUrl);
                this.showNotServiceableDialog(setAsideContext.getUIContext(), this.serviceUrl);
            } else if (!this.available(setAsideContext)) {
                log.warn("Restoring set-aside status discarded: No status available!");
                this.showUnavailableDialog(setAsideContext.getUIContext());
            } else {
                try {
                    boolean bl;
                    boolean bl2;
                    SetAsideState setAsideState;
                    block18: {
                        setAsideState = this.getState(setAsideContext);
                        bl2 = true;
                        bl = false;
                        try {
                            this.isRestoringState = true;
                            this.applyState(setAsideState, setAsideContext);
                            log.info("Set-Aside state successfully applied!");
                        }
                        catch (SetAsideDialogException setAsideDialogException) {
                            log.error("Applying set-aside state information failed!", (Throwable)setAsideDialogException);
                            if (setAsideDialogException.supportsErrorDialogDisplay()) {
                                this.showStoreErrorDialog(setAsideContext.getUIContext(), setAsideDialogException.getErrorDialogTitle(), setAsideDialogException.getErrorDialogMessage());
                            } else {
                                this.showStoreErrorDialog(setAsideContext.getUIContext());
                            }
                            this.isRestoringState = false;
                            break block18;
                        }
                        catch (Exception exception) {
                            try {
                                log.error("Applying set-aside state information failed!", (Throwable)exception);
                                bl = true;
                                bl2 = this.showRestoreErrorDeleteStateAckDialog(setAsideContext.getUIContext());
                                break block18;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                this.isRestoringState = false;
                            }
                        }
                        this.isRestoringState = false;
                    }
                    if (!bl2) break block19;
                    try {
                        log.info("Deleting set-aside state...");
                        this.deleteData(setAsideState.getUserId());
                        log.info("Set-Aside state deleted!");
                        if (bl) {
                            this.showDeleteSuccessDialog(setAsideContext.getUIContext());
                        }
                    }
                    catch (Exception exception) {
                        log.error("Deleting set-aside state failed!", (Throwable)exception);
                    }
                }
                catch (Exception exception) {
                    log.error("Retrieving set-aside state information failed!", (Throwable)exception);
                    this.showRestoreErrorDialog(setAsideContext.getUIContext());
                }
            }
        }
    }

    public void delete(SetAsideContext setAsideContext, boolean bl, boolean bl2) throws Exception {
        block7: {
            try {
                SetAsideState setAsideState = this.getState(setAsideContext);
                try {
                    if (setAsideState != null) {
                        log.info("Deleting set-aside state...");
                        this.deleteData(setAsideState.getUserId());
                        if (bl) {
                            this.showDeleteSuccessDialog(setAsideContext.getUIContext());
                        }
                        log.info("Set-Aside state deleted!");
                    }
                }
                catch (Exception exception) {
                    log.error("Deleting set-aside state failed!", (Throwable)exception);
                    if (bl2) {
                        this.showDeleteErrorDialog(setAsideContext.getUIContext());
                    }
                }
            }
            catch (Exception exception) {
                log.error("Retrieving set-aside state information failed!", (Throwable)exception);
                if (!bl2) break block7;
                this.showDeleteErrorDialog(setAsideContext.getUIContext());
            }
        }
    }

    public boolean available(SetAsideContext setAsideContext) throws Exception {
        if (!this.serviceable()) {
            throw new Exception("Set-Aside service not serviceable!");
        }
        return this.isDataAvailable(setAsideContext.getUserId(), "");
    }

    public boolean isOutdated(SetAsideContext setAsideContext) throws Exception {
        SetAsideState setAsideState = this.getState(setAsideContext);
        if (setAsideState == null) {
            throw new Exception("Set-Aside state is null!");
        }
        return this.isStateOutdated(setAsideState);
    }

    public boolean isReadyToUse() {
        if (this.handlers != null) {
            ISetAsideHandler[] iSetAsideHandlerArray = this.handlers;
            int n = this.handlers.length;
            int n2 = 0;
            while (n2 < n) {
                ISetAsideHandler iSetAsideHandler = iSetAsideHandlerArray[n2];
                if (!iSetAsideHandler.isReadyToUse()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean serviceable() {
        try {
            return this.isServiceable();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean enabled() {
        return this.handlers != null && this.handlers.length > 0 && !Product.isInOfflineModus() && ConfigurationProviderFactory.getConfig().isSupportingRoles() && !Product.isReducedVersion();
    }

    public boolean isRestoringState() {
        return this.isRestoringState;
    }

    private SetAsideState getState(SetAsideContext setAsideContext) throws Exception {
        InputStream inputStream = this.getResponseStream(setAsideContext.getUserId(), "");
        SetAsideState setAsideState = SetAsideState.createEmptyInstance(setAsideContext.getUserId());
        setAsideState.read(inputStream);
        return setAsideState;
    }

    private static String resolveCurrentUserId() {
        IURLProvider iURLProvider = URLProviderFactory.getProvider();
        if (iURLProvider != null) {
            return iURLProvider.getLoginInformation().getUserID();
        }
        return null;
    }

    private SetAsideState updateState(SetAsideContext setAsideContext) throws Exception {
        SetAsideState setAsideState = SetAsideState.createEmptyInstance(setAsideContext.getUserId());
        ISetAsideHandler[] iSetAsideHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            ISetAsideHandler iSetAsideHandler = iSetAsideHandlerArray[n2];
            iSetAsideHandler.updateState(setAsideState);
            ++n2;
        }
        return setAsideState;
    }

    private void applyState(SetAsideState setAsideState, SetAsideContext setAsideContext) throws Exception {
        ISetAsideHandler[] iSetAsideHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            ISetAsideHandler iSetAsideHandler = iSetAsideHandlerArray[n2];
            iSetAsideHandler.applyState(setAsideState);
            ++n2;
        }
    }

    private boolean isStateOutdated(SetAsideState setAsideState) {
        try {
            long l;
            long l2;
            long l3;
            int n = (int)ConfigurationProviderFactory.getConfig().getLong("listtext.setaside.outdatedTimePeriod");
            return n >= 0 && (l3 = System.currentTimeMillis()) - (l2 = setAsideState.getCreationDate().getTime()) > (l = (long)(n * 3600000));
        }
        catch (Exception exception) {
            log.warn("Set-Aside status outdate determination failed!", (Throwable)exception);
            return false;
        }
    }

    public void showCentered(MessageDialog messageDialog) {
        messageDialog.showCenteredInOwner();
    }

    private boolean showOverrideAckDialog(Component component) {
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)Messages.getString("SetAsideManager.OverrideAcknowledgeDialog.Title"), (Object)Messages.getString("SetAsideManager.OverrideAcknowledgeDialog.Message"), (boolean)true, (int)4, (String)"OK_CANCEL_OPTION", (boolean)true);
        this.dialogVisualizer.showCentered(messageDialog);
        if (messageDialog.isDontShowDlgAgainSelected()) {
            this.showOverrideAckDialog = false;
        }
        return "OK_OPTION".equals(messageDialog.getSelectedOption());
    }

    private void showStoreSuccessDialog(Component component) {
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)Messages.getString("SetAsideManager.StoreSuccessDialog.Title"), (Object)Messages.getString("SetAsideManager.StoreSuccessDialog.Message"), (boolean)true, (int)0, (String)"OK_OPTION", (boolean)true);
        this.dialogVisualizer.showCentered(messageDialog);
        if (messageDialog.isDontShowDlgAgainSelected()) {
            this.showStoreSuccessDialog = false;
        }
    }

    private void showDeleteSuccessDialog(Component component) {
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)Messages.getString("SetAsideManager.DeleteSuccessDialog.Title"), (Object)Messages.getString("SetAsideManager.DeleteSuccessDialog.Message"), (boolean)true, (int)0, (String)"OK_OPTION");
        this.dialogVisualizer.showCentered(messageDialog);
    }

    private void showDeleteErrorDialog(Component component) {
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)Messages.getString("SetAsideManager.DeleteErrorDialog.Title"), (Object)Messages.getString("SetAsideManager.DeleteErrorDialog.Message"), (boolean)true, (int)0, (String)"OK_OPTION");
        this.dialogVisualizer.showCentered(messageDialog);
    }

    private void showNotServiceableDialog(Component component, String string) {
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)Messages.getString("SetAsideManager.NotServiceableDialog.Title"), (Object)(String.valueOf(Messages.getString("SetAsideManager.NotServiceableDialog.Message1")) + string + Messages.getString("SetAsideManager.NotServiceableDialog.Message2")), (boolean)true, (int)2, (String)"OK_OPTION");
        this.dialogVisualizer.showCentered(messageDialog);
    }

    private void showUnavailableDialog(Component component) {
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)Messages.getString("SetAsideManager.UnvailableDialog.Title"), (Object)Messages.getString("SetAsideManager.UnavailableDialog.Message"), (boolean)true, (int)2, (String)"OK_OPTION");
        this.dialogVisualizer.showCentered(messageDialog);
    }

    private void showStoreErrorDialog(Component component) {
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)Messages.getString("SetAsideManager.StoreErrorDialog.Title"), (Object)Messages.getString("SetAsideManager.StoreErrorDialog.Message"), (boolean)true, (int)2, (String)"OK_OPTION");
        this.dialogVisualizer.showCentered(messageDialog);
    }

    private void showStoreErrorDialog(Component component, String string, String string2) {
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)string, (Object)string2, (boolean)true, (int)2, (String)"OK_OPTION");
        this.dialogVisualizer.showCentered(messageDialog);
    }

    private boolean showRestoreErrorDeleteStateAckDialog(Component component) {
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)Messages.getString("SetAsideManager.RestoreErrorDeleteStateAckDialog.Title"), (Object)Messages.getString("SetAsideManager.RestoreErrorDeleteStateAckDialog.Message"), (boolean)true, (int)2, (String)"YES_NO_OPTION");
        this.dialogVisualizer.showCentered(messageDialog);
        return "YES_OPTION" == messageDialog.getSelectedOption();
    }

    private void showRestoreErrorDialog(Component component) {
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)Messages.getString("SetAsideManager.RestoreErrorDialog.Title"), (Object)Messages.getString("SetAsideManager.RestoreErrorDialog.Message"), (boolean)true, (int)2, (String)"OK_OPTION");
        this.dialogVisualizer.showCentered(messageDialog);
    }

    public static class SetAsideContext {
        private Component uiCtx;
        private String userId;

        private SetAsideContext(String string, Component component) {
            this.userId = string;
            this.uiCtx = component;
        }

        public static SetAsideContext createInstance(String string, Component component) {
            return new SetAsideContext(string, component);
        }

        public static SetAsideContext createInstance(String string) {
            return SetAsideContext.createInstance(string, null);
        }

        public static SetAsideContext createInstance(Component component) {
            return SetAsideContext.createInstance(SetAsideManager.resolveCurrentUserId(), component);
        }

        public static SetAsideContext createInstance() {
            return SetAsideContext.createInstance(null);
        }

        public String getUserId() {
            return this.userId;
        }

        public Component getUIContext() {
            return this.uiCtx;
        }
    }
}

