/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.util.graphics;

import java.awt.Color;

public class ColorUtils {
    public static final String BLACK = "color.black";
    public static final String WHITE = "color.white";
    public static final String WARNING_COLOR = "warningColor";
    public static final String OK_WITH_PROBLEMS = "okWithProblems";
    public static final String OK_COLOR = "workingColor";
    public static final String PRIMARY_COLOR1 = "color.primary.1";
    public static final String PRIMARY_COLOR2 = "color.primary.2";
    public static final String PRIMARY_COLOR3 = "color.primary.3";
    public static final String PRIMARY_COLOR4 = "color.primary.4";
    public static final String SECONDARY_COLOR1 = "color.secondary.1";
    public static final String SECONDARY_COLOR2 = "color.secondary.2";
    public static final String SECONDARY_COLOR3 = "color.secondary.3";
    public static final String SECONDARY_COLOR4 = "color.secondary.4";
    public static final String PERMISSION_ALLOWED = "color.permission.allowed";
    public static final String PERMISSION_DENIED = "color.permission.denied";
    public static final String PERMISSION_UNSPECIFIED = "color.permission.unspecified";
    public static final String PERMISSION_ALLOWED_MONO = "color.permission.allowed.mono";
    public static final String PERMISSION_DENIED_MONO = "color.permission.denied.mono";
    public static final String PERMISSION_UNSPECIFIED_MONO = "color.permission.unspecified.mono";
    public static final String PRIORS_SELECTED_BACKGROUND = "color.priors.selected.bg";
    public static final String PRIORS_ACTUAL_BACKGROUND = "color.priors.actual.bg";
    public static final String PRIORS_PRIOR_BACKGROUND = "color.priors.prior.bg";
    public static final String PRIORS_OLD_BACKGROUND = "color.priors.old.bg";
    public static final String PRIORS_SELECTED_FOREGROUND = "color.priors.selected.fg";
    public static final String PRIORS_ACTUAL_FOREGROUND = "color.priors.actual.fg";
    public static final String PRIORS_PRIOR_FOREGROUND = "color.priors.prior.fg";
    public static final String PRIORS_OLD_FOREGROUND = "color.priors.old.fg";
    public static final String WORKLIST_BACKGROUND = "color.worklist.bg";
    public static final String WORKLIST_ITEM_BACKGROUND = "color.worklist.item.bg";
    public static final String WORKLIST_ITEM_SELECTED_BACKGROUND = "color.worklist.item.selected.bg";
    public static final String WORKLIST_ITEM_SELECTED_BACKGROUND_MONO = "color.worklist.item.selected.bg.mono";
    public static final String WORKLIST_ITEM_SELECTED_FOREGROUND = "color.worklist.item.selected.fg";
    public static final String WORKLIST_ITEM_SELECTED_FOREGROUND_MONO = "color.worklist.item.selected.fg.mono";
    public static final String WORKLIST_ITEM_MARKED_BACKGROUND = "color.worklist.item.marked.bg";
    public static final String WORKLIST_ITEM_MARKED_BACKGROUND_MONO = "color.worklist.item.marked.bg.mono";
    public static final String WORKLIST_ITEM_MARKED_FOREGROUND = "color.worklist.item.marked.fg";
    public static final String WORKLIST_ITEM_MARKED_FOREGROUND_MONO = "color.worklist.item.marked.fg.mono";

    public static boolean isBright(Color color) {
        return ColorUtils.isBright(color, 0.5);
    }

    public static boolean isBright(Color color, double d) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if ((double)fArray[2] < d) {
            return false;
        }
        if ((double)fArray[1] < d) {
            return true;
        }
        return color.getRed() >= 150 || color.getGreen() >= 150 || color.getBlue() >= 150;
    }

    public static boolean isBrighter(Color color, Color color2) {
        float[] fArray;
        float[] fArray2 = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return fArray2[2] > (fArray = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null))[2];
    }

    public static Color darker(Color color, float f) {
        if (color == null) {
            return null;
        }
        return new Color(Math.max((int)Math.min((float)color.getRed() * f, 255.0f), 0), Math.max((int)Math.min((float)color.getGreen() * f, 255.0f), 0), Math.max((int)Math.min((float)color.getBlue() * f, 255.0f), 0));
    }

    public static Color brighter(Color color, float f) {
        int n;
        if (color == null) {
            return null;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = n = f == 1.0f ? 255 : (int)(1.0 / (1.0 - (double)f));
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            return new Color(n, n, n);
        }
        if (n2 > 0 && n2 < n) {
            n2 = n;
        }
        if (n3 > 0 && n3 < n) {
            n3 = n;
        }
        if (n4 > 0 && n4 < n) {
            n4 = n;
        }
        return new Color(Math.max(Math.min((int)((float)n2 / f), 255), 0), Math.max(Math.min((int)((float)n3 / f), 255), 0), Math.max(Math.min((int)((float)n4 / f), 255), 0));
    }
}

