/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.util;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.listtext.swingx.controls.DateBox;
import com.agfa.pacs.listtext.swingx.controls.JSeparator2;
import com.agfa.pacs.listtext.swingx.plaf.nimbus.NimbusUtilities;
import com.agfa.pacs.listtext.swingx.util.graphics.AutoDisposerThread;
import com.sun.awt.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.util.Date;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SpinnerModel;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ArrayUtils;

public class SwingUtilities2 {
    private static Rectangle actualWindowPosition = null;

    public static void updateActualWindowPosition(Rectangle rectangle) {
        actualWindowPosition = rectangle;
    }

    public static JDialog createFloatingWindow(Window window, Component component) {
        JDialog jDialog = new JDialog(window);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        Border border = BorderFactory.createBevelBorder(0);
        jPanel.setBorder(border);
        jPanel.add(component, "Center");
        jDialog.add(jPanel);
        jDialog.setAlwaysOnTop(true);
        jDialog.setDefaultCloseOperation(2);
        jDialog.setResizable(false);
        jDialog.setUndecorated(true);
        return jDialog;
    }

    public static void showFloatingMessageWindow(String string, Window window, IComponentFactory iComponentFactory, Point point, Dimension dimension, boolean bl, Integer n, boolean bl2, MouseListener mouseListener) {
        JLabel jLabel = iComponentFactory.createLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        if (mouseListener != null) {
            jLabel.addMouseListener(mouseListener);
        }
        jLabel.setOpaque(true);
        NimbusUtilities.setNimbusProperty(jLabel, "Label.background", jLabel.getForeground());
        jLabel.setForeground(Color.BLACK);
        jLabel.setHorizontalAlignment(0);
        final JDialog jDialog = SwingUtilities2.createFloatingWindow(window, jLabel);
        jDialog.setSize(dimension);
        AWTUtilities.setWindowShape((Window)jDialog, (Shape)new Ellipse2D.Double(2.0, 4.0, jDialog.getWidth() - 4, jDialog.getHeight() - 8));
        AWTUtilities.setWindowOpacity((Window)jDialog, (float)0.85f);
        jDialog.setBounds(point.x, point.y, jDialog.getWidth(), jDialog.getHeight());
        jDialog.setVisible(true);
        if (bl) {
            jDialog.toFront();
            jDialog.requestFocus();
        }
        if (n != null) {
            new AutoDisposerThread(jDialog, n).start();
        }
        if (bl2 || n == null) {
            jDialog.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    jDialog.dispose();
                }
            });
        }
    }

    public static void centerOnScreen(Window window) {
        Rectangle rectangle = actualWindowPosition;
        if (rectangle == null) {
            rectangle = window.getGraphicsConfiguration().getBounds();
        }
        Rectangle rectangle2 = window.getBounds();
        window.setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
    }

    public static void centerOnFrame(Frame frame, Window window) {
        SwingUtilities2.centerOnWindow(frame, window);
    }

    public static void centerOnDialog(Dialog dialog, Window window) {
        SwingUtilities2.centerOnWindow(dialog, window);
    }

    public static void centerOnWindow(Window window, Window window2) {
        Dimension dimension = window.getSize();
        Point point = window.getLocation();
        window2.setLocation(point.x + dimension.width / 2 - window2.getWidth() / 2, point.y + dimension.height / 2 - window2.getHeight() / 2);
        window2.setLocationRelativeTo(window);
    }

    public static void showModalDialogCentered(JComponent jComponent, String string, JComponent jComponent2) {
        Frame frame = JOptionPane.getFrameForComponent(jComponent);
        JDialog jDialog = new JDialog(frame);
        jDialog.getContentPane().add(jComponent2);
        jDialog.pack();
        jDialog.setTitle(string);
        if (frame == null) {
            jDialog.setLocation(0, 0);
        } else {
            Dimension dimension = frame.getSize();
            Point point = frame.getLocation();
            jDialog.setLocation(point.x + dimension.width / 2 - jDialog.getWidth() / 2, point.y + dimension.height / 2 - jDialog.getHeight() / 2);
            jDialog.setLocationRelativeTo(frame);
        }
        jDialog.setModal(true);
        jDialog.setVisible(true);
    }

    public static Frame frameForComponent(Component component) {
        return JOptionPane.getFrameForComponent(component);
    }

    public static Window windowForComponent(Component component) {
        Window window = SwingUtilities2.findNextDialogOwner(component);
        if (window == null) {
            window = SwingUtilities2.frameForComponent(component);
        }
        return window;
    }

    public static Dialog findNextDialogOwner(Component component) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof Dialog) {
                    return (Dialog)container;
                }
                container = container.getParent();
            }
        }
        return null;
    }

    public static void showDialogCentered(Component component, JDialog jDialog) {
        Frame frame = SwingUtilities2.frameForComponent(component);
        if (frame == null) {
            jDialog.setLocation(0, 0);
        } else {
            Dimension dimension = frame.getSize();
            Point point = frame.getLocation();
            jDialog.setLocation(point.x + dimension.width / 2 - jDialog.getWidth() / 2, point.y + dimension.height / 2 - jDialog.getHeight() / 2);
            jDialog.setLocationRelativeTo(frame);
        }
        jDialog.setVisible(true);
    }

    public static void showDialogCentered(Rectangle rectangle, JDialog jDialog) {
        jDialog.setLocation(rectangle.x + rectangle.width / 2 - jDialog.getWidth() / 2, rectangle.y + rectangle.height / 2 - jDialog.getHeight() / 2);
        jDialog.setVisible(true);
    }

    public static void showModalDialogCentered(Component component, JDialog jDialog) {
        jDialog.setModal(true);
        SwingUtilities2.showDialogCentered(component, jDialog);
    }

    public static JButton createButton(Action action) {
        return SwingUtilities2.createButton(action, null);
    }

    public static JButton createButton(String string) {
        return SwingUtilities2.createButton(string, null, null, null);
    }

    public static JButton createButton(String string, Dimension dimension) {
        return SwingUtilities2.createButton(string, null, null, dimension);
    }

    public static JButton createButton(Icon icon) {
        return SwingUtilities2.createButton(null, null, icon, null);
    }

    public static JButton createButton(Action action, Dimension dimension) {
        JButton jButton = new JButton(action);
        if (dimension != null) {
            jButton.setPreferredSize(dimension);
        }
        return jButton;
    }

    public static JButton createButton(String string, String string2, Icon icon, Dimension dimension) {
        JButton jButton = new JButton();
        if (string != null) {
            jButton.setText(string);
        }
        if (string2 != null) {
            jButton.setToolTipText(string2);
        }
        if (icon != null) {
            jButton.setIcon(icon);
        }
        if (dimension != null) {
            jButton.setPreferredSize(dimension);
        }
        return jButton;
    }

    public static JToggleButton createToggleButton(Action action, Dimension dimension) {
        JToggleButton jToggleButton = new JToggleButton(action);
        if (dimension != null) {
            jToggleButton.setPreferredSize(dimension);
        }
        return jToggleButton;
    }

    public static JToggleButton createToggleButton(String string, String string2, Icon icon, Dimension dimension) {
        JToggleButton jToggleButton = new JToggleButton();
        if (string != null) {
            jToggleButton.setText(string);
        }
        if (string2 != null) {
            jToggleButton.setToolTipText(string2);
        }
        if (icon != null) {
            jToggleButton.setIcon(icon);
        }
        if (dimension != null) {
            jToggleButton.setPreferredSize(dimension);
        }
        return jToggleButton;
    }

    public static JLabel createLabel(String string, String string2, Icon icon, Dimension dimension) {
        JLabel jLabel = new JLabel();
        if (string != null) {
            jLabel.setText(string);
        }
        if (string2 != null) {
            jLabel.setToolTipText(string2);
        }
        if (icon != null) {
            jLabel.setIcon(icon);
        }
        if (dimension != null) {
            jLabel.setPreferredSize(dimension);
        }
        return jLabel;
    }

    public static JTextField createTextField(Action action, Dimension dimension) {
        JTextField jTextField = new JTextField();
        if (action != null) {
            jTextField.setAction(action);
        }
        if (dimension != null) {
            jTextField.setPreferredSize(dimension);
        }
        return jTextField;
    }

    public static JTextField createTextField(String string, String string2, Dimension dimension) {
        JTextField jTextField = new JTextField();
        if (string != null) {
            jTextField.setText(string);
        }
        if (string2 != null) {
            jTextField.setToolTipText(string2);
        }
        if (dimension != null) {
            jTextField.setPreferredSize(dimension);
        }
        return jTextField;
    }

    public static JTable createTable(TableModel tableModel) {
        return new JTable(tableModel);
    }

    public static JTextArea createTextArea(String string, String string2, Dimension dimension) {
        JTextArea jTextArea = new JTextArea();
        if (string != null) {
            jTextArea.setText(string);
        }
        if (string2 != null) {
            jTextArea.setToolTipText(string2);
        }
        if (dimension != null) {
            jTextArea.setPreferredSize(dimension);
        }
        return jTextArea;
    }

    public static JCheckBox createCheckBox(Action action, Boolean bl, Dimension dimension) {
        JCheckBox jCheckBox = new JCheckBox(action);
        if (bl != null) {
            jCheckBox.setSelected(bl);
        }
        if (dimension != null) {
            jCheckBox.setPreferredSize(dimension);
        }
        return jCheckBox;
    }

    public static JCheckBox createCheckBox(String string, String string2, Boolean bl, Dimension dimension) {
        JCheckBox jCheckBox = new JCheckBox();
        if (string != null) {
            jCheckBox.setText(string);
        }
        if (bl != null) {
            jCheckBox.setSelected(bl);
        }
        if (string2 != null) {
            jCheckBox.setToolTipText(string2);
        }
        if (dimension != null) {
            jCheckBox.setPreferredSize(dimension);
        }
        return jCheckBox;
    }

    public static JRadioButton createRadioButton(Action action, Boolean bl, ButtonGroup buttonGroup, Dimension dimension) {
        JRadioButton jRadioButton = new JRadioButton(action);
        if (bl != null) {
            jRadioButton.setSelected(bl);
        }
        if (buttonGroup != null) {
            buttonGroup.add(jRadioButton);
        }
        if (dimension != null) {
            jRadioButton.setPreferredSize(dimension);
        }
        return jRadioButton;
    }

    public static JRadioButton createRadioButton(String string, String string2, Boolean bl, Dimension dimension, ButtonGroup buttonGroup) {
        JRadioButton jRadioButton = new JRadioButton();
        if (string != null) {
            jRadioButton.setText(string);
        }
        if (bl != null) {
            jRadioButton.setSelected(bl);
        }
        if (string2 != null) {
            jRadioButton.setToolTipText(string2);
        }
        if (dimension != null) {
            jRadioButton.setPreferredSize(dimension);
        }
        if (buttonGroup != null) {
            buttonGroup.add(jRadioButton);
        }
        return jRadioButton;
    }

    public static JComboBox createComboBox(Object[] objectArray, Dimension dimension) {
        JComboBox<Object> jComboBox = null;
        jComboBox = objectArray != null ? new JComboBox<Object>(objectArray) : new JComboBox();
        if (dimension != null) {
            jComboBox.setPreferredSize(dimension);
        }
        return jComboBox;
    }

    public static JComboBox createComboBox(Vector<?> vector) {
        JComboBox<Object> jComboBox = null;
        jComboBox = vector != null ? new JComboBox(vector) : new JComboBox();
        return jComboBox;
    }

    public static JComboBox createComboBox(ComboBoxModel comboBoxModel) {
        JComboBox jComboBox = null;
        jComboBox = comboBoxModel != null ? new JComboBox(comboBoxModel) : new JComboBox();
        return jComboBox;
    }

    public static JList createList(Object[] objectArray, Dimension dimension) {
        JList<Object> jList = null;
        jList = objectArray != null ? new JList<Object>(objectArray) : new JList();
        if (dimension != null) {
            jList.setPreferredSize(dimension);
        }
        return jList;
    }

    public static JList createList(ListModel listModel) {
        JList jList = null;
        jList = listModel != null ? new JList(listModel) : new JList();
        return jList;
    }

    public static JPanel createPanel(Boolean bl, Dimension dimension) {
        JPanel jPanel = new JPanel();
        if (bl != null) {
            jPanel.setOpaque(bl);
        }
        if (dimension != null) {
            jPanel.setPreferredSize(dimension);
        }
        return jPanel;
    }

    public static JScrollPane createScrollPane(Component component, Integer n, Integer n2, Boolean bl, Boolean bl2) {
        JScrollPane jScrollPane = new JScrollPane(component);
        if (n != null) {
            jScrollPane.setVerticalScrollBarPolicy(n);
        }
        if (n2 != null) {
            jScrollPane.setHorizontalScrollBarPolicy(n2);
        }
        if (bl != null && bl.booleanValue()) {
            jScrollPane.setBorder(null);
            jScrollPane.getViewport().setBorder(null);
            NimbusUtilities.setNimbusProperty(jScrollPane, "nimbusBorder", new Color(0, 0, 0, 0));
        }
        if (bl2 != null && !bl2.booleanValue()) {
            jScrollPane.setOpaque(false);
            jScrollPane.getViewport().setOpaque(false);
        }
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jScrollPane.getVerticalScrollBar().setBlockIncrement(64);
        return jScrollPane;
    }

    public static JSlider createSlider(Integer n, Integer n2, Integer n3, Integer n4) {
        JSlider jSlider = new JSlider();
        if (n != null) {
            jSlider.setOrientation(n);
        }
        if (n2 != null) {
            jSlider.setMinimum(n2);
        }
        if (n3 != null) {
            jSlider.setMaximum(n3);
        }
        if (n4 != null) {
            jSlider.setValue(n4);
        }
        return jSlider;
    }

    public static JSpinner createSpinner(SpinnerModel spinnerModel, Dimension dimension) {
        JSpinner jSpinner = null;
        jSpinner = spinnerModel != null ? new JSpinner(spinnerModel) : new JSpinner();
        if (dimension != null) {
            jSpinner.setPreferredSize(dimension);
        }
        return jSpinner;
    }

    public static JTabbedPane createTabbedPane(Integer n, Integer n2, Boolean bl, Boolean bl2) {
        JTabbedPane jTabbedPane = new JTabbedPane(n, n2);
        if (bl != null) {
            jTabbedPane.setBorder(null);
        }
        if (bl2 != null) {
            jTabbedPane.setOpaque(bl2);
        }
        return jTabbedPane;
    }

    public static JSeparator2 createSeparator(JSeparator2.SeparatorOrientation separatorOrientation, JSeparator2.SeparatorType separatorType, Dimension dimension) {
        return new JSeparator2(separatorOrientation, separatorType, dimension);
    }

    public static JMenuItem createMenuItem(Action action) {
        return new JMenuItem(action);
    }

    public static JMenuItem createMenuItem(String string, Icon icon, Integer n) {
        JMenuItem jMenuItem = new JMenuItem();
        if (string != null) {
            jMenuItem.setText(string);
        }
        if (icon != null) {
            jMenuItem.setIcon(icon);
        }
        if (n != null) {
            jMenuItem.setMnemonic(n);
        }
        return jMenuItem;
    }

    public static JRadioButtonMenuItem createRadioButtonMenuItem(Action action, Boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
        if (bl != null) {
            jRadioButtonMenuItem.setSelected(bl);
        }
        if (buttonGroup != null) {
            buttonGroup.add(jRadioButtonMenuItem);
        }
        return jRadioButtonMenuItem;
    }

    public static JRadioButtonMenuItem createRadioButtonMenuItem(String string, Icon icon, Boolean bl, ButtonGroup buttonGroup, Integer n) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        if (string != null) {
            jRadioButtonMenuItem.setText(string);
        }
        if (icon != null) {
            jRadioButtonMenuItem.setIcon(icon);
        }
        if (bl != null) {
            jRadioButtonMenuItem.setSelected(bl);
        }
        if (buttonGroup != null) {
            buttonGroup.add(jRadioButtonMenuItem);
        }
        if (n != null) {
            jRadioButtonMenuItem.setMnemonic(n);
        }
        return jRadioButtonMenuItem;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(Action action, Boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(action);
        if (bl != null) {
            jCheckBoxMenuItem.setSelected(bl);
        }
        return jCheckBoxMenuItem;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(String string, Icon icon, Boolean bl, Integer n) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        if (string != null) {
            jCheckBoxMenuItem.setText(string);
        }
        if (icon != null) {
            jCheckBoxMenuItem.setIcon(icon);
        }
        if (bl != null) {
            jCheckBoxMenuItem.setSelected(bl);
        }
        if (n != null) {
            jCheckBoxMenuItem.setMnemonic(n);
        }
        return jCheckBoxMenuItem;
    }

    public static JMenu createMenu(String string, Icon icon, Integer n) {
        JMenu jMenu = new JMenu();
        if (string != null) {
            jMenu.setText(string);
        }
        if (icon != null) {
            jMenu.setIcon(icon);
        }
        if (n != null) {
            jMenu.setMnemonic(n);
        }
        return jMenu;
    }

    public static DateBox createDateBox(Date date, boolean bl, boolean bl2) {
        return new DateBox(date, bl, bl2);
    }

    public static DateBox createDateBox(Date date, boolean bl, boolean bl2, boolean bl3) {
        return new DateBox(date, bl, bl2, bl3);
    }

    public static boolean hasAsChild(Container container, Component component) {
        if (container == component) {
            return true;
        }
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2 instanceof Container ? SwingUtilities2.hasAsChild((Container)component2, component) : component2 == component) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void setComponentHierarchyEnabled(Container container, boolean bl, Component ... componentArray) {
        Component[] componentArray2 = container.getComponents();
        int n = componentArray2.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray2[n2];
            if (componentArray == null || !ArrayUtils.contains((Object[])componentArray, (Object)component)) {
                component.setEnabled(bl);
                if (component instanceof Container) {
                    SwingUtilities2.setComponentHierarchyEnabled((Container)component, bl, componentArray);
                }
            }
            ++n2;
        }
    }
}

