/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.util;

import com.agfa.pacs.logging.ALogger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import javax.swing.plaf.UIResource;

class AdvancedTableTransferable
implements Transferable,
UIResource {
    private static final ALogger LOGGER = ALogger.getLogger(AdvancedTableTransferable.class);
    protected String plainData;
    protected String htmlData;
    private static DataFlavor[] htmlFlavors;
    private static DataFlavor[] stringFlavors;
    private static DataFlavor[] plainFlavors;

    static {
        try {
            htmlFlavors = new DataFlavor[3];
            AdvancedTableTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
            AdvancedTableTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
            AdvancedTableTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            plainFlavors = new DataFlavor[3];
            AdvancedTableTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
            AdvancedTableTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
            AdvancedTableTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
            stringFlavors = new DataFlavor[2];
            AdvancedTableTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
            AdvancedTableTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error("error initializing javax.swing.plaf.basic.BasicTranserable", (Throwable)classNotFoundException);
        }
    }

    public AdvancedTableTransferable(String string, String string2) {
        this.plainData = string;
        this.htmlData = string2;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        int n = this.isHTMLSupported() ? htmlFlavors.length : 0;
        int n2 = this.isPlainSupported() ? plainFlavors.length : 0;
        int n3 = this.isPlainSupported() ? stringFlavors.length : 0;
        int n4 = n + n2 + n3;
        DataFlavor[] dataFlavorArray = new DataFlavor[n4];
        int n5 = 0;
        if (n > 0) {
            System.arraycopy(htmlFlavors, 0, dataFlavorArray, n5, n);
            n5 += n;
        }
        if (n2 > 0) {
            System.arraycopy(plainFlavors, 0, dataFlavorArray, n5, n2);
            n5 += n2;
        }
        if (n3 > 0) {
            System.arraycopy(stringFlavors, 0, dataFlavorArray, n5, n3);
            n5 += n3;
        }
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isHTMLFlavor(dataFlavor)) {
            String string = this.getHTMLData();
            String string2 = string = string == null ? "" : string;
            if (String.class.equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringBufferInputStream(string);
            }
        } else if (this.isPlainFlavor(dataFlavor)) {
            String string = this.getPlainData();
            String string3 = string = string == null ? "" : string;
            if (String.class.equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringBufferInputStream(string);
            }
        } else if (this.isStringFlavor(dataFlavor)) {
            String string = this.getPlainData();
            string = string == null ? "" : string;
            return string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    protected boolean isHTMLFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = htmlFlavors;
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isHTMLSupported() {
        return this.htmlData != null;
    }

    protected String getHTMLData() {
        return this.htmlData;
    }

    protected boolean isPlainFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = plainFlavors;
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isPlainSupported() {
        return this.plainData != null;
    }

    protected String getPlainData() {
        return this.plainData;
    }

    protected boolean isStringFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = stringFlavors;
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

