/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.nimbus.painters;

import com.agfa.pacs.listtext.swingx.plaf.nimbus.painters.copied.LoweredBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;

public class CustomTitledLoweredBorder
extends LoweredBorder {
    private static final int RADIUS = 7;
    private static final Insets INSETS = new Insets(1, 10, 10, 10);
    private static Color[] BORDER_COLORS = null;
    private Color[] myColors;

    public static Color[] getBorderColors() {
        NimbusLookAndFeel nimbusLookAndFeel;
        if (BORDER_COLORS == null && (nimbusLookAndFeel = (NimbusLookAndFeel)UIManager.getLookAndFeel()).getDefaults().containsKey("TitledBorder.color")) {
            Color color = nimbusLookAndFeel.getDerivedColor("TitledBorder.color", 0.0f, 0.0f, 0.0f, 0, true);
            BORDER_COLORS = new Color[2];
            CustomTitledLoweredBorder.BORDER_COLORS[0] = CustomTitledLoweredBorder.getLighter(color, 0.85f);
            CustomTitledLoweredBorder.BORDER_COLORS[1] = CustomTitledLoweredBorder.getLighter(color, 0.6f);
        }
        return BORDER_COLORS;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return INSETS;
    }

    @Override
    protected Object[] getExtendedCacheKeys(JComponent jComponent) {
        if (this.myColors == null) {
            if (CustomTitledLoweredBorder.getBorderColors() != null) {
                this.myColors = CustomTitledLoweredBorder.getBorderColors();
            } else {
                Color color = jComponent.getBackground();
                this.myColors = new Color[2];
                this.myColors[0] = CustomTitledLoweredBorder.getLighter(color, 0.85f);
                this.myColors[1] = CustomTitledLoweredBorder.getLighter(color, 0.6f);
            }
        }
        return this.myColors;
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, JComponent jComponent, int n, int n2, Object[] objectArray) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor((Color)objectArray[0]);
        graphics2D.fillRoundRect(2, 2, n - 4, n2 - 4, 7, 7);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor((Color)objectArray[1]);
        graphics2D.drawRoundRect(2, 2, n - 4, n2 - 4, 7, 7);
    }

    private static Color getLighter(Color color, float f) {
        return new Color(Math.min((int)((float)color.getRed() / f), 255), Math.min((int)((float)color.getGreen() / f), 255), Math.min((int)((float)color.getBlue() / f), 255));
    }
}

