/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.listtext.swingx.plaf.ILookAndFeelTheme;
import com.agfa.pacs.listtext.swingx.plaf.ImpaxLookAndFeel;
import com.agfa.pacs.listtext.swingx.plaf.nimbus.AgfaNimbusLookAndFeel;
import com.agfa.pacs.listtext.swingx.plaf.nimbus.theme.BlueNimbusTheme;
import com.agfa.pacs.listtext.swingx.plaf.nimbus.theme.GrayNimbusTheme;
import com.agfa.pacs.listtext.swingx.plaf.nimbus.theme.GreenNimbusTheme;
import com.agfa.pacs.logging.ALogger;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class LookAndFeelManager {
    private static final ALogger log = ALogger.getLogger(LookAndFeelManager.class);
    private static final String LAF_CONFIG_KEY = "listtext.lta.ui.laf";
    private static LookAndFeelManager instance;
    private ILookAndFeelTheme<? extends LookAndFeel> theme;
    private boolean isMonochromeLookAndFeel;

    private LookAndFeelManager() {
    }

    public static synchronized LookAndFeelManager getInstance() {
        if (instance == null) {
            instance = new LookAndFeelManager();
        }
        return instance;
    }

    public boolean isMonochromeLookAndFeel() {
        return this.isMonochromeLookAndFeel;
    }

    public ILookAndFeelTheme<? extends LookAndFeel> getTheme() {
        return this.theme;
    }

    public synchronized void initLookAndFeel() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        ImpaxLookAndFeel impaxLookAndFeel = this.getPreferredLookAndFeel();
        if (!impaxLookAndFeel.getName().equalsIgnoreCase(lookAndFeel.getID())) {
            try {
                AgfaNimbusLookAndFeel agfaNimbusLookAndFeel = null;
                if (ImpaxLookAndFeel.NIMBUS_GRAY == impaxLookAndFeel || ImpaxLookAndFeel.NIMBUS_BLUE == impaxLookAndFeel && this.isMonochromeEnvironment()) {
                    this.isMonochromeLookAndFeel = true;
                    agfaNimbusLookAndFeel = new AgfaNimbusLookAndFeel();
                    GrayNimbusTheme grayNimbusTheme = new GrayNimbusTheme();
                    grayNimbusTheme.init(agfaNimbusLookAndFeel);
                    if (ImpaxLookAndFeel.NIMBUS_BLUE == impaxLookAndFeel || ImpaxLookAndFeel.NIMBUS_GREEN == impaxLookAndFeel) {
                        log.info("Using nimbus-greylevel theme as of monochrome graphics environment!");
                    }
                    this.theme = grayNimbusTheme;
                } else if (ImpaxLookAndFeel.NIMBUS_BLUE == impaxLookAndFeel) {
                    agfaNimbusLookAndFeel = new AgfaNimbusLookAndFeel();
                    BlueNimbusTheme blueNimbusTheme = new BlueNimbusTheme();
                    blueNimbusTheme.init(agfaNimbusLookAndFeel);
                    this.theme = blueNimbusTheme;
                } else if (ImpaxLookAndFeel.NIMBUS_GREEN == impaxLookAndFeel) {
                    agfaNimbusLookAndFeel = new AgfaNimbusLookAndFeel();
                    GreenNimbusTheme greenNimbusTheme = new GreenNimbusTheme();
                    greenNimbusTheme.init(agfaNimbusLookAndFeel);
                    this.theme = greenNimbusTheme;
                }
                UIManager.setLookAndFeel(agfaNimbusLookAndFeel);
            }
            catch (Throwable throwable) {
                log.error("Initializing look-and-feel failed!", throwable);
            }
        }
    }

    private ImpaxLookAndFeel getPreferredLookAndFeel() {
        try {
            int n = (int)ConfigurationProviderFactory.getConfig().getLong(LAF_CONFIG_KEY);
            return ImpaxLookAndFeel.valueOf(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            log.info("Preferred look-and-feel is not supported - Using default nimbus-blue look-and-feel!");
        }
        catch (Exception exception) {
            log.info("No preferred look-and-feel specified - Using default nimbus-blue look-and-feel!");
        }
        return ImpaxLookAndFeel.NIMBUS_BLUE;
    }

    private boolean isMonochromeEnvironment() {
        GraphicsDevice[] graphicsDeviceArray = null;
        if (!Product.isHeadless()) {
            try {
                graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            }
            catch (HeadlessException headlessException) {
                log.warn("No screens available in headless mode.");
            }
        }
        if (graphicsDeviceArray != null) {
            Boolean bl = null;
            try {
                GraphicsDevice[] graphicsDeviceArray2 = graphicsDeviceArray;
                int n = graphicsDeviceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GraphicsDevice graphicsDevice = graphicsDeviceArray2[n2];
                    GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                    int n3 = graphicsDevice.getDisplayMode().getBitDepth();
                    if (graphicsConfiguration.getColorModel().getNumColorComponents() >= 3 && (n3 <= 0 || n3 > 10) && graphicsConfiguration.getColorModel().getColorSpace().getType() != 6) {
                        bl = false;
                        break;
                    }
                    bl = true;
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                log.error("Could not perform gray-scale detection", throwable);
            }
            if (bl != null && bl.booleanValue()) {
                return true;
            }
        }
        return false;
    }
}

