/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class GridLayout2
implements LayoutManager {
    private int hgap = 10;
    private int vgap = 10;
    private int nCols = 1;

    public GridLayout2(int n, int n2, int n3) {
        this.nCols = n;
        this.hgap = n2;
        this.vgap = n3;
    }

    public GridLayout2() {
        this(1, 10, 10);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        Dimension dimension = this.getComponentDimension(container);
        int n3 = container.getComponentCount();
        int n4 = this.computeRowCount(n3);
        n += this.nCols * dimension.width;
        n2 += n4 * dimension.height;
        return new Dimension(n += (this.nCols - 1) * this.hgap, n2 += (n4 - 1) * this.vgap);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = 0;
        Dimension dimension = this.getComponentDimension(container);
        Component[] componentArray = container.getComponents();
        int n4 = componentArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Component component = componentArray[n5];
            component.setBounds(n, n2, dimension.width, dimension.height);
            if (++n3 >= this.nCols) {
                n3 = 0;
                n = insets.left;
                n2 += dimension.height + this.vgap;
            } else {
                n += dimension.width + this.hgap;
            }
            ++n5;
        }
    }

    public Dimension getComponentDimension(Container container) {
        int n = 0;
        int n2 = 0;
        Dimension dimension = null;
        Component[] componentArray = container.getComponents();
        int n3 = componentArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            dimension = component.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
            ++n4;
        }
        return new Dimension(n, n2);
    }

    public int getColumnCount() {
        return this.nCols;
    }

    public void setColumnCount(int n) {
        this.nCols = n;
    }

    private int computeRowCount(int n) {
        return (int)Math.ceil((double)n / (double)this.nCols);
    }
}

