/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.icon.impl;

import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconEventHandler;
import com.agfa.pacs.listtext.swingx.icon.PIconListener;
import com.agfa.pacs.listtext.swingx.icon.PIconLoader;
import com.agfa.pacs.listtext.swingx.icon.PIconSource;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.ImageIcon;

public abstract class AbstractPIcon
implements PIcon,
Serializable {
    private static final ALogger log = ALogger.getLogger(AbstractPIcon.class);
    private ImageIcon defaultIcon;
    private final Map<Integer, ImageIcon> prerenderedIcons = new HashMap<Integer, ImageIcon>(3);
    private final CountDownLatch loadingLatch = new CountDownLatch(1);
    private String description;
    private List<PIconListener> listeners;

    protected AbstractPIcon(String string) {
        this.description = string;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    private void setDefaultIcons(ImageIcon[] imageIconArray) {
        if (imageIconArray != null && imageIconArray.length > 0) {
            this.defaultIcon = imageIconArray[0];
            ImageIcon[] imageIconArray2 = imageIconArray;
            int n = imageIconArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImageIcon imageIcon = imageIconArray2[n2];
                if (imageIcon != null) {
                    this.prerenderedIcons.put(imageIcon.getIconHeight(), imageIcon);
                }
                ++n2;
            }
        }
    }

    @Override
    public void load(PIconSource pIconSource) {
        try {
            this.setDefaultIcons(this.createDefaultIcons(pIconSource));
        }
        finally {
            this.loadingLatch.countDown();
            if (this.listeners != null) {
                PIconEventHandler.INSTANCE.notifyIconLoaded(this);
            }
        }
    }

    protected abstract ImageIcon[] createDefaultIcons(PIconSource var1);

    @Override
    public synchronized void setLoadListener(PIconListener pIconListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PIconListener>(1);
        }
        this.listeners.add(pIconListener);
        if (this.loadingLatch.getCount() <= 0L) {
            PIconEventHandler.INSTANCE.notifyIconLoaded(this);
        }
    }

    public synchronized void notifyListener() {
        if (this.listeners != null) {
            for (PIconListener pIconListener : this.listeners) {
                pIconListener.iconLoaded(this);
            }
            this.listeners = null;
        }
    }

    @Override
    public int getIconHeight() {
        this.ensureIconLoaded();
        if (this.defaultIcon == null) {
            return 0;
        }
        return this.defaultIcon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        this.ensureIconLoaded();
        if (this.defaultIcon == null) {
            return 0;
        }
        return this.defaultIcon.getIconWidth();
    }

    @Override
    public Image getImage() {
        this.ensureIconLoaded();
        if (this.defaultIcon == null) {
            return null;
        }
        return this.defaultIcon.getImage();
    }

    @Override
    public ImageIcon darkenIcon(float f) {
        this.ensureIconLoaded();
        return IconUtil.darkenIcon(this.defaultIcon, f);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.ensureIconLoaded();
        if (this.defaultIcon != null) {
            this.defaultIcon.paintIcon(component, graphics, n, n2);
        }
    }

    @Override
    public ImageIcon scaleToHeight(int n) {
        this.ensureIconLoaded();
        ImageIcon imageIcon = this.prerenderedIcons.get(n);
        if (imageIcon == null) {
            imageIcon = this.scaleIcon(n);
        }
        return imageIcon;
    }

    protected abstract ImageIcon scaleIcon(int var1);

    @Override
    public void ensureIconLoaded() {
        PIconLoader.getInstance().priorize(this);
        try {
            this.loadingLatch.await();
        }
        catch (InterruptedException interruptedException) {
            log.debug("Waiting for icon loading interrupted.", (Throwable)interruptedException);
        }
    }

    public String toString() {
        return this.description;
    }
}

