/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.icon;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconLoader;
import com.agfa.pacs.logging.ALogger;

public class PIconFactory {
    private static final ALogger log = ALogger.getLogger(PIconFactory.class);
    private final boolean isMonochromeMonitor;
    private final int[] defaultIconHeights;

    public PIconFactory(IComponentFactory iComponentFactory, int n) {
        this(!iComponentFactory.isOnColorMonitor(), iComponentFactory.scaleInt(n));
    }

    protected PIconFactory(boolean bl, int ... nArray) {
        this.isMonochromeMonitor = bl;
        this.defaultIconHeights = nArray;
    }

    public static PIconFactory createdAutoScalingIconFactory(IComponentFactory iComponentFactory, int n) {
        return new PIconFactory(iComponentFactory, n);
    }

    public static PIconFactory createdFixedSizeIconFactory(boolean bl, int ... nArray) {
        return new PIconFactory(bl, nArray);
    }

    public PIcon loadIcon(Class<?> clazz, String string) {
        if (clazz == null) {
            clazz = this.getClass();
        }
        return this.loadIcon(clazz.getClassLoader(), string);
    }

    public PIcon loadIcon(ClassLoader classLoader, String string) {
        try {
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            return PIconLoader.getInstance().loadIcon(classLoader, string, this.isMonochromeMonitor, this.defaultIconHeights);
        }
        catch (Exception exception) {
            log.error("Loading icon failed: " + string, (Throwable)exception);
            return null;
        }
    }

    public PIcon loadSvgIconFromXml(String string, String string2) {
        try {
            return PIconLoader.getInstance().loadSvgIconFromXml(string, string2, this.defaultIconHeights);
        }
        catch (Exception exception) {
            log.error("Loading icon '" + string + "' from literal definition failed.", (Throwable)exception);
            return null;
        }
    }
}

