/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends AbstractTableModel {
    private static final long serialVersionUID = -7732491265855989116L;
    protected TableModel tableModel;
    private int maxSortLevel;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator<Date> DATE_COMPARATOR = new Comparator<Date>(){

        @Override
        public int compare(Date date, Date date2) {
            return date.compareTo(date2);
        }
    };
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    };
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private Map columnComparators = new HashMap();
    private List sortingColumns = new ArrayList();

    private TableSorter() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
        this.setColumnComparator(Date.class, DATE_COMPARATOR);
        this.setColumnComparator(String.class, Collator.getInstance());
    }

    public TableSorter(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSortingState() {
        TableModel tableModel = this.tableModel;
        synchronized (tableModel) {
            this.viewToModel = null;
            this.modelToView = null;
        }
    }

    public int getMaxSortLevel() {
        return this.maxSortLevel;
    }

    public void setMaxSortLevel(int n) {
        this.maxSortLevel = n;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer tableCellRenderer = this.tableHeader.getDefaultRenderer();
            if (tableCellRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public void uninstall() {
        this.tableHeader.removeMouseListener(this.mouseListener);
        TableCellRenderer tableCellRenderer = this.tableHeader.getDefaultRenderer();
        if (tableCellRenderer instanceof SortableHeaderRenderer) {
            this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).getOriginalRenderer());
        }
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private Directive getDirective(int n) {
        int n2 = 0;
        while (n2 < this.sortingColumns.size()) {
            Directive directive = (Directive)this.sortingColumns.get(n2);
            if (directive.column == n) {
                return directive;
            }
            ++n2;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int n) {
        return this.getDirective(n).direction;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void setSortingStatus(int n, int n2) {
        Directive directive = this.getDirective(n);
        int n3 = -1;
        if (directive != EMPTY_DIRECTIVE) {
            n3 = this.sortingColumns.indexOf(directive);
            this.sortingColumns.remove(directive);
        }
        if (n2 != 0) {
            if (n3 >= 0) {
                this.sortingColumns.add(n3, new Directive(n, n2));
            } else {
                this.sortingColumns.add(new Directive(n, n2));
            }
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int n, int n2) {
        Directive directive = this.getDirective(n);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        if (directive.direction == -1) {
            Directive directive2 = (Directive)this.sortingColumns.get(0);
            if (directive2.column == n) {
                return UIManager.getIcon("triangle.down.filled");
            }
            return UIManager.getIcon("Common.triangledownIcon");
        }
        if (directive.direction == 1) {
            Directive directive3 = (Directive)this.sortingColumns.get(0);
            if (directive3.column == n) {
                return UIManager.getIcon("triangle.up.filled");
            }
            return UIManager.getIcon("Common.triangleupIcon");
        }
        return null;
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class clazz, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(clazz);
        } else {
            this.columnComparators.put(clazz, comparator);
        }
    }

    protected Comparator getComparator(int n) {
        Class<?> clazz = this.tableModel.getColumnClass(n);
        Comparator comparator = (Comparator)this.columnComparators.get(clazz);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMAPRATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            TableModel tableModel = this.tableModel;
            synchronized (tableModel) {
                if (this.viewToModel != null) {
                    return this.viewToModel;
                }
                int n = this.tableModel.getRowCount();
                this.viewToModel = new Row[n];
                int n2 = 0;
                while (n2 < n) {
                    this.viewToModel[n2] = new Row(n2);
                    ++n2;
                }
                if (this.isSorting()) {
                    Arrays.sort(this.viewToModel);
                }
            }
        }
        return this.viewToModel;
    }

    public int modelIndex(int n) {
        Row[] rowArray = this.getViewToModel();
        if (n >= rowArray.length || rowArray[n] == null) {
            return -1;
        }
        return rowArray[n].modelIndex;
    }

    private int[] getModelToView() {
        int n = this.getViewToModel().length;
        this.modelToView = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.modelToView[this.modelIndex((int)n2)] = n2;
            ++n2;
        }
        return this.modelToView;
    }

    @Override
    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.tableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.tableModel.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.tableModel.isCellEditable(this.modelIndex(n), n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.tableModel.getValueAt(this.modelIndex(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.tableModel.setValueAt(object, this.modelIndex(n), n2);
    }

    public int getModelRowIndex(int n) {
        return this.modelIndex(n);
    }

    public int getViewRowIndex(int n) {
        return this.getModelToView()[n];
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int n, int n2) {
            this.column = n;
            this.direction = n2;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n2 != -1) {
                int n3 = TableSorter.this.sortingColumns.size();
                int n4 = TableSorter.this.getSortingStatus(n2);
                if (mouseEvent.getButton() == 1) {
                    if (n3 >= 1 && n4 == 0) {
                        TableSorter.this.cancelSorting();
                    }
                } else if (mouseEvent.getButton() == 2 && TableSorter.this.maxSortLevel == 2 && n3 >= 2 && n4 == 0) {
                    TableSorter.this.cancelSorting();
                }
                if (n4 == -1) {
                    n4 = 1;
                } else if (n4 == 0) {
                    n4 = -1;
                } else if (n4 == 1) {
                    n4 = 0;
                }
                TableSorter.this.setSortingStatus(n2, n4);
            }
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int n) {
            this.modelIndex = n;
        }

        public int compareTo(Object object) {
            int n = this.modelIndex;
            int n2 = ((Row)object).modelIndex;
            for (Directive directive : TableSorter.this.sortingColumns) {
                int n3 = directive.column;
                Object object2 = TableSorter.this.tableModel.getValueAt(n, n3);
                Object object3 = TableSorter.this.tableModel.getValueAt(n2, n3);
                int n4 = 0;
                n4 = object2 == null && object3 == null ? 0 : (object2 == null ? -1 : (object3 == null ? 1 : TableSorter.this.getComparator(n3).compare(object2, object3)));
                if (n4 == 0) continue;
                return directive.direction == -1 ? -n4 : n4;
            }
            return 0;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        private TableCellRenderer getOriginalRenderer() {
            return this.tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(2);
                int n3 = jTable.convertColumnIndexToModel(n2);
                jLabel.setIcon(TableSorter.this.getHeaderRendererIcon(n3, jLabel.getFont().getSize()));
            }
            return component;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (!TableSorter.this.isSorting()) {
                TableSorter.this.clearSortingState();
                TableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            if (tableModelEvent.getFirstRow() == -1) {
                TableSorter.this.cancelSorting();
                TableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            int n = tableModelEvent.getColumn();
            if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && n != -1 && TableSorter.this.getSortingStatus(n) == 0 && TableSorter.this.modelToView != null) {
                int n2 = TableSorter.this.getModelToView()[tableModelEvent.getFirstRow()];
                TableSorter.this.fireTableChanged(new TableModelEvent(TableSorter.this, n2, n2, n, tableModelEvent.getType()));
                return;
            }
            if (tableModelEvent.getType() == 1) {
                TableSorter.this.fireTableRowsInserted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
            }
            TableSorter.this.clearSortingState();
            TableSorter.this.fireTableDataChanged();
        }
    }
}

