/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.listtext.swingx.controls.IMultiThumbSliderModel;
import com.agfa.pacs.listtext.swingx.controls.MultiThumbSliderModel;
import com.agfa.pacs.listtext.swingx.controls.Thumb;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JSlider;
import javax.swing.UIManager;

public class JMultiThumbSlider
extends JSlider {
    private static final long serialVersionUID = 2L;
    public static final String DEFAULT_UI_CLASS_ID = "MultiThumbSliderUI";
    private final IComponentFactory componentFactory;
    private final List<Thumb> thumbList = new ArrayList<Thumb>();
    protected boolean areThumbsInitialized = false;

    static {
        UIManager.put(DEFAULT_UI_CLASS_ID, "com.agfa.pacs.listtext.swingx.controls.plaf.basic.BasicMultiThumbSliderUI");
    }

    public JMultiThumbSlider(IComponentFactory iComponentFactory, int n, int n2, int n3) {
        this(iComponentFactory, n2, n3, JMultiThumbSlider.createDefaultInitialValues(n, n2, n3));
    }

    public JMultiThumbSlider(IComponentFactory iComponentFactory, int n, int n2, int ... nArray) {
        this(iComponentFactory, JMultiThumbSlider.loadDefaultIcon(iComponentFactory), n, n2, nArray);
    }

    public JMultiThumbSlider(IComponentFactory iComponentFactory, Icon icon, int n, int n2, int ... nArray) {
        this(iComponentFactory, icon, new MultiThumbSliderModel(n, n2, nArray));
    }

    private JMultiThumbSlider(IComponentFactory iComponentFactory, Icon icon, MultiThumbSliderModel multiThumbSliderModel) {
        super(multiThumbSliderModel);
        this.componentFactory = iComponentFactory;
        int n = multiThumbSliderModel.getCount();
        int n2 = 0;
        while (n2 < n) {
            BoundedRangeModel boundedRangeModel = multiThumbSliderModel.getModel(n2);
            this.thumbList.add(new Thumb(boundedRangeModel, icon));
            ++n2;
        }
        this.areThumbsInitialized = true;
        this.setFocusable(false);
        this.updateUI();
    }

    private static int[] createDefaultInitialValues(int n, int n2, int n3) {
        int[] nArray = new int[n];
        int n4 = n3 / n;
        int n5 = 0;
        while (n5 < n) {
            nArray[n5] = n4 * n5;
            ++n5;
        }
        return nArray;
    }

    private static PIcon loadDefaultIcon(IComponentFactory iComponentFactory) {
        return new PIconFactory(iComponentFactory, 12).loadIcon(JMultiThumbSlider.class, "slider-thumb-icon.svg");
    }

    @Override
    public void updateUI() {
        if (this.areThumbsInitialized) {
            super.updateUI();
        }
    }

    public int getNumberOfThumbs() {
        return this.thumbList.size();
    }

    @Override
    @Deprecated
    public void setModel(BoundedRangeModel boundedRangeModel) throws UnsupportedOperationException {
        if (this.sliderModel != null) {
            throw new UnsupportedOperationException("Changing the model of a JMultiThumbSlider is not allowed.");
        }
        super.setModel(boundedRangeModel);
    }

    @Override
    public IMultiThumbSliderModel getModel() {
        return (IMultiThumbSliderModel)super.getModel();
    }

    @Override
    @Deprecated
    public void setExtent(int n) {
    }

    @Override
    @Deprecated
    public int getValue() {
        return super.getValue();
    }

    @Override
    @Deprecated
    public void setValue(int n) {
        super.setValue(n);
    }

    public List<Thumb> getThumbList() {
        return this.thumbList;
    }

    public Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        for (Thumb thumb : this.thumbList) {
            Icon icon = thumb.getThumbRenderer();
            if (icon == null) continue;
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            if (n > dimension.width) {
                dimension.width = n;
            }
            if (n2 <= dimension.height) continue;
            dimension.height = n2;
        }
        return dimension;
    }

    @Override
    public String getUIClassID() {
        return DEFAULT_UI_CLASS_ID;
    }

    @Override
    public void setLabelTable(Dictionary dictionary) {
        if (dictionary != null) {
            Enumeration enumeration = dictionary.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (!(v instanceof Component)) continue;
                this.componentFactory.scaleFont((Component)v);
            }
        }
        super.setLabelTable(dictionary);
    }
}

