/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.listtext.swingx.controls.ArrowIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class DropDownButtonComponent
extends JPanel {
    private JPopupMenu popupMenu;
    private JButton actionButton;
    private JButton arrowButton;
    private Color color;

    public DropDownButtonComponent(IComponentFactory iComponentFactory, Action ... actionArray) {
        this(iComponentFactory, (Color)null, actionArray);
    }

    public DropDownButtonComponent(IComponentFactory iComponentFactory, Color color, Action ... actionArray) {
        if (actionArray != null && actionArray.length > 0) {
            this.color = color == null ? Color.white : color;
            this.createButtonComponents(iComponentFactory, actionArray);
            this.createPopupMenu(iComponentFactory, actionArray);
        }
    }

    private void createButtonComponents(IComponentFactory iComponentFactory, Action ... actionArray) {
        this.actionButton = iComponentFactory.createButton();
        this.arrowButton = iComponentFactory.createButton();
        this.popupMenu = new JPopupMenu();
        this.setActionButton(actionArray);
        this.setArrowButton();
        this.arrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DropDownButtonComponent.this.popupMenu.show(DropDownButtonComponent.this, 0, (int)DropDownButtonComponent.this.getPreferredSize().getHeight());
            }
        });
        this.add(this.actionButton);
        this.add(this.arrowButton);
        this.setOpaque(false);
    }

    private void setActionButton(Action[] actionArray) {
        this.actionButton.setContentAreaFilled(false);
        this.actionButton.setFocusPainted(true);
        this.actionButton.setBorder(null);
        this.actionButton.setBorderPainted(false);
        this.actionButton.setMargin(new Insets(0, 0, 0, 0));
        int n = 0;
        int n2 = 0;
        while (n2 < actionArray.length) {
            this.actionButton.setIcon((Icon)actionArray[n2].getValue("SmallIcon"));
            this.actionButton.setText((String)actionArray[n2].getValue("Name"));
            if (this.actionButton.getPreferredSize().getWidth() > (double)n) {
                n = (int)this.actionButton.getPreferredSize().getWidth();
            }
            ++n2;
        }
        this.actionButton.setPreferredSize(new Dimension(n, (int)this.actionButton.getPreferredSize().getHeight()));
        this.updateActionButton(actionArray[0]);
    }

    private void updateActionButton(Action action) {
        this.actionButton.setAction(action);
        this.actionButton.setIcon((Icon)action.getValue("SmallIcon"));
        this.actionButton.setText((String)action.getValue("Name"));
    }

    private void setArrowButton() {
        this.arrowButton.setIcon(ArrowIcon.getDownArrowIcon(this.color));
        this.arrowButton.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
        this.arrowButton.setBorderPainted(false);
        this.arrowButton.setContentAreaFilled(false);
    }

    private void createPopupMenu(IComponentFactory iComponentFactory, Action[] actionArray) {
        int n = 0;
        while (n < actionArray.length) {
            JMenuItem jMenuItem = iComponentFactory.createMenuItem((Action)new PopupMenuAction(actionArray[n]));
            this.popupMenu.add(jMenuItem);
            ++n;
        }
    }

    private class PopupMenuAction
    extends AbstractAction {
        private final Action delegate;

        public PopupMenuAction(Action action) {
            super((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
            this.delegate = action;
            this.putValue("ShortDescription", action.getValue("ShortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.delegate.actionPerformed(actionEvent);
            DropDownButtonComponent.this.updateActionButton(this.delegate);
        }
    }
}

