/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTextField;

public class ClearableTextField
extends JTextField
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private int clearX1;
    private int clearY1;
    private int clearX2;
    private int clearY2;
    private String infoText = null;

    public ClearableTextField() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addComponentListener(this);
        this.setMargin(new Insets(0, 0, 0, 10));
    }

    public void setInfoText(String string) {
        this.infoText = string;
    }

    private void setupClearAreaBoundaries() {
        Dimension dimension = this.getSize();
        int n = dimension.height / 4;
        this.clearY1 = (dimension.height - n) / 2;
        this.clearY2 = (dimension.height + n) / 2;
        this.clearX1 = dimension.width - dimension.height / 2 - n / 2;
        this.clearX2 = this.clearX1 + n;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.getText().length() > 0) {
            this.paintCross(graphics);
        } else if (this.infoText != null) {
            graphics.setColor(Color.GRAY);
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawString(this.infoText, 8, (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2 - 1);
        }
    }

    private void paintCross(Graphics graphics) {
        graphics.setColor(Color.BLACK);
        graphics.drawLine(this.clearX1, this.clearY1, this.clearX2, this.clearY2);
        graphics.drawLine(this.clearX2, this.clearY1, this.clearX1, this.clearY2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = (int)mouseEvent.getPoint().getX();
        if (n >= this.clearX1) {
            this.setText("");
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getText().length() > 0) {
            int n = (int)mouseEvent.getPoint().getX();
            if (n >= this.clearX1) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(2));
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.setupClearAreaBoundaries();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

