/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.useradmin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.service.useradmin.UserAdminPermissionCollection;

public final class UserAdminPermission
extends BasicPermission {
    static final long serialVersionUID = -1179971692401603789L;
    public static final String ADMIN = "admin";
    public static final String CHANGE_PROPERTY = "changeProperty";
    private static final int ACTION_CHANGE_PROPERTY = 1;
    public static final String CHANGE_CREDENTIAL = "changeCredential";
    private static final int ACTION_CHANGE_CREDENTIAL = 2;
    public static final String GET_CREDENTIAL = "getCredential";
    private static final int ACTION_GET_CREDENTIAL = 4;
    private static final int ACTION_ALL = 7;
    static final int ACTION_NONE = 0;
    private volatile String actions = null;
    private transient int action_mask;

    public UserAdminPermission(String string, String string2) {
        this(string, UserAdminPermission.parseActions(string2));
    }

    UserAdminPermission(String string, int n) {
        super(string);
        this.setTransients(n);
    }

    private synchronized void setTransients(int n) {
        if (this.getName().equals(ADMIN)) {
            if (n != 0) {
                throw new IllegalArgumentException("Actions specified for no-action UserAdminPermission");
            }
        } else if (n == 0 || (n & 7) != n) {
            throw new IllegalArgumentException("Invalid action string");
        }
        this.action_mask = n;
    }

    synchronized int getActionsMask() {
        return this.action_mask;
    }

    private static int parseActions(String string) {
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return n;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (n2 >= 12 && UserAdminPermission.match_get(cArray, n2 - 10) && UserAdminPermission.match_credential(cArray, n2)) {
                n3 = 13;
                n |= 4;
            } else if (n2 >= 13 && UserAdminPermission.match_change(cArray, n2 - 8) && UserAdminPermission.match_property(cArray, n2)) {
                n3 = 14;
                n |= 1;
            } else if (n2 >= 15 && UserAdminPermission.match_change(cArray, n2 - 10) && UserAdminPermission.match_credential(cArray, n2)) {
                n3 = 16;
                n |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid permission: " + string);
        }
        return n;
    }

    private static boolean match_change(char[] cArray, int n) {
        return !(cArray[n - 5] != 'c' && cArray[n - 5] != 'C' || cArray[n - 4] != 'h' && cArray[n - 4] != 'H' || cArray[n - 3] != 'a' && cArray[n - 3] != 'A' || cArray[n - 2] != 'n' && cArray[n - 2] != 'N' || cArray[n - 1] != 'g' && cArray[n - 1] != 'G' || cArray[n - 0] != 'e' && cArray[n - 0] != 'E');
    }

    private static boolean match_get(char[] cArray, int n) {
        return !(cArray[n - 2] != 'g' && cArray[n - 2] != 'G' || cArray[n - 1] != 'e' && cArray[n - 1] != 'E' || cArray[n - 0] != 't' && cArray[n - 0] != 'T');
    }

    private static boolean match_property(char[] cArray, int n) {
        return !(cArray[n - 7] != 'p' && cArray[n - 7] != 'P' || cArray[n - 6] != 'r' && cArray[n - 6] != 'R' || cArray[n - 5] != 'o' && cArray[n - 5] != 'O' || cArray[n - 4] != 'p' && cArray[n - 4] != 'P' || cArray[n - 3] != 'e' && cArray[n - 3] != 'E' || cArray[n - 2] != 'r' && cArray[n - 2] != 'R' || cArray[n - 1] != 't' && cArray[n - 1] != 'T' || cArray[n - 0] != 'y' && cArray[n - 0] != 'Y');
    }

    private static boolean match_credential(char[] cArray, int n) {
        return !(cArray[n - 9] != 'c' && cArray[n - 9] != 'C' || cArray[n - 8] != 'r' && cArray[n - 8] != 'R' || cArray[n - 7] != 'e' && cArray[n - 7] != 'E' || cArray[n - 6] != 'd' && cArray[n - 6] != 'D' || cArray[n - 5] != 'e' && cArray[n - 5] != 'E' || cArray[n - 4] != 'n' && cArray[n - 4] != 'N' || cArray[n - 3] != 't' && cArray[n - 3] != 'T' || cArray[n - 2] != 'i' && cArray[n - 2] != 'I' || cArray[n - 1] != 'a' && cArray[n - 1] != 'A' || cArray[n - 0] != 'l' && cArray[n - 0] != 'L');
    }

    public boolean implies(Permission permission) {
        if (permission instanceof UserAdminPermission) {
            UserAdminPermission userAdminPermission = (UserAdminPermission)permission;
            int n = this.getActionsMask();
            int n2 = userAdminPermission.getActionsMask();
            return (n2 & n) == n2 && (n2 != 0 || n == 0) && super.implies(permission);
        }
        return false;
    }

    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = this.getActionsMask();
            if ((n & 2) == 2) {
                stringBuffer.append(CHANGE_CREDENTIAL);
                bl = true;
            }
            if ((n & 1) == 1) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(CHANGE_PROPERTY);
                bl = true;
            }
            if ((n & 4) == 4) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(GET_CREDENTIAL);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    public PermissionCollection newPermissionCollection() {
        return new UserAdminPermissionCollection();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UserAdminPermission)) {
            return false;
        }
        UserAdminPermission userAdminPermission = (UserAdminPermission)object;
        return this.getActionsMask() == userAdminPermission.getActionsMask() && this.getName().equals(userAdminPermission.getName());
    }

    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(UserAdminPermission.parseActions(this.actions));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" \"");
        stringBuffer.append(this.getName());
        String string = this.getActions();
        if (string.length() > 0) {
            stringBuffer.append("\" \"");
            stringBuffer.append(string);
        }
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }
}

