/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.service.event.TopicPermission;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TopicPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -614647783533924048L;
    private transient Map<String, TopicPermission> permissions = new HashMap<String, TopicPermission>();
    private boolean all_allowed = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", class$java$util$Hashtable == null ? (class$java$util$Hashtable = TopicPermissionCollection.class$("java.util.Hashtable")) : class$java$util$Hashtable), new ObjectStreamField("all_allowed", Boolean.TYPE)};
    static /* synthetic */ Class class$java$util$Hashtable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof TopicPermission)) {
            throw new IllegalArgumentException(((Object)new StringBuffer().append("invalid permission: ").append(permission)).toString());
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        TopicPermission topicPermission = (TopicPermission)permission;
        String string = topicPermission.getName();
        int n = topicPermission.getActionsMask();
        TopicPermissionCollection topicPermissionCollection = this;
        synchronized (topicPermissionCollection) {
            TopicPermission topicPermission2 = this.permissions.get(string);
            if (topicPermission2 != null) {
                int n2 = topicPermission2.getActionsMask();
                if (n2 != n) {
                    this.permissions.put(string, new TopicPermission(string, n2 | n));
                }
            } else {
                this.permissions.put(string, topicPermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        int n;
        TopicPermission topicPermission;
        if (!(permission instanceof TopicPermission)) {
            return false;
        }
        TopicPermission topicPermission2 = (TopicPermission)permission;
        String string = topicPermission2.getName();
        int n2 = topicPermission2.getActionsMask();
        int n3 = 0;
        TopicPermissionCollection topicPermissionCollection = this;
        synchronized (topicPermissionCollection) {
            if (this.all_allowed && (topicPermission = this.permissions.get("*")) != null && ((n3 |= topicPermission.getActionsMask()) & n2) == n2) {
                return true;
            }
            topicPermission = this.permissions.get(string);
        }
        if (topicPermission != null && ((n3 |= topicPermission.getActionsMask()) & n2) == n2) {
            return true;
        }
        int n4 = string.length() - 1;
        while ((n = string.lastIndexOf("/", n4)) != -1) {
            string = ((Object)new StringBuffer().append(string.substring(0, n + 1)).append("*")).toString();
            TopicPermissionCollection topicPermissionCollection2 = this;
            synchronized (topicPermissionCollection2) {
                topicPermission = this.permissions.get(string);
            }
            if (topicPermission != null && ((n3 |= topicPermission.getActionsMask()) & n2) == n2) {
                return true;
            }
            n4 = n - 1;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<TopicPermission> arrayList = new ArrayList<TopicPermission>(this.permissions.values());
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, TopicPermission> hashtable = new Hashtable<String, TopicPermission>(this.permissions);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", hashtable);
        putField.put("all_allowed", this.all_allowed);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.permissions = new HashMap<String, TopicPermission>(hashtable);
        this.all_allowed = getField.get("all_allowed", false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

