/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class DataArea {
    private static final String OPTION_DEBUG = "org.eclipse.equinox.common/debug";
    static final String F_META_AREA = ".metadata";
    static final String F_PLUGIN_DATA = ".plugins";
    static final String F_LOG = ".log";
    static final String F_TRACE = "trace.log";
    static final String PREFERENCES_FILE_NAME = "pref_store.ini";
    private IPath location;
    private boolean initialized = false;

    protected void assertLocationInitialized() throws IllegalStateException {
        if (this.location != null && this.initialized) {
            return;
        }
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new IllegalStateException(CommonMessages.activator_not_available);
        }
        Location location = activator.getInstanceLocation();
        if (location == null) {
            throw new IllegalStateException(CommonMessages.meta_noDataModeSpecified);
        }
        try {
            URL uRL = location.getURL();
            if (uRL == null) {
                throw new IllegalStateException(CommonMessages.meta_instanceDataUnspecified);
            }
            this.location = new Path(new File(uRL.getFile()).toString());
            this.initializeLocation();
        }
        catch (CoreException coreException) {
            throw new IllegalStateException(coreException.getMessage());
        }
    }

    public IPath getMetadataLocation() throws IllegalStateException {
        this.assertLocationInitialized();
        return this.location.append(F_META_AREA);
    }

    public IPath getInstanceDataLocation() throws IllegalStateException {
        this.assertLocationInitialized();
        return this.location;
    }

    public IPath getLogLocation() throws IllegalStateException {
        File file;
        FrameworkLog frameworkLog;
        if (this.isInstanceLocationSet()) {
            this.assertLocationInitialized();
        }
        if ((frameworkLog = Activator.getDefault().getFrameworkLog()) != null && (file = frameworkLog.getFile()) != null) {
            return new Path(file.getAbsolutePath());
        }
        if (this.location == null) {
            throw new IllegalStateException(CommonMessages.meta_instanceDataUnspecified);
        }
        return this.location.append(F_META_AREA).append(F_LOG);
    }

    public IPath getTraceLocation() throws IllegalStateException {
        DebugOptions debugOptions = Activator.getDefault().getDebugOptions();
        if (debugOptions == null) {
            return null;
        }
        return new Path(debugOptions.getFile().getAbsolutePath());
    }

    private boolean isInstanceLocationSet() {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return false;
        }
        Location location = activator.getInstanceLocation();
        if (location == null) {
            return false;
        }
        return location.isSet();
    }

    public IPath getStateLocation(Bundle bundle) throws IllegalStateException {
        this.assertLocationInitialized();
        return this.getStateLocation(bundle.getSymbolicName());
    }

    public IPath getStateLocation(String string) throws IllegalStateException {
        this.assertLocationInitialized();
        return this.getMetadataLocation().append(F_PLUGIN_DATA).append(string);
    }

    public IPath getPreferenceLocation(String string, boolean bl) throws IllegalStateException {
        IPath iPath = this.getStateLocation(string);
        if (bl) {
            iPath.toFile().mkdirs();
        }
        return iPath.append(PREFERENCES_FILE_NAME);
    }

    private void initializeLocation() throws CoreException {
        if (this.location.toFile().exists() && !this.location.toFile().isDirectory()) {
            String string = NLS.bind((String)CommonMessages.meta_notDir, (Object)this.location);
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, string, null));
        }
        if (this.location.getDevice() == null) {
            this.location = new Path(this.location.toFile().getAbsolutePath());
        }
        this.createLocation();
        this.initialized = true;
    }

    private void createLocation() throws CoreException {
        Object object;
        Object object2;
        File file = this.location.append(F_META_AREA).toFile();
        try {
            file.mkdirs();
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CommonMessages.meta_couldNotCreate, (Object)file.getAbsolutePath());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, string, exception));
        }
        if (!file.canWrite()) {
            String string = NLS.bind((String)CommonMessages.meta_readonly, (Object)file.getAbsolutePath());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, string, null));
        }
        IPath iPath = this.location.append(F_META_AREA).append(F_LOG);
        try {
            object2 = Activator.getDefault();
            if (object2 != null) {
                object = ((Activator)object2).getFrameworkLog();
                if (object != null) {
                    object.setFile(iPath.toFile(), true);
                } else if (this.debug()) {
                    System.out.println("ERROR: Unable to acquire log service. Application will proceed, but logging will be disabled.");
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object2 = this.location.append(F_META_AREA).append(F_TRACE);
        object = Activator.getDefault();
        if (object != null) {
            DebugOptions debugOptions = ((Activator)object).getDebugOptions();
            if (debugOptions != null) {
                debugOptions.setFile(object2.toFile());
            } else {
                System.out.println("ERROR: Unable to acquire debug service. Application will proceed, but debugging will be disabled.");
            }
        }
    }

    private boolean debug() {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return false;
        }
        DebugOptions debugOptions = activator.getDebugOptions();
        if (debugOptions == null) {
            return false;
        }
        return debugOptions.getBooleanOption(OPTION_DEBUG, false);
    }
}

