/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.clinicalcode.acr.node;

import com.agfa.pacs.listtext.clinicalcode.acr.ACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRNode;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class AbstractACRNode
implements ACRNode {
    protected ACRCode code;
    protected DefaultMutableTreeNode node;

    public AbstractACRNode(ACRCode aCRCode) {
        this.code = aCRCode;
        this.node = new DefaultMutableTreeNode(this);
    }

    @Override
    public ACRCode getCode() {
        return this.code;
    }

    @Override
    public ACRNode getParent() {
        return (ACRNode)((DefaultMutableTreeNode)this.node.getParent()).getUserObject();
    }

    public ACRNode[] getChildren() {
        return this.getChildrenInt();
    }

    @Override
    public boolean hasChildren() {
        return !this.node.isLeaf();
    }

    @Override
    public int getChildCount() {
        return this.node.getChildCount();
    }

    @Override
    public DefaultMutableTreeNode getAsNode() {
        return this.node;
    }

    public boolean isRootNode() {
        return this.node.isRoot();
    }

    public void removeChild(AbstractACRNode abstractACRNode) {
        if (this != null) {
            ((AbstractACRNode)abstractACRNode.getParent()).node.remove(abstractACRNode.getAsNode());
        }
    }

    public String toString() {
        return this.code.getDescription();
    }

    public boolean equals(Object object) {
        if (object instanceof ACRNode) {
            return this.getCode().equals(((ACRNode)object).getCode());
        }
        return false;
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    protected void finalize() throws Throwable {
        this.node.setUserObject(null);
        super.finalize();
    }

    private ACRNode[] getChildrenInt() {
        ACRNode[] aCRNodeArray = new ACRNode[this.node.getChildCount()];
        int n = 0;
        while (n < aCRNodeArray.length) {
            aCRNodeArray[n] = (ACRNode)((DefaultMutableTreeNode)this.node.getChildAt(n)).getUserObject();
            ++n;
        }
        return aCRNodeArray;
    }
}

