/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.clinicalcode.acr.node;

import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeNode;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRNode;
import com.agfa.pacs.listtext.clinicalcode.acr.code.ACRCodeFactory;
import com.agfa.pacs.listtext.clinicalcode.acr.code.CompositeACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.node.ACRAnatomyNode;
import com.agfa.pacs.listtext.clinicalcode.acr.node.AbstractACRNode;

public class ACRPathologyNode
extends AbstractACRNode {
    private ACRAnatomyNode anatomyNode;

    public ACRPathologyNode(ACRCode aCRCode, ACRAnatomyNode aCRAnatomyNode) {
        super(ACRCodeFactory.createCompositeInstance(aCRAnatomyNode.getCode(), aCRCode));
        this.anatomyNode = aCRAnatomyNode;
    }

    @Override
    public boolean hasBranches() {
        return false;
    }

    @Override
    public int getBranchCount() {
        return 0;
    }

    @Override
    public IClinicalCodeNode[] getBranches() {
        return new IClinicalCodeNode[0];
    }

    @Override
    public ACRNode findNodeForCode(ACRCode aCRCode) {
        if (aCRCode.equals(this.getPathologyCode())) {
            return this;
        }
        ACRNode[] aCRNodeArray = this.getChildren();
        int n = aCRNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ACRNode aCRNode = aCRNodeArray[n2];
            ACRNode aCRNode2 = aCRNode.findNodeForCode(aCRCode);
            if (aCRNode2 != null) {
                return aCRNode2;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getPathologyCode().getDescription();
    }

    public ACRPathologyNode[] getPathologyChildren() {
        return (ACRPathologyNode[])super.getChildren();
    }

    public ACRAnatomyNode getAnatomyNode() {
        return this.anatomyNode;
    }

    public ACRCode getPathologyCode() {
        return ((CompositeACRCode)this.getCode()).getPathologyCode();
    }

    public ACRCode getAnatomyCode() {
        return this.getAnatomyNode().getCode();
    }

    public void addChild(ACRPathologyNode aCRPathologyNode) {
        String string = aCRPathologyNode.getPathologyCode().getId();
        ACRPathologyNode aCRPathologyNode2 = null;
        if (string.length() == 1 && this.isRootNode()) {
            aCRPathologyNode2 = this;
        } else {
            String string2 = string.substring(0, string.length() - 1);
            ACRCode aCRCode = ACRCodeFactory.createPathologyInstance(string2, null);
            aCRPathologyNode2 = (ACRPathologyNode)this.findNodeForCode(aCRCode);
        }
        if (aCRPathologyNode2 != null) {
            aCRPathologyNode2.node.add(aCRPathologyNode.getAsNode());
        }
    }
}

