/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class BundleSignerCondition {
    private static final String CONDITION_TYPE = "org.osgi.service.condpermadmin.BundleSignerCondition";

    public static Condition getCondition(Bundle bundle, ConditionInfo conditionInfo) {
        if (!CONDITION_TYPE.equals(conditionInfo.getType())) {
            throw new IllegalArgumentException("ConditionInfo must be of type \"org.osgi.service.condpermadmin.BundleSignerCondition\"");
        }
        String[] stringArray = conditionInfo.getArgs();
        if (stringArray.length != 1 && stringArray.length != 2) {
            throw new IllegalArgumentException("Illegal number of args: " + stringArray.length);
        }
        Map<X509Certificate, List<X509Certificate>> map = bundle.getSignerCertificates(2);
        boolean bl = false;
        Iterator<List<X509Certificate>> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            List<X509Certificate> list = iterator.next();
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            Iterator<X509Certificate> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                X509Certificate x509Certificate = iterator2.next();
                arrayList.add(x509Certificate.getSubjectDN().getName());
            }
            if (!FrameworkUtil.matchDistinguishedNameChain(stringArray[0], arrayList)) continue;
            bl = true;
            break;
        }
        boolean bl2 = stringArray.length == 2 ? "!".equals(stringArray[1]) : false;
        return bl2 ^ bl ? Condition.TRUE : Condition.FALSE;
    }

    private BundleSignerCondition() {
    }
}

