/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PackagePermissionCollection;
import org.osgi.framework.SignerProperty;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackagePermission
extends BasicPermission {
    static final long serialVersionUID = -5107705877071099135L;
    public static final String EXPORT = "export";
    public static final String EXPORTONLY = "exportonly";
    public static final String IMPORT = "import";
    private static final int ACTION_EXPORT = 1;
    private static final int ACTION_IMPORT = 2;
    private static final int ACTION_ALL = 3;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    final transient Bundle bundle;
    transient Filter filter;
    private volatile transient Map<String, Object> properties;

    public PackagePermission(String string, String string2) {
        this(string, PackagePermission.parseActions(string2));
        if (this.filter != null && (this.action_mask & 3) != 2) {
            throw new IllegalArgumentException("invalid action string for filter expression");
        }
    }

    public PackagePermission(String string, Bundle bundle, String string2) {
        super(string);
        this.setTransients(string, PackagePermission.parseActions(string2));
        this.bundle = bundle;
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        if (this.filter != null) {
            throw new IllegalArgumentException("invalid name");
        }
        if ((this.action_mask & 3) != 2) {
            throw new IllegalArgumentException("invalid action string");
        }
    }

    PackagePermission(String string, int n) {
        super(string);
        this.setTransients(string, n);
        this.bundle = null;
    }

    private void setTransients(String string, int n) {
        if (n == 0 || (n & 3) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
        this.filter = PackagePermission.parseFilter(string);
    }

    /*
     * Unable to fully structure code
     */
    private static int parseActions(String var0) {
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl37
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (!(var4_4 < 5 || var3_3[var4_4 - 5] != 'i' && var3_3[var4_4 - 5] != 'I' || var3_3[var4_4 - 4] != 'm' && var3_3[var4_4 - 4] != 'M' || var3_3[var4_4 - 3] != 'p' && var3_3[var4_4 - 3] != 'P' || var3_3[var4_4 - 2] != 'o' && var3_3[var4_4 - 2] != 'O' || var3_3[var4_4 - 1] != 'r' && var3_3[var4_4 - 1] != 'R' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 6;
                    var2_2 |= 2;
                } else if (!(var4_4 < 5 || var3_3[var4_4 - 5] != 'e' && var3_3[var4_4 - 5] != 'E' || var3_3[var4_4 - 4] != 'x' && var3_3[var4_4 - 4] != 'X' || var3_3[var4_4 - 3] != 'p' && var3_3[var4_4 - 3] != 'P' || var3_3[var4_4 - 2] != 'o' && var3_3[var4_4 - 2] != 'O' || var3_3[var4_4 - 1] != 'r' && var3_3[var4_4 - 1] != 'R' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 6;
                    var2_2 |= 3;
                } else if (!(var4_4 < 9 || var3_3[var4_4 - 9] != 'e' && var3_3[var4_4 - 9] != 'E' || var3_3[var4_4 - 8] != 'x' && var3_3[var4_4 - 8] != 'X' || var3_3[var4_4 - 7] != 'p' && var3_3[var4_4 - 7] != 'P' || var3_3[var4_4 - 6] != 'o' && var3_3[var4_4 - 6] != 'O' || var3_3[var4_4 - 5] != 'r' && var3_3[var4_4 - 5] != 'R' || var3_3[var4_4 - 4] != 't' && var3_3[var4_4 - 4] != 'T' || var3_3[var4_4 - 3] != 'o' && var3_3[var4_4 - 3] != 'O' || var3_3[var4_4 - 2] != 'n' && var3_3[var4_4 - 2] != 'N' || var3_3[var4_4 - 1] != 'l' && var3_3[var4_4 - 1] != 'L' || var3_3[var4_4] != 'y' && var3_3[var4_4] != 'Y')) {
                    var6_6 = 10;
                    var2_2 |= 1;
                } else {
                    throw new IllegalArgumentException(new StringBuffer("invalid permission: ").append(var0).toString());
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(new StringBuffer("invalid permission: ").append(var0).toString());
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl37:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw new IllegalArgumentException(new StringBuffer("invalid permission: ").append(var0).toString());
        }
        return var2_2;
    }

    private static Filter parseFilter(String string) {
        if ((string = string.trim()).charAt(0) != '(') {
            return null;
        }
        try {
            return FrameworkUtil.createFilter(string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof PackagePermission)) {
            return false;
        }
        PackagePermission packagePermission = (PackagePermission)permission;
        if (this.bundle != null) {
            return false;
        }
        if (packagePermission.filter != null) {
            return false;
        }
        return this.implies0(packagePermission, 0);
    }

    boolean implies0(PackagePermission packagePermission, int n) {
        int n2 = packagePermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        Filter filter = this.filter;
        if (filter == null) {
            return super.implies(packagePermission);
        }
        return filter.matches(packagePermission.getProperties());
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = this.action_mask;
            if ((n & 1) == 1) {
                stringBuffer.append(EXPORTONLY);
                bl = true;
            }
            if ((n & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(IMPORT);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new PackagePermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PackagePermission)) {
            return false;
        }
        PackagePermission packagePermission = (PackagePermission)object;
        return this.action_mask == packagePermission.action_mask && this.getName().equals(packagePermission.getName()) && (this.bundle == packagePermission.bundle || this.bundle != null && this.bundle.equals(packagePermission.bundle));
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.bundle != null) {
            n = 31 * n + this.bundle.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.bundle != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(this.getName(), PackagePermission.parseActions(this.actions));
    }

    private Map<String, Object> getProperties() {
        Map<String, Object> map = this.properties;
        if (map != null) {
            return map;
        }
        final HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        hashMap.put("package.name", this.getName());
        if (this.bundle != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SignerProperty signerProperty;
                    hashMap.put("id", new Long(PackagePermission.this.bundle.getBundleId()));
                    hashMap.put("location", PackagePermission.this.bundle.getLocation());
                    String string = PackagePermission.this.bundle.getSymbolicName();
                    if (string != null) {
                        hashMap.put("name", string);
                    }
                    if ((signerProperty = new SignerProperty(PackagePermission.this.bundle)).isBundleSigned()) {
                        hashMap.put("signer", signerProperty);
                    }
                    return null;
                }
            });
        }
        this.properties = hashMap;
        return this.properties;
    }
}

