/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.AdaptPermissionCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SignerProperty;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptPermission
extends BasicPermission {
    private static final long serialVersionUID = 1L;
    public static final String ADAPT = "adapt";
    private static final int ACTION_ADAPT = 1;
    private static final int ACTION_ALL = 1;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    final transient Bundle bundle;
    transient Filter filter;
    private volatile transient Map<String, Object> properties;

    public AdaptPermission(String string, String string2) {
        this(AdaptPermission.parseFilter(string), AdaptPermission.parseActions(string2));
    }

    public AdaptPermission(String string, Bundle bundle, String string2) {
        super(string);
        this.setTransients(null, AdaptPermission.parseActions(string2));
        this.bundle = bundle;
        if (string == null) {
            throw new NullPointerException("adaptClass must not be null");
        }
        if (bundle == null) {
            throw new NullPointerException("adaptableBundle must not be null");
        }
    }

    AdaptPermission(Filter filter, int n) {
        super(filter == null ? "*" : filter.toString());
        this.setTransients(filter, n);
        this.bundle = null;
    }

    private void setTransients(Filter filter, int n) {
        this.filter = filter;
        if (n == 0 || (n & 1) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    /*
     * Unable to fully structure code
     */
    private static int parseActions(String var0) {
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl29
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (!(var4_4 < 4 || var3_3[var4_4 - 4] != 'a' && var3_3[var4_4 - 4] != 'A' || var3_3[var4_4 - 3] != 'd' && var3_3[var4_4 - 3] != 'D' || var3_3[var4_4 - 2] != 'a' && var3_3[var4_4 - 2] != 'A' || var3_3[var4_4 - 1] != 'p' && var3_3[var4_4 - 1] != 'P' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 5;
                    var2_2 |= 1;
                } else {
                    throw new IllegalArgumentException(new StringBuffer("invalid actions: ").append(var0).toString());
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(new StringBuffer("invalid permission: ").append(var0).toString());
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl29:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw new IllegalArgumentException(new StringBuffer("invalid actions: ").append(var0).toString());
        }
        return var2_2;
    }

    private static Filter parseFilter(String string) {
        if ((string = string.trim()).equals("*")) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter(string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof AdaptPermission)) {
            return false;
        }
        AdaptPermission adaptPermission = (AdaptPermission)permission;
        if (this.bundle != null) {
            return false;
        }
        if (adaptPermission.filter != null) {
            return false;
        }
        return this.implies0(adaptPermission, 0);
    }

    boolean implies0(AdaptPermission adaptPermission, int n) {
        int n2 = adaptPermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        Filter filter = this.filter;
        if (filter == null) {
            return true;
        }
        return filter.matches(adaptPermission.getProperties());
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            string = ADAPT;
            this.actions = ADAPT;
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new AdaptPermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdaptPermission)) {
            return false;
        }
        AdaptPermission adaptPermission = (AdaptPermission)object;
        return this.action_mask == adaptPermission.action_mask && this.getName().equals(adaptPermission.getName()) && (this.bundle == adaptPermission.bundle || this.bundle != null && this.bundle.equals(adaptPermission.bundle));
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.bundle != null) {
            n = 31 * n + this.bundle.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.bundle != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(AdaptPermission.parseFilter(this.getName()), AdaptPermission.parseActions(this.actions));
    }

    private Map<String, Object> getProperties() {
        Map<String, Object> map = this.properties;
        if (map != null) {
            return map;
        }
        final HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        hashMap.put("adaptClass", this.getName());
        if (this.bundle != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SignerProperty signerProperty;
                    hashMap.put("id", new Long(AdaptPermission.this.bundle.getBundleId()));
                    hashMap.put("location", AdaptPermission.this.bundle.getLocation());
                    String string = AdaptPermission.this.bundle.getSymbolicName();
                    if (string != null) {
                        hashMap.put("name", string);
                    }
                    if ((signerProperty = new SignerProperty(AdaptPermission.this.bundle)).isBundleSigned()) {
                        hashMap.put("signer", signerProperty);
                    }
                    return null;
                }
            });
        }
        this.properties = hashMap;
        return this.properties;
    }
}

