/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.security.cert.Certificate;
import org.eclipse.osgi.signedcontent.SignerInfo;

public class SignerInfoImpl
implements SignerInfo {
    private final Certificate[] chain;
    private final String mdAlgorithm;
    private volatile Certificate trustAnchor;

    public SignerInfoImpl(Certificate[] certificateArray, Certificate certificate, String string) {
        this.chain = certificateArray;
        this.trustAnchor = certificate;
        this.mdAlgorithm = string;
    }

    public Certificate[] getCertificateChain() {
        return this.chain;
    }

    public Certificate getTrustAnchor() {
        return this.trustAnchor;
    }

    public boolean isTrusted() {
        return this.trustAnchor != null;
    }

    void setTrustAnchor(Certificate certificate) {
        this.trustAnchor = certificate;
    }

    public String getMessageDigestAlgorithm() {
        return this.mdAlgorithm;
    }

    public int hashCode() {
        int n = this.mdAlgorithm.hashCode();
        int n2 = 0;
        while (n2 < this.chain.length) {
            n += this.chain[n2].hashCode();
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignerInfo)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        SignerInfo signerInfo = (SignerInfo)object;
        if (!this.mdAlgorithm.equals(signerInfo.getMessageDigestAlgorithm())) {
            return false;
        }
        Certificate[] certificateArray = signerInfo.getCertificateChain();
        if (certificateArray.length != this.chain.length) {
            return false;
        }
        int n = 0;
        while (n < this.chain.length) {
            if (!this.chain[n].equals(certificateArray[n])) {
                return false;
            }
            ++n;
        }
        return this.trustAnchor == null ? signerInfo.getTrustAnchor() == null : this.trustAnchor.equals(signerInfo.getTrustAnchor());
    }
}

