/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.signedcontent.PKCS7Processor;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignerInfoImpl;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedStorageHook
implements StorageHook {
    public static final String KEY;
    public static final int HASHCODE;
    private static final int STORAGE_VERSION = 3;
    private static List<SignerInfo> savedSignerInfo;
    private static long firstIDSaved;
    private static long lastIDSaved;
    private static List<SignerInfo> loadedSignerInfo;
    private static long lastIDLoaded;
    private BaseData bundledata;
    SignedContentImpl signedContent;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.signedcontent.SignedStorageHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KEY = clazz.getName();
        HASHCODE = KEY.hashCode();
        savedSignerInfo = new ArrayList<SignerInfo>(5);
        firstIDSaved = -1L;
        lastIDSaved = -1L;
        loadedSignerInfo = new ArrayList<SignerInfo>(5);
    }

    @Override
    public int getStorageVersion() {
        return 3;
    }

    @Override
    public StorageHook create(BaseData baseData) throws BundleException {
        SignedStorageHook signedStorageHook = new SignedStorageHook();
        signedStorageHook.bundledata = baseData;
        return signedStorageHook;
    }

    @Override
    public void initialize(Dictionary<String, String> dictionary) throws BundleException {
    }

    @Override
    public StorageHook load(BaseData baseData, DataInputStream dataInputStream) throws IOException {
        Object object;
        Object object2;
        int n;
        if (lastIDLoaded > baseData.getBundleID()) {
            loadedSignerInfo.clear();
        }
        lastIDLoaded = baseData.getBundleID();
        SignedStorageHook signedStorageHook = new SignedStorageHook();
        signedStorageHook.bundledata = baseData;
        boolean bl = dataInputStream.readBoolean();
        if (!bl) {
            return signedStorageHook;
        }
        int n2 = dataInputStream.readInt();
        SignerInfo[] signerInfoArray = new SignerInfo[n2];
        int n3 = 0;
        while (n3 < n2) {
            signerInfoArray[n3] = this.readSignerInfo(dataInputStream);
            ++n3;
        }
        n3 = dataInputStream.readInt();
        HashMap<String, Object> hashMap = null;
        if (n3 > 0) {
            hashMap = new HashMap<String, Object>(n3);
            int n4 = 0;
            while (n4 < n3) {
                String string = dataInputStream.readUTF();
                n = dataInputStream.readInt();
                object2 = new SignerInfo[n];
                object = new byte[n][];
                int n5 = 0;
                while (n5 < n) {
                    object2[n5] = this.readSignerInfo(dataInputStream);
                    int n6 = dataInputStream.readInt();
                    object[n5] = new byte[n6];
                    dataInputStream.readFully(object[n5]);
                    ++n5;
                }
                hashMap.put(string, new Object[]{object2, object});
                ++n4;
            }
        }
        SignedContentImpl signedContentImpl = new SignedContentImpl(signerInfoArray, hashMap);
        int n7 = 0;
        while (n7 < n2) {
            n = dataInputStream.readBoolean();
            if (n != 0) {
                object2 = this.readSignerInfo(dataInputStream);
                object = new Date(dataInputStream.readLong());
                signedContentImpl.addTSASignerInfo(signerInfoArray[n7], (SignerInfo)object2, (Date)object);
            }
            ++n7;
        }
        signedStorageHook.signedContent = signedContentImpl;
        return signedStorageHook;
    }

    @Override
    public void save(DataOutputStream dataOutputStream) throws IOException {
        Object object;
        this.getFirstLastID();
        if (firstIDSaved == this.bundledata.getBundleID()) {
            savedSignerInfo.clear();
        }
        if (lastIDSaved == this.bundledata.getBundleID()) {
            lastIDSaved = -1L;
            firstIDSaved = -1L;
        }
        dataOutputStream.writeBoolean(this.signedContent != null);
        if (this.signedContent == null) {
            return;
        }
        SignerInfo[] signerInfoArray = this.signedContent.getSignerInfos();
        dataOutputStream.writeInt(signerInfoArray.length);
        int n = 0;
        while (n < signerInfoArray.length) {
            this.saveSignerInfo(signerInfoArray[n], dataOutputStream);
            ++n;
        }
        Map<String, Object> map = this.signedContent.getContentMDResults();
        dataOutputStream.writeInt(map == null ? -1 : map.size());
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                object = entry.getKey();
                dataOutputStream.writeUTF((String)object);
                Object[] objectArray = (Object[])entry.getValue();
                SignerInfo[] signerInfoArray2 = (SignerInfo[])objectArray[0];
                byte[][] byArray = (byte[][])objectArray[1];
                dataOutputStream.writeInt(signerInfoArray2.length);
                int n2 = 0;
                while (n2 < signerInfoArray2.length) {
                    this.saveSignerInfo(signerInfoArray2[n2], dataOutputStream);
                    dataOutputStream.writeInt(byArray[n2].length);
                    dataOutputStream.write(byArray[n2]);
                    ++n2;
                }
            }
        }
        int n3 = 0;
        while (n3 < signerInfoArray.length) {
            SignerInfo signerInfo = this.signedContent.getTSASignerInfo(signerInfoArray[n3]);
            dataOutputStream.writeBoolean(signerInfo != null);
            if (signerInfo != null) {
                this.saveSignerInfo(signerInfo, dataOutputStream);
                object = this.signedContent.getSigningTime(signerInfoArray[n3]);
                dataOutputStream.writeLong(object != null ? ((Date)object).getTime() : Long.MIN_VALUE);
            }
            ++n3;
        }
    }

    private void saveSignerInfo(SignerInfo signerInfo, DataOutputStream dataOutputStream) throws IOException {
        int n = savedSignerInfo.indexOf(signerInfo);
        dataOutputStream.writeInt(n);
        if (n >= 0) {
            return;
        }
        Certificate[] certificateArray = signerInfo.getCertificateChain();
        int n2 = -1;
        dataOutputStream.writeInt(certificateArray == null ? 0 : certificateArray.length);
        if (certificateArray != null) {
            int n3 = 0;
            while (n3 < certificateArray.length) {
                byte[] byArray;
                if (certificateArray[n3].equals(signerInfo.getTrustAnchor())) {
                    n2 = n3;
                }
                try {
                    byArray = certificateArray[n3].getEncoded();
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw (IOException)new IOException(certificateEncodingException.getMessage()).initCause(certificateEncodingException);
                }
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
                ++n3;
            }
        }
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeUTF(signerInfo.getMessageDigestAlgorithm());
        savedSignerInfo.add(signerInfo);
    }

    private SignerInfo readSignerInfo(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n >= 0) {
            return loadedSignerInfo.get(n);
        }
        int n2 = dataInputStream.readInt();
        Certificate[] certificateArray = new Certificate[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataInputStream.readInt();
            byte[] byArray = new byte[n4];
            dataInputStream.readFully(byArray);
            try {
                certificateArray[n3] = PKCS7Processor.certFact.generateCertificate(new ByteArrayInputStream(byArray));
            }
            catch (CertificateException certificateException) {
                throw (IOException)new IOException(certificateException.getMessage()).initCause(certificateException);
            }
            ++n3;
        }
        n3 = dataInputStream.readInt();
        SignerInfoImpl signerInfoImpl = new SignerInfoImpl(certificateArray, n3 >= 0 ? certificateArray[n3] : null, dataInputStream.readUTF());
        loadedSignerInfo.add(signerInfoImpl);
        return signerInfoImpl;
    }

    private void getFirstLastID() {
        if (firstIDSaved >= 0L) {
            return;
        }
        Bundle[] bundleArray = this.bundledata.getAdaptor().getContext().getBundles();
        if (bundleArray.length > 1) {
            firstIDSaved = bundleArray[1].getBundleId();
            lastIDSaved = bundleArray[bundleArray.length - 1].getBundleId();
        }
    }

    @Override
    public void copy(StorageHook storageHook) {
    }

    @Override
    public void validate() throws IllegalArgumentException {
    }

    @Override
    public Dictionary<String, String> getManifest(boolean bl) throws BundleException {
        return null;
    }

    @Override
    public boolean forgetStatusChange(int n) {
        return false;
    }

    @Override
    public boolean forgetStartLevelChange(int n) {
        return false;
    }

    @Override
    public int getKeyHashCode() {
        return HASHCODE;
    }

    @Override
    public boolean compare(KeyedElement keyedElement) {
        return keyedElement.getKey() == KEY;
    }

    @Override
    public Object getKey() {
        return KEY;
    }

    public SignedContent getSignedContent() {
        return this.signedContent;
    }
}

