/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.internal.signedcontent.SignatureBlockProcessor;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.signedcontent.SignedContentConstants;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignedContentMessages;
import org.eclipse.osgi.internal.signedcontent.SignerInfoImpl;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedBundleFile
extends BundleFile
implements SignedContentConstants,
SignedContent {
    private BundleFile wrappedBundleFile;
    SignedContentImpl signedContent;
    private final int supportFlags;

    SignedBundleFile(SignedContentImpl signedContentImpl, int n) {
        this.signedContent = signedContentImpl;
        this.supportFlags = n;
    }

    void setBundleFile(BundleFile bundleFile) throws IOException, InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        this.wrappedBundleFile = bundleFile;
        if (this.signedContent == null) {
            SignatureBlockProcessor signatureBlockProcessor = new SignatureBlockProcessor(this, this.supportFlags);
            this.signedContent = signatureBlockProcessor.process();
            if (this.signedContent != null) {
                SignedBundleFile.determineTrust(this.signedContent, this.supportFlags);
            }
        }
    }

    static void determineTrust(SignedContentImpl signedContentImpl, int n) {
        TrustEngine[] trustEngineArray = null;
        SignerInfo[] signerInfoArray = signedContentImpl.getSignerInfos();
        int n2 = 0;
        while (n2 < signerInfoArray.length) {
            if (signerInfoArray[n2].getTrustAnchor() == null) {
                if (trustEngineArray == null) {
                    trustEngineArray = SignedBundleHook.getTrustEngines();
                }
                Certificate[] certificateArray = signerInfoArray[n2].getCertificateChain();
                ((SignerInfoImpl)signerInfoArray[n2]).setTrustAnchor(SignedBundleFile.findTrustAnchor(certificateArray, trustEngineArray, n));
                SignerInfo signerInfo = signedContentImpl.getTSASignerInfo(signerInfoArray[n2]);
                if (signerInfo != null) {
                    Certificate[] certificateArray2 = signerInfo.getCertificateChain();
                    ((SignerInfoImpl)signerInfo).setTrustAnchor(SignedBundleFile.findTrustAnchor(certificateArray2, trustEngineArray, n));
                }
            }
            ++n2;
        }
    }

    private static Certificate findTrustAnchor(Certificate[] certificateArray, TrustEngine[] trustEngineArray, int n) {
        if ((n & 2) == 0) {
            return certificateArray != null && certificateArray.length > 0 ? certificateArray[certificateArray.length - 1] : null;
        }
        int n2 = 0;
        while (n2 < trustEngineArray.length) {
            try {
                Certificate certificate = trustEngineArray[n2].findTrustAnchor(certificateArray);
                if (certificate != null) {
                    return certificate;
                }
            }
            catch (IOException iOException) {
                SignedBundleHook.log(new StringBuffer("TrustEngine failure: ").append(trustEngineArray[n2].getName()).toString(), 2, iOException);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public File getFile(String string, boolean bl) {
        return this.wrappedBundleFile.getFile(string, bl);
    }

    @Override
    public BundleEntry getEntry(String string) {
        int n;
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        BundleEntry bundleEntry = this.wrappedBundleFile.getEntry(string);
        if ((this.supportFlags & 4) == 0 || this.signedContent == null) {
            return bundleEntry;
        }
        if (string.startsWith("META-INF/") && (n = string.lastIndexOf(47)) == "META-INF/".length() - 1) {
            if (string.equals("META-INF/MANIFEST.MF") || string.endsWith(".DSA") || string.endsWith(".RSA") || string.endsWith(".SF") || string.indexOf("SIG-") == "META-INF/".length()) {
                return bundleEntry;
            }
            SignedContentEntry signedContentEntry = this.signedContent.getSignedEntry(string);
            if (signedContentEntry == null) {
                return bundleEntry;
            }
        }
        if (bundleEntry == null) {
            SignedContentEntry signedContentEntry = this.signedContent.getSignedEntry(string);
            if (signedContentEntry != null) {
                throw new SecurityException(NLS.bind(SignedContentMessages.file_is_removed_from_jar, string, this.getBaseFile().toString()));
            }
            return null;
        }
        return new SignedBundleEntry(bundleEntry);
    }

    @Override
    public Enumeration<String> getEntryPaths(String string) {
        return this.wrappedBundleFile.getEntryPaths(string);
    }

    @Override
    public void close() throws IOException {
        this.wrappedBundleFile.close();
    }

    @Override
    public void open() throws IOException {
        this.wrappedBundleFile.open();
    }

    @Override
    public boolean containsDir(String string) {
        return this.wrappedBundleFile.containsDir(string);
    }

    @Override
    public File getBaseFile() {
        return this.wrappedBundleFile.getBaseFile();
    }

    BundleFile getWrappedBundleFile() {
        return this.wrappedBundleFile;
    }

    SignedContentImpl getSignedContent() {
        return this.signedContent;
    }

    @Override
    public SignedContentEntry[] getSignedEntries() {
        return this.signedContent == null ? null : this.signedContent.getSignedEntries();
    }

    @Override
    public SignedContentEntry getSignedEntry(String string) {
        return this.signedContent == null ? null : this.signedContent.getSignedEntry(string);
    }

    @Override
    public SignerInfo[] getSignerInfos() {
        return this.signedContent == null ? null : this.signedContent.getSignerInfos();
    }

    @Override
    public Date getSigningTime(SignerInfo signerInfo) {
        return this.signedContent == null ? null : this.signedContent.getSigningTime(signerInfo);
    }

    @Override
    public SignerInfo getTSASignerInfo(SignerInfo signerInfo) {
        return this.signedContent == null ? null : this.signedContent.getTSASignerInfo(signerInfo);
    }

    @Override
    public boolean isSigned() {
        return this.signedContent == null ? false : this.signedContent.isSigned();
    }

    @Override
    public void checkValidity(SignerInfo signerInfo) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.signedContent != null) {
            this.signedContent.checkValidity(signerInfo);
        }
    }

    class SignedBundleEntry
    extends BundleEntry {
        BundleEntry nestedEntry;

        SignedBundleEntry(BundleEntry bundleEntry) {
            this.nestedEntry = bundleEntry;
        }

        public InputStream getInputStream() throws IOException {
            InputStream inputStream = SignedBundleFile.this.signedContent.getDigestInputStream(this.nestedEntry);
            if (inputStream == null) {
                throw new SecurityException("Corrupted file: the digest does not exist for the file " + this.nestedEntry.getName());
            }
            return inputStream;
        }

        public long getSize() {
            return this.nestedEntry.getSize();
        }

        public String getName() {
            return this.nestedEntry.getName();
        }

        public long getTime() {
            return this.nestedEntry.getTime();
        }

        public URL getLocalURL() {
            return this.nestedEntry.getLocalURL();
        }

        public URL getFileURL() {
            return this.nestedEntry.getFileURL();
        }
    }
}

