/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrinkableCollection<E>
implements Collection<E> {
    private final Collection<? extends E> collection;
    private final List<Collection<? extends E>> list;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ShrinkableCollection(Collection<? extends E> collection) {
        List list;
        if (collection == null) {
            throw new NullPointerException();
        }
        this.list = list = Collections.EMPTY_LIST;
        this.collection = collection;
    }

    public ShrinkableCollection(Collection<? extends E> collection, Collection<? extends E> collection2) {
        this.list = new ArrayList<Collection<? extends E>>(2);
        this.list.add(collection);
        this.list.add(collection2);
        this.collection = ShrinkableCollection.initComposite(this.list);
    }

    public ShrinkableCollection(List<Collection<? extends E>> list) {
        this.list = new ArrayList<Collection<Collection<? extends E>>>(list);
        this.collection = ShrinkableCollection.initComposite(this.list);
    }

    private static <E> Collection<? extends E> initComposite(List<Collection<? extends E>> list) {
        Collection<E> collection2;
        int n = 0;
        for (Collection<E> collection2 : list) {
            if (!$assertionsDisabled && !ShrinkableCollection.verifyNoDuplicates(collection2)) {
                throw new AssertionError();
            }
            n += collection2.size();
        }
        collection2 = new ArrayList(n);
        for (Collection<E> collection3 : list) {
            for (E e : collection3) {
                if (collection2.contains(e)) continue;
                collection2.add(e);
            }
        }
        return collection2;
    }

    private static <E> boolean verifyNoDuplicates(Collection<? extends E> collection) {
        for (E e : collection) {
            int n = 0;
            for (E e2 : collection) {
                if (e == null) {
                    if (e2 != null) continue;
                    ++n;
                    continue;
                }
                if (!e.equals(e2)) continue;
                ++n;
            }
            if (n == true) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.collection.clear();
        for (Collection<E> collection : this.list) {
            collection.clear();
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.collection.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.collection.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<? extends E> iterator = this.collection.iterator();
        final List<Collection<E>> list = this.list;
        if (list.isEmpty()) {
            return iterator;
        }
        return new Iterator<E>(){
            private E last;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                this.last = iterator.next();
                return this.last;
            }

            @Override
            public void remove() {
                iterator.remove();
                for (Collection collection : list) {
                    collection.remove(this.last);
                }
            }
        };
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = this.collection.remove(object);
        if (bl) {
            for (Collection<E> collection : this.list) {
                collection.remove(object);
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = this.collection.removeAll(collection);
        if (bl) {
            for (Collection<E> collection2 : this.list) {
                collection2.removeAll(collection);
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = this.collection.retainAll(collection);
        if (bl) {
            for (Collection<E> collection2 : this.list) {
                collection2.retainAll(collection);
            }
        }
        return bl;
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.collection.toArray(TArray);
    }

    public String toString() {
        return this.collection.toString();
    }
}

