/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.FilteredServiceListener;
import org.eclipse.osgi.internal.serviceregistry.HookContext;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceUse;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableValueCollectionMap;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistry {
    public static final int SERVICEEVENT = 3;
    static final String findHookName;
    static final String eventHookName;
    static final String eventListenerHookName;
    static final String listenerHookName;
    private final Map<String, List<ServiceRegistrationImpl<?>>> publishedServicesByClass;
    private final List<ServiceRegistrationImpl<?>> allPublishedServices;
    private final Map<BundleContextImpl, List<ServiceRegistrationImpl<?>>> publishedServicesByContext;
    private long serviceid;
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> serviceEventListeners;
    private static final int initialCapacity = 50;
    private static final int initialSubCapacity = 10;
    private final Framework framework;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.internal.serviceregistry.ServiceRegistry");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.osgi.framework.hooks.service.FindHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        findHookName = clazz2.getName();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.osgi.framework.hooks.service.EventHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        eventHookName = clazz3.getName();
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.osgi.framework.hooks.service.EventListenerHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        eventListenerHookName = clazz4.getName();
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("org.osgi.framework.hooks.service.ListenerHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        listenerHookName = clazz5.getName();
    }

    public ServiceRegistry(Framework framework) {
        this.framework = framework;
        this.serviceid = 1L;
        this.publishedServicesByClass = new HashMap(50);
        this.publishedServicesByContext = new HashMap(50);
        this.allPublishedServices = new ArrayList(50);
        this.serviceEventListeners = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>>(50);
    }

    public ServiceRegistrationImpl<?> registerService(BundleContextImpl bundleContextImpl, String[] stringArray, Object object, Dictionary<String, ?> dictionary) {
        String string;
        if (object == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is null");
            }
            throw new IllegalArgumentException(Msg.SERVICE_ARGUMENT_NULL_EXCEPTION);
        }
        int n = stringArray.length;
        if (n == 0) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Classes array is empty");
            }
            throw new IllegalArgumentException(Msg.SERVICE_EMPTY_CLASS_LIST_EXCEPTION);
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2].intern();
            if (!arrayList.contains(string2)) {
                arrayList.add(string2);
            }
            ++n2;
        }
        n = arrayList.size();
        stringArray = arrayList.toArray(new String[n]);
        ServiceRegistry.checkRegisterServicePermission(stringArray);
        if (!(object instanceof ServiceFactory) && (string = ServiceRegistry.checkServiceClass(stringArray, object)) != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(new StringBuffer("Service object is not an instanceof ").append(string).toString());
            }
            throw new IllegalArgumentException(NLS.bind(Msg.SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION, string));
        }
        ServiceRegistrationImpl<Object> serviceRegistrationImpl = new ServiceRegistrationImpl<Object>(this, bundleContextImpl, stringArray, object);
        serviceRegistrationImpl.register(dictionary);
        if (arrayList.contains(listenerHookName)) {
            this.notifyNewListenerHook(serviceRegistrationImpl);
        }
        return serviceRegistrationImpl;
    }

    public ServiceReferenceImpl<?>[] getServiceReferences(BundleContextImpl bundleContextImpl, String string, String string2, boolean bl, boolean bl2) throws InvalidSyntaxException {
        int n;
        if (Debug.DEBUG_SERVICES) {
            Debug.println(new StringBuffer(String.valueOf(bl ? "getAllServiceReferences(" : "getServiceReferences(")).append(string).append(", \"").append(string2).append("\")").toString());
        }
        Filter filter = string2 == null ? null : bundleContextImpl.createFilter(string2);
        List<ServiceRegistrationImpl<?>> list = this.lookupServiceRegistrations(string, filter);
        ArrayList arrayList = new ArrayList(list.size());
        for (ServiceRegistrationImpl<?> object : list) {
            ServiceReferenceImpl<?> serviceReferenceImpl;
            try {
                serviceReferenceImpl = object.getReferenceImpl();
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            if (!bl && !ServiceRegistry.isAssignableTo(bundleContextImpl, serviceReferenceImpl)) continue;
            try {
                ServiceRegistry.checkGetServicePermission(serviceReferenceImpl);
            }
            catch (SecurityException securityException) {
                continue;
            }
            arrayList.add(serviceReferenceImpl);
        }
        if (bl2) {
            ShrinkableCollection n2 = new ShrinkableCollection(arrayList);
            this.notifyFindHooks(bundleContextImpl, string, string2, bl, n2);
        }
        if ((n = arrayList.size()) == 0) {
            return null;
        }
        return arrayList.toArray(new ServiceReferenceImpl[n]);
    }

    public ServiceReferenceImpl<?>[] getServiceReferences(BundleContextImpl bundleContextImpl, String string, String string2, boolean bl) throws InvalidSyntaxException {
        return this.getServiceReferences(bundleContextImpl, string, string2, bl, true);
    }

    public ServiceReferenceImpl<?> getServiceReference(BundleContextImpl bundleContextImpl, String string) {
        block4: {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(new StringBuffer("getServiceReference(").append(string).append(")").toString());
            }
            try {
                ServiceReferenceImpl<?>[] serviceReferenceImplArray = this.getServiceReferences(bundleContextImpl, string, null, false);
                if (serviceReferenceImplArray != null) {
                    return serviceReferenceImplArray[0];
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                if (!Debug.DEBUG_GENERAL) break block4;
                Debug.println(new StringBuffer("InvalidSyntaxException w/ null filter").append(invalidSyntaxException.getMessage()).toString());
                Debug.printStackTrace(invalidSyntaxException);
            }
        }
        return null;
    }

    public Object getService(BundleContextImpl bundleContextImpl, ServiceReferenceImpl<?> serviceReferenceImpl) {
        ServiceRegistry.checkGetServicePermission(serviceReferenceImpl);
        return serviceReferenceImpl.getRegistration().getService(bundleContextImpl);
    }

    public boolean ungetService(BundleContextImpl bundleContextImpl, ServiceReferenceImpl<?> serviceReferenceImpl) {
        ServiceRegistrationImpl<?> serviceRegistrationImpl = serviceReferenceImpl.getRegistration();
        return serviceRegistrationImpl.ungetService(bundleContextImpl);
    }

    public ServiceReferenceImpl<?>[] getRegisteredServices(BundleContextImpl bundleContextImpl) {
        List<ServiceRegistrationImpl<?>> list = this.lookupServiceRegistrations(bundleContextImpl);
        ArrayList arrayList = new ArrayList(list.size());
        for (ServiceRegistrationImpl<?> serviceRegistrationImpl : list) {
            ServiceReferenceImpl<?> serviceReferenceImpl;
            try {
                serviceReferenceImpl = serviceRegistrationImpl.getReferenceImpl();
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            try {
                ServiceRegistry.checkGetServicePermission(serviceReferenceImpl);
            }
            catch (SecurityException securityException) {
                continue;
            }
            arrayList.add(serviceReferenceImpl);
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        return arrayList.toArray(new ServiceReferenceImpl[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReferenceImpl<?>[] getServicesInUse(BundleContextImpl bundleContextImpl) {
        ArrayList arrayList;
        Map<ServiceRegistrationImpl<?>, ServiceUse<?>> map = bundleContextImpl.getServicesInUseMap();
        if (map == null) {
            return null;
        }
        Object object = map;
        synchronized (object) {
            block11: {
                if (!map.isEmpty()) break block11;
                return null;
            }
            arrayList = new ArrayList(map.keySet());
        }
        object = new ArrayList(arrayList.size());
        for (ServiceRegistrationImpl serviceRegistrationImpl : arrayList) {
            ServiceReferenceImpl serviceReferenceImpl;
            try {
                serviceReferenceImpl = serviceRegistrationImpl.getReferenceImpl();
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            try {
                ServiceRegistry.checkGetServicePermission(serviceReferenceImpl);
            }
            catch (SecurityException securityException) {
                continue;
            }
            object.add(serviceReferenceImpl);
        }
        int n = object.size();
        if (n == 0) {
            return null;
        }
        return object.toArray(new ServiceReferenceImpl[n]);
    }

    public void unregisterServices(BundleContextImpl bundleContextImpl) {
        for (ServiceRegistrationImpl<?> serviceRegistrationImpl : this.lookupServiceRegistrations(bundleContextImpl)) {
            try {
                serviceRegistrationImpl.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.removeServiceRegistrations(bundleContextImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseServicesInUse(BundleContextImpl bundleContextImpl) {
        ArrayList arrayList;
        Map<ServiceRegistrationImpl<?>, ServiceUse<?>> map = bundleContextImpl.getServicesInUseMap();
        if (map == null) {
            return;
        }
        Map<ServiceRegistrationImpl<?>, ServiceUse<?>> object2 = map;
        synchronized (object2) {
            if (map.isEmpty()) {
                return;
            }
            arrayList = new ArrayList(map.keySet());
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("Releasing services");
        }
        for (ServiceRegistrationImpl serviceRegistrationImpl : arrayList) {
            serviceRegistrationImpl.releaseService(bundleContextImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(BundleContextImpl bundleContextImpl, ServiceListener serviceListener, String string) throws InvalidSyntaxException {
        FilteredServiceListener filteredServiceListener;
        Object object;
        if (Debug.DEBUG_EVENTS) {
            object = new StringBuffer(String.valueOf(serviceListener.getClass().getName())).append("@").append(Integer.toHexString(System.identityHashCode(serviceListener))).toString();
            Debug.println(new StringBuffer("addServiceListener[").append(bundleContextImpl.getBundleImpl()).append("](").append((String)object).append(", \"").append(string).append("\")").toString());
        }
        object = new FilteredServiceListener(bundleContextImpl, serviceListener, string);
        List<ListenerHook.ListenerInfo> list = this.serviceEventListeners;
        synchronized (list) {
            CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener> copyOnWriteIdentityMap = this.serviceEventListeners.get(bundleContextImpl);
            if (copyOnWriteIdentityMap == null) {
                copyOnWriteIdentityMap = new CopyOnWriteIdentityMap();
                this.serviceEventListeners.put(bundleContextImpl, copyOnWriteIdentityMap);
            }
            filteredServiceListener = copyOnWriteIdentityMap.put(serviceListener, (FilteredServiceListener)object);
        }
        if (filteredServiceListener != null) {
            filteredServiceListener.markRemoved();
            list = Collections.singletonList(filteredServiceListener);
            this.notifyListenerHooks(list, false);
        }
        list = Collections.singletonList(object);
        this.notifyListenerHooks(list, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(BundleContextImpl bundleContextImpl, ServiceListener serviceListener) {
        Object object;
        if (Debug.DEBUG_EVENTS) {
            object = new StringBuffer(String.valueOf(serviceListener.getClass().getName())).append("@").append(Integer.toHexString(System.identityHashCode(serviceListener))).toString();
            Debug.println(new StringBuffer("removeServiceListener[").append(bundleContextImpl.getBundleImpl()).append("](").append((String)object).append(")").toString());
        }
        Object object2 = this.serviceEventListeners;
        synchronized (object2) {
            Map map = this.serviceEventListeners.get(bundleContextImpl);
            if (map == null) {
                return;
            }
            object = (FilteredServiceListener)map.remove(serviceListener);
        }
        if (object == null) {
            return;
        }
        ((FilteredServiceListener)object).markRemoved();
        object2 = Collections.singletonList(object);
        this.notifyListenerHooks((Collection<ListenerHook.ListenerInfo>)object2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllServiceListeners(BundleContextImpl bundleContextImpl) {
        Map map;
        Object object = this.serviceEventListeners;
        synchronized (object) {
            map = this.serviceEventListeners.remove(bundleContextImpl);
        }
        if (map == null || map.isEmpty()) {
            return;
        }
        object = map.values();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            FilteredServiceListener filteredServiceListener = (FilteredServiceListener)iterator.next();
            filteredServiceListener.markRemoved();
        }
        this.notifyListenerHooks(ServiceRegistry.asListenerInfos((Collection<? extends ListenerHook.ListenerInfo>)object), false);
    }

    private static Collection<ListenerHook.ListenerInfo> asListenerInfos(Collection<? extends ListenerHook.ListenerInfo> collection) {
        return collection;
    }

    public void publishServiceEvent(final ServiceEvent serviceEvent) {
        if (System.getSecurityManager() == null) {
            this.publishServiceEventPrivileged(serviceEvent);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ServiceRegistry.this.publishServiceEventPrivileged(serviceEvent);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishServiceEventPrivileged(ServiceEvent serviceEvent) {
        Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> entry22;
        HashMap<BundleContextImpl, Set<Map.Entry<ServiceListener, FilteredServiceListener>>> hashMap;
        Object object = this.serviceEventListeners;
        synchronized (object) {
            hashMap = new HashMap<BundleContextImpl, Set<Map.Entry<ServiceListener, FilteredServiceListener>>>(this.serviceEventListeners.size());
            for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> entry22 : this.serviceEventListeners.entrySet()) {
                CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener> copyOnWriteIdentityMap = entry22.getValue();
                if (copyOnWriteIdentityMap.isEmpty()) continue;
                hashMap.put(entry22.getKey(), copyOnWriteIdentityMap.entrySet());
            }
        }
        object = ServiceRegistry.asBundleContexts(hashMap.keySet());
        this.notifyEventHooksPrivileged(serviceEvent, (Collection<BundleContext>)object);
        if (hashMap.isEmpty()) {
            return;
        }
        entry22 = new ShrinkableValueCollectionMap(hashMap);
        this.notifyEventListenerHooksPrivileged(serviceEvent, (Map<BundleContext, Collection<ListenerHook.ListenerInfo>>)((Object)entry22));
        if (hashMap.isEmpty()) {
            return;
        }
        ListenerQueue listenerQueue = this.framework.newListenerQueue();
        for (Map.Entry entry : hashMap.entrySet()) {
            EventDispatcher eventDispatcher = (EventDispatcher)entry.getKey();
            Set set = (Set)entry.getValue();
            listenerQueue.queueListeners(set, eventDispatcher);
        }
        listenerQueue.dispatchEventSynchronous(3, serviceEvent);
    }

    private static Collection<BundleContext> asBundleContexts(Collection<? extends BundleContext> collection) {
        return collection;
    }

    synchronized long getNextServiceId() {
        long l = this.serviceid;
        this.serviceid = l + 1L;
        return l;
    }

    void addServiceRegistration(BundleContextImpl bundleContextImpl, ServiceRegistrationImpl<?> serviceRegistrationImpl) {
        int n;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        List<ServiceRegistrationImpl<?>> list = this.publishedServicesByContext.get(bundleContextImpl);
        if (list == null) {
            list = new ArrayList(10);
            this.publishedServicesByContext.put(bundleContextImpl, list);
        }
        list.add(serviceRegistrationImpl);
        String[] stringArray = serviceRegistrationImpl.getClasses();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            List<ServiceRegistrationImpl<?>> list2 = this.publishedServicesByClass.get(string);
            if (list2 == null) {
                list2 = new ArrayList(10);
                this.publishedServicesByClass.put(string, list2);
            }
            n = -Collections.binarySearch(list2, serviceRegistrationImpl) - 1;
            list2.add(n, serviceRegistrationImpl);
            ++n3;
        }
        n = -Collections.binarySearch(this.allPublishedServices, serviceRegistrationImpl) - 1;
        this.allPublishedServices.add(n, serviceRegistrationImpl);
    }

    void modifyServiceRegistration(BundleContextImpl bundleContextImpl, ServiceRegistrationImpl<?> serviceRegistrationImpl) {
        int n;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String[] stringArray = serviceRegistrationImpl.getClasses();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            List<ServiceRegistrationImpl<?>> list = this.publishedServicesByClass.get(string);
            list.remove(serviceRegistrationImpl);
            n = -Collections.binarySearch(list, serviceRegistrationImpl) - 1;
            list.add(n, serviceRegistrationImpl);
            ++n3;
        }
        this.allPublishedServices.remove(serviceRegistrationImpl);
        n = -Collections.binarySearch(this.allPublishedServices, serviceRegistrationImpl) - 1;
        this.allPublishedServices.add(n, serviceRegistrationImpl);
    }

    void removeServiceRegistration(BundleContextImpl bundleContextImpl, ServiceRegistrationImpl<?> serviceRegistrationImpl) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        List<ServiceRegistrationImpl<?>> list = this.publishedServicesByContext.get(bundleContextImpl);
        if (list != null) {
            list.remove(serviceRegistrationImpl);
        }
        String[] stringArray = serviceRegistrationImpl.getClasses();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            List<ServiceRegistrationImpl<?>> list2 = this.publishedServicesByClass.get(string);
            list2.remove(serviceRegistrationImpl);
            if (list2.isEmpty()) {
                this.publishedServicesByClass.remove(string);
            }
            ++n2;
        }
        this.allPublishedServices.remove(serviceRegistrationImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServiceRegistrationImpl<?>> lookupServiceRegistrations(String string, Filter filter) {
        List<ServiceRegistrationImpl<?>> list;
        Object object = this;
        synchronized (object) {
            list = string == null ? this.allPublishedServices : this.publishedServicesByClass.get(string);
            if (list == null || list.isEmpty()) {
                List list2 = Collections.EMPTY_LIST;
                return list2;
            }
            list = new ArrayList(list);
        }
        if (filter == null) {
            return list;
        }
        object = list.iterator();
        while (object.hasNext()) {
            ServiceReferenceImpl serviceReferenceImpl;
            ServiceRegistrationImpl serviceRegistrationImpl = (ServiceRegistrationImpl)object.next();
            try {
                serviceReferenceImpl = serviceRegistrationImpl.getReferenceImpl();
            }
            catch (IllegalStateException illegalStateException) {
                object.remove();
                continue;
            }
            if (filter.match(serviceReferenceImpl)) continue;
            object.remove();
        }
        return list;
    }

    private synchronized List<ServiceRegistrationImpl<?>> lookupServiceRegistrations(BundleContextImpl bundleContextImpl) {
        List<ServiceRegistrationImpl<?>> list = this.publishedServicesByContext.get(bundleContextImpl);
        if (list == null || list.isEmpty()) {
            List list2 = Collections.EMPTY_LIST;
            return list2;
        }
        return new ArrayList(list);
    }

    private synchronized void removeServiceRegistrations(BundleContextImpl bundleContextImpl) {
        this.publishedServicesByContext.remove(bundleContextImpl);
    }

    private static void checkRegisterServicePermission(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            securityManager.checkPermission(new ServicePermission(stringArray[n], "register"));
            ++n;
        }
    }

    private static void checkGetServicePermission(ServiceReference<?> serviceReference) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        securityManager.checkPermission(new ServicePermission(serviceReference, "get"));
    }

    static boolean hasListenServicePermission(ServiceEvent serviceEvent, BundleContextImpl bundleContextImpl) {
        BundleProtectionDomain bundleProtectionDomain = bundleContextImpl.getBundleImpl().getProtectionDomain();
        if (bundleProtectionDomain == null) {
            return true;
        }
        return bundleProtectionDomain.implies(new ServicePermission(serviceEvent.getServiceReference(), "get"));
    }

    static String checkServiceClass(String[] stringArray, final Object object) {
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return object.getClass().getClassLoader();
            }
        });
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            block4: {
                try {
                    Class<?> clazz;
                    Class<?> clazz2 = clazz = classLoader == null ? Class.forName(stringArray[n]) : classLoader.loadClass(stringArray[n]);
                    if (!clazz.isInstance(object)) {
                        return stringArray[n];
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!ServiceRegistry.extensiveCheckServiceClass(stringArray[n], object.getClass())) break block4;
                    return stringArray[n];
                }
            }
            ++n;
        }
        return null;
    }

    private static boolean extensiveCheckServiceClass(String string, Class<?> clazz) {
        if (string.equals(clazz.getName())) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            if (!ServiceRegistry.extensiveCheckServiceClass(string, classArray[n])) {
                return false;
            }
            ++n;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        return clazz2 == null || ServiceRegistry.extensiveCheckServiceClass(string, clazz2);
    }

    static boolean isAssignableTo(BundleContextImpl bundleContextImpl, ServiceReferenceImpl<?> serviceReferenceImpl) {
        AbstractBundle abstractBundle = bundleContextImpl.getBundleImpl();
        String[] stringArray = serviceReferenceImpl.getClasses();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (!serviceReferenceImpl.isAssignableTo(abstractBundle, stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void notifyFindHooks(final BundleContextImpl bundleContextImpl, final String string, final String string2, final boolean bl, final Collection<ServiceReference<?>> collection) {
        if (System.getSecurityManager() == null) {
            this.notifyFindHooksPrivileged(bundleContextImpl, string, string2, bl, collection);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ServiceRegistry.this.notifyFindHooksPrivileged(bundleContextImpl, string, string2, bl, collection);
                    return null;
                }
            });
        }
    }

    void notifyFindHooksPrivileged(final BundleContextImpl bundleContextImpl, final String string, final String string2, final boolean bl, final Collection<ServiceReference<?>> collection) {
        if (Debug.DEBUG_HOOKS) {
            Debug.println(new StringBuffer("notifyServiceFindHooks(").append(bundleContextImpl.getBundleImpl()).append(",").append(string).append(",").append(string2).append(",").append(bl).append(",").append(collection).append(")").toString());
        }
        this.notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object object, ServiceRegistration<?> serviceRegistration) throws Exception {
                if (object instanceof FindHook) {
                    ((FindHook)object).find(bundleContextImpl, string, string2, bl, collection);
                }
            }

            @Override
            public String getHookClassName() {
                return findHookName;
            }

            @Override
            public String getHookMethodName() {
                return "find";
            }
        });
    }

    private void notifyEventHooksPrivileged(final ServiceEvent serviceEvent, final Collection<BundleContext> collection) {
        if (Debug.DEBUG_HOOKS) {
            Debug.println(new StringBuffer("notifyServiceEventHooks(").append(serviceEvent.getType()).append(":").append(serviceEvent.getServiceReference()).append(",").append(collection).append(")").toString());
        }
        this.notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object object, ServiceRegistration<?> serviceRegistration) throws Exception {
                if (object instanceof EventHook) {
                    ((EventHook)object).event(serviceEvent, collection);
                }
            }

            @Override
            public String getHookClassName() {
                return eventHookName;
            }

            @Override
            public String getHookMethodName() {
                return "event";
            }
        });
    }

    private void notifyEventListenerHooksPrivileged(final ServiceEvent serviceEvent, final Map<BundleContext, Collection<ListenerHook.ListenerInfo>> map) {
        if (Debug.DEBUG_HOOKS) {
            Debug.println(new StringBuffer("notifyServiceEventListenerHooks(").append(serviceEvent.getType()).append(":").append(serviceEvent.getServiceReference()).append(",").append(map).append(")").toString());
        }
        this.notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object object, ServiceRegistration<?> serviceRegistration) throws Exception {
                if (object instanceof EventListenerHook) {
                    ((EventListenerHook)object).event(serviceEvent, map);
                }
            }

            @Override
            public String getHookClassName() {
                return eventListenerHookName;
            }

            @Override
            public String getHookMethodName() {
                return "event";
            }
        });
    }

    public void notifyHooksPrivileged(HookContext hookContext) {
        BundleContextImpl bundleContextImpl = this.framework.getSystemBundleContext();
        if (bundleContextImpl == null) {
            return;
        }
        List<ServiceRegistrationImpl<?>> list = this.lookupServiceRegistrations(hookContext.getHookClassName(), null);
        for (ServiceRegistrationImpl<?> serviceRegistrationImpl : list) {
            this.notifyHookPrivileged(bundleContextImpl, serviceRegistrationImpl, hookContext);
        }
    }

    private void notifyHookPrivileged(BundleContextImpl bundleContextImpl, ServiceRegistrationImpl<?> serviceRegistrationImpl, HookContext hookContext) {
        Object object = serviceRegistrationImpl.getSafeService(bundleContextImpl);
        if (object == null) {
            return;
        }
        try {
            try {
                hookContext.call(object, serviceRegistrationImpl);
            }
            catch (Throwable throwable) {
                if (Debug.DEBUG_HOOKS) {
                    Debug.println(new StringBuffer(String.valueOf(object.getClass().getName())).append(".").append(hookContext.getHookMethodName()).append("() exception: ").append(throwable.getMessage()).toString());
                    Debug.printStackTrace(throwable);
                }
                this.framework.getAdaptor().handleRuntimeError(throwable);
                ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, object.getClass().getName(), hookContext.getHookMethodName()), throwable);
                this.framework.publishFrameworkEvent(2, serviceRegistrationImpl.getBundle(), serviceException);
                serviceRegistrationImpl.ungetService(bundleContextImpl);
            }
        }
        finally {
            serviceRegistrationImpl.ungetService(bundleContextImpl);
        }
    }

    private void notifyNewListenerHook(final ServiceRegistrationImpl<?> serviceRegistrationImpl) {
        if (System.getSecurityManager() == null) {
            this.notifyNewListenerHookPrivileged(serviceRegistrationImpl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ServiceRegistry.this.notifyNewListenerHookPrivileged(serviceRegistrationImpl);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNewListenerHookPrivileged(ServiceRegistrationImpl<?> serviceRegistrationImpl) {
        BundleContextImpl bundleContextImpl = this.framework.getSystemBundleContext();
        if (bundleContextImpl == null) {
            return;
        }
        if (Debug.DEBUG_HOOKS) {
            Debug.println(new StringBuffer("notifyServiceNewListenerHook(").append(serviceRegistrationImpl).append(")").toString());
        }
        ArrayList<FilteredServiceListener> arrayList = new ArrayList<FilteredServiceListener>(50);
        Object object = this.serviceEventListeners;
        synchronized (object) {
            for (CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener> copyOnWriteIdentityMap : this.serviceEventListeners.values()) {
                if (copyOnWriteIdentityMap.isEmpty()) continue;
                arrayList.addAll(copyOnWriteIdentityMap.values());
            }
        }
        object = Collections.unmodifiableCollection(arrayList);
        this.notifyHookPrivileged(bundleContextImpl, serviceRegistrationImpl, new HookContext((Collection)object){
            private final /* synthetic */ Collection val$listeners;
            {
                this.val$listeners = collection;
            }

            @Override
            public void call(Object object, ServiceRegistration<?> serviceRegistration) throws Exception {
                if (object instanceof ListenerHook) {
                    ((ListenerHook)object).added(this.val$listeners);
                }
            }

            @Override
            public String getHookClassName() {
                return listenerHookName;
            }

            @Override
            public String getHookMethodName() {
                return "added";
            }
        });
    }

    private void notifyListenerHooks(final Collection<ListenerHook.ListenerInfo> collection, final boolean bl) {
        if (System.getSecurityManager() == null) {
            this.notifyListenerHooksPrivileged(collection, bl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ServiceRegistry.this.notifyListenerHooksPrivileged(collection, bl);
                    return null;
                }
            });
        }
    }

    void notifyListenerHooksPrivileged(final Collection<ListenerHook.ListenerInfo> collection, final boolean bl) {
        if (!$assertionsDisabled && collection.isEmpty()) {
            throw new AssertionError();
        }
        if (Debug.DEBUG_HOOKS) {
            Debug.println(new StringBuffer("notifyServiceListenerHooks(").append(collection).append(",").append(bl ? "added" : "removed").append(")").toString());
        }
        this.notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object object, ServiceRegistration<?> serviceRegistration) throws Exception {
                if (object instanceof ListenerHook) {
                    if (bl) {
                        ((ListenerHook)object).added(collection);
                    } else {
                        ((ListenerHook)object).removed(collection);
                    }
                }
            }

            @Override
            public String getHookClassName() {
                return listenerHookName;
            }

            @Override
            public String getHookMethodName() {
                return bl ? "added" : "removed";
            }
        });
    }
}

