/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.framework.util.ObjectPool;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeDescriptionImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.StateWire;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StateReader {
    public static final String STATE_FILE = ".state";
    public static final String LAZY_FILE = ".lazy";
    private static final int BUFFER_SIZE_LAZY = 4096;
    private static final int BUFFER_SIZE_FULLYREAD = 16384;
    private static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    final Map<Integer, Object> objectTable = Collections.synchronizedMap(new HashMap());
    private volatile File stateFile;
    private volatile File lazyFile;
    private volatile boolean lazyLoad = true;
    private volatile int numBundles;
    private volatile boolean accessedFlag = false;
    public static final byte STATE_CACHE_VERSION = 36;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;
    static /* synthetic */ Class class$0;

    public StateReader() {
        this.lazyLoad = false;
    }

    public StateReader(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        this.stateFile = new File(file, STATE_FILE);
        this.lazyFile = new File(file, LAZY_FILE);
        this.lazyLoad = false;
    }

    public StateReader(File file, File file2, boolean bl) {
        this.stateFile = file;
        this.lazyFile = file2;
        this.lazyLoad = bl;
    }

    private void addToObjectTable(Object object, int n) {
        this.objectTable.put(new Integer(n), object);
    }

    private Object getFromObjectTable(int n) {
        Object object = this.objectTable.get(new Integer(n));
        if (object == null) {
            throw new IllegalStateException(new StringBuffer("Expected to find an object at table index: ").append(n).toString());
        }
        return object;
    }

    private boolean readState(StateImpl stateImpl, long l) throws IOException {
        int n;
        FilterInputStream filterInputStream;
        DataInputStream dataInputStream;
        block34: {
            Object object;
            long l2;
            int n2;
            block33: {
                block32: {
                    block31: {
                        dataInputStream = new DataInputStream(new BufferedInputStream(secureAction.getFileInputStream(this.stateFile), 16384));
                        filterInputStream = null;
                        if (dataInputStream.readByte() == 36) break block31;
                        dataInputStream.close();
                        if (filterInputStream != null) {
                            try {
                                filterInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return false;
                    }
                    byte by = this.readTag(dataInputStream);
                    if (by == 1) break block32;
                    dataInputStream.close();
                    if (filterInputStream != null) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return false;
                }
                n2 = dataInputStream.readInt();
                l2 = dataInputStream.readLong();
                if (l < 0L || l2 == l) break block33;
                dataInputStream.close();
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
            this.addToObjectTable(stateImpl, n2);
            String[] stringArray = (String[])this.readPlatformProp(dataInputStream);
            stateImpl.addPlatformPropertyKeys(stringArray);
            int n3 = dataInputStream.readInt();
            Dictionary[] dictionaryArray = new Dictionary[n3];
            int n4 = 0;
            while (n4 < n3) {
                object = new Hashtable(stringArray.length);
                int n5 = dataInputStream.readInt();
                int n6 = 0;
                while (n6 < n5) {
                    Object object2 = this.readPlatformProp(dataInputStream);
                    if (object2 != null && n6 < stringArray.length) {
                        ((Hashtable)object).put(stringArray[n6], object2);
                    }
                    ++n6;
                }
                dictionaryArray[n4] = object;
                ++n4;
            }
            stateImpl.setPlatformProperties(dictionaryArray, false);
            this.numBundles = dataInputStream.readInt();
            n4 = 0;
            while (n4 < this.numBundles) {
                object = this.readBundleDescription(dataInputStream);
                stateImpl.basicAddBundle((BundleDescription)object);
                if (((BundleDescriptionImpl)object).isResolved()) {
                    stateImpl.addResolvedBundle((BundleDescriptionImpl)object);
                }
                ++n4;
            }
            n4 = dataInputStream.readInt();
            n = 0;
            while (n < n4) {
                DisabledInfo disabledInfo = this.readDisabledInfo(dataInputStream);
                stateImpl.addDisabledInfo(disabledInfo);
                ++n;
            }
            stateImpl.setTimeStamp(l2);
            stateImpl.setResolved(dataInputStream.readBoolean());
            if (!this.lazyLoad) break block34;
            dataInputStream.close();
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(secureAction.getFileInputStream(this.lazyFile), 16384));
            n = 0;
            while (n < this.numBundles) {
                this.readBundleDescriptionLazyData((DataInputStream)filterInputStream, 0);
                ++n;
            }
        }
        catch (Throwable throwable) {
            dataInputStream.close();
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        dataInputStream.close();
        if (filterInputStream != null) {
            try {
                filterInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private boolean readStateDeprecated(StateImpl stateImpl, DataInputStream dataInputStream, long l) throws IOException {
        Object object;
        if (dataInputStream.readByte() != 36) {
            return false;
        }
        byte by = this.readTag(dataInputStream);
        if (by != 1) {
            return false;
        }
        int n = dataInputStream.readInt();
        long l2 = dataInputStream.readLong();
        if (l >= 0L && l2 != l) {
            return false;
        }
        this.addToObjectTable(stateImpl, n);
        String[] stringArray = (String[])this.readPlatformProp(dataInputStream);
        stateImpl.addPlatformPropertyKeys(stringArray);
        int n2 = dataInputStream.readInt();
        Dictionary[] dictionaryArray = new Dictionary[n2];
        int n3 = 0;
        while (n3 < n2) {
            object = new Hashtable(stringArray.length);
            int n4 = dataInputStream.readInt();
            int n5 = 0;
            while (n5 < n4) {
                Object object2 = this.readPlatformProp(dataInputStream);
                if (object2 != null && n5 < stringArray.length) {
                    ((Hashtable)object).put(stringArray[n5], object2);
                }
                ++n5;
            }
            dictionaryArray[n3] = object;
            ++n3;
        }
        stateImpl.setPlatformProperties(dictionaryArray);
        this.numBundles = dataInputStream.readInt();
        if (this.numBundles == 0) {
            return true;
        }
        n3 = 0;
        while (n3 < this.numBundles) {
            object = this.readBundleDescription(dataInputStream);
            stateImpl.basicAddBundle((BundleDescription)object);
            if (((BundleDescriptionImpl)object).isResolved()) {
                stateImpl.addResolvedBundle((BundleDescriptionImpl)object);
            }
            ++n3;
        }
        stateImpl.setTimeStamp(l2);
        stateImpl.setResolved(dataInputStream.readBoolean());
        dataInputStream.readInt();
        if (this.lazyLoad) {
            return true;
        }
        n3 = 0;
        while (n3 < this.numBundles) {
            this.readBundleDescriptionLazyData(dataInputStream, 0);
            ++n3;
        }
        return true;
    }

    private Object readPlatformProp(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        int n = dataInputStream.readInt();
        if (n == 1) {
            return this.readString(dataInputStream, false);
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = this.readString(dataInputStream, false);
            ++n2;
        }
        return stringArray;
    }

    private BundleDescriptionImpl readBundleDescription(DataInputStream dataInputStream) throws IOException {
        BundleDescription[] bundleDescriptionArray;
        Object object;
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        if (by == 2) {
            return (BundleDescriptionImpl)this.getFromObjectTable(dataInputStream.readInt());
        }
        BundleDescriptionImpl bundleDescriptionImpl = new BundleDescriptionImpl();
        this.addToObjectTable(bundleDescriptionImpl, dataInputStream.readInt());
        bundleDescriptionImpl.setBundleId(dataInputStream.readLong());
        this.readBaseDescription(bundleDescriptionImpl, dataInputStream);
        bundleDescriptionImpl.setLazyDataOffset(dataInputStream.readInt());
        bundleDescriptionImpl.setLazyDataSize(dataInputStream.readInt());
        bundleDescriptionImpl.setStateBit(1, dataInputStream.readBoolean());
        bundleDescriptionImpl.setStateBit(2, dataInputStream.readBoolean());
        bundleDescriptionImpl.setStateBit(32, dataInputStream.readBoolean());
        bundleDescriptionImpl.setStateBit(64, dataInputStream.readBoolean());
        bundleDescriptionImpl.setStateBit(128, dataInputStream.readBoolean());
        String[] stringArray = this.readList(dataInputStream);
        if (stringArray != null) {
            bundleDescriptionImpl.setDirective("mandatory", stringArray);
        }
        bundleDescriptionImpl.setAttributes(this.readMap(dataInputStream));
        bundleDescriptionImpl.setHost(this.readHostSpec(dataInputStream));
        int n = dataInputStream.readInt();
        if (n > 0) {
            object = new BundleDescription[n];
            int n2 = 0;
            while (n2 < n) {
                object[n2] = this.readBundleDescription(dataInputStream);
                ++n2;
            }
            bundleDescriptionImpl.addDependencies((BaseDescription[])object, false);
        }
        if ((object = (HostSpecificationImpl)bundleDescriptionImpl.getHost()) != null && (bundleDescriptionArray = ((HostSpecificationImpl)object).getHosts()) != null) {
            int n3 = 0;
            while (n3 < bundleDescriptionArray.length) {
                ((BundleDescriptionImpl)bundleDescriptionArray[n3]).addDependency(bundleDescriptionImpl, false);
                ++n3;
            }
        }
        bundleDescriptionImpl.setFullyLoaded(false);
        return bundleDescriptionImpl;
    }

    private BundleDescriptionImpl readBundleDescriptionLazyData(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        GenericDescription[] genericDescriptionArray;
        GenericSpecification[] genericSpecificationArray;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        BundleDescriptionImpl bundleDescriptionImpl;
        if (n > 0) {
            dataInputStream.skipBytes(n);
        }
        if ((bundleDescriptionImpl = (BundleDescriptionImpl)this.getFromObjectTable(n14 = dataInputStream.readInt())).isFullyLoaded()) {
            dataInputStream.skipBytes(bundleDescriptionImpl.getLazyDataSize() - 4);
            return bundleDescriptionImpl;
        }
        bundleDescriptionImpl.setLocation(this.readString(dataInputStream, false));
        bundleDescriptionImpl.setPlatformFilter(this.readString(dataInputStream, false));
        int n15 = dataInputStream.readInt();
        if (n15 > 0) {
            ExportPackageDescription[] exportPackageDescriptionArray = new ExportPackageDescription[n15];
            int n16 = 0;
            while (n16 < exportPackageDescriptionArray.length) {
                exportPackageDescriptionArray[n16] = this.readExportPackageDesc(dataInputStream);
                ++n16;
            }
            bundleDescriptionImpl.setExportPackages(exportPackageDescriptionArray);
        }
        if ((n13 = dataInputStream.readInt()) > 0) {
            ImportPackageSpecification[] importPackageSpecificationArray = new ImportPackageSpecification[n13];
            int n17 = 0;
            while (n17 < importPackageSpecificationArray.length) {
                importPackageSpecificationArray[n17] = this.readImportPackageSpec(dataInputStream);
                ++n17;
            }
            bundleDescriptionImpl.setImportPackages(importPackageSpecificationArray);
        }
        if ((n12 = dataInputStream.readInt()) > 0) {
            BundleSpecification[] bundleSpecificationArray = new BundleSpecification[n12];
            int n18 = 0;
            while (n18 < bundleSpecificationArray.length) {
                bundleSpecificationArray[n18] = this.readBundleSpec(dataInputStream);
                ++n18;
            }
            bundleDescriptionImpl.setRequiredBundles(bundleSpecificationArray);
        }
        if ((n11 = dataInputStream.readInt()) > 0) {
            ExportPackageDescription[] exportPackageDescriptionArray = new ExportPackageDescription[n11];
            int n19 = 0;
            while (n19 < exportPackageDescriptionArray.length) {
                exportPackageDescriptionArray[n19] = this.readExportPackageDesc(dataInputStream);
                ++n19;
            }
            bundleDescriptionImpl.setSelectedExports(exportPackageDescriptionArray);
        }
        if ((n10 = dataInputStream.readInt()) > 0) {
            ExportPackageDescription[] exportPackageDescriptionArray = new ExportPackageDescription[n10];
            int n20 = 0;
            while (n20 < exportPackageDescriptionArray.length) {
                exportPackageDescriptionArray[n20] = this.readExportPackageDesc(dataInputStream);
                ++n20;
            }
            bundleDescriptionImpl.setSubstitutedExports(exportPackageDescriptionArray);
        }
        if ((n9 = dataInputStream.readInt()) > 0) {
            ExportPackageDescription[] exportPackageDescriptionArray = new ExportPackageDescription[n9];
            int n21 = 0;
            while (n21 < exportPackageDescriptionArray.length) {
                exportPackageDescriptionArray[n21] = this.readExportPackageDesc(dataInputStream);
                ++n21;
            }
            bundleDescriptionImpl.setResolvedImports(exportPackageDescriptionArray);
        }
        if ((n8 = dataInputStream.readInt()) > 0) {
            BundleDescription[] bundleDescriptionArray = new BundleDescription[n8];
            int n22 = 0;
            while (n22 < bundleDescriptionArray.length) {
                bundleDescriptionArray[n22] = this.readBundleDescription(dataInputStream);
                ++n22;
            }
            bundleDescriptionImpl.setResolvedRequires(bundleDescriptionArray);
        }
        if ((n7 = dataInputStream.readInt()) > 0) {
            String[] stringArray = new String[n7];
            int n23 = 0;
            while (n23 < stringArray.length) {
                stringArray[n23] = this.readString(dataInputStream, false);
                ++n23;
            }
            bundleDescriptionImpl.setExecutionEnvironments(stringArray);
        }
        if ((n6 = dataInputStream.readInt()) > 0) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>(n6);
            int n24 = 0;
            while (n24 < n6) {
                genericSpecificationArray = this.readString(dataInputStream, false);
                genericDescriptionArray = new Long(dataInputStream.readLong());
                hashMap.put((String)genericSpecificationArray, (Long)genericDescriptionArray);
                ++n24;
            }
            bundleDescriptionImpl.setDynamicStamps(hashMap);
        }
        if ((n5 = dataInputStream.readInt()) > 0) {
            GenericDescription[] genericDescriptionArray2 = new GenericDescription[n5];
            int n25 = 0;
            while (n25 < genericDescriptionArray2.length) {
                genericDescriptionArray2[n25] = this.readGenericDescription(dataInputStream);
                ++n25;
            }
            bundleDescriptionImpl.setGenericCapabilities(genericDescriptionArray2);
        }
        if ((n4 = dataInputStream.readInt()) > 0) {
            genericSpecificationArray = new GenericSpecification[n4];
            int n26 = 0;
            while (n26 < genericSpecificationArray.length) {
                genericSpecificationArray[n26] = this.readGenericSpecification(dataInputStream);
                ++n26;
            }
            bundleDescriptionImpl.setGenericRequires(genericSpecificationArray);
        }
        if ((n3 = dataInputStream.readInt()) > 0) {
            genericDescriptionArray = new GenericDescription[n3];
            int n27 = 0;
            while (n27 < genericDescriptionArray.length) {
                genericDescriptionArray[n27] = this.readGenericDescription(dataInputStream);
                ++n27;
            }
            bundleDescriptionImpl.setSelectedCapabilities(genericDescriptionArray);
        }
        if ((n2 = dataInputStream.readInt()) > 0) {
            GenericDescription[] genericDescriptionArray3 = new GenericDescription[n2];
            int n28 = 0;
            while (n28 < genericDescriptionArray3.length) {
                genericDescriptionArray3[n28] = this.readGenericDescription(dataInputStream);
                ++n28;
            }
            bundleDescriptionImpl.setResolvedCapabilities(genericDescriptionArray3);
        }
        bundleDescriptionImpl.setNativeCodeSpecification(this.readNativeCode(dataInputStream));
        Map<String, Object> map = this.readMap(dataInputStream);
        bundleDescriptionImpl.setStateWires(map);
        bundleDescriptionImpl.setFullyLoaded(true);
        return bundleDescriptionImpl;
    }

    private BundleSpecificationImpl readBundleSpec(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        if (by == 2) {
            return (BundleSpecificationImpl)this.getFromObjectTable(dataInputStream.readInt());
        }
        BundleSpecificationImpl bundleSpecificationImpl = new BundleSpecificationImpl();
        int n = dataInputStream.readInt();
        this.addToObjectTable(bundleSpecificationImpl, n);
        this.readVersionConstraint(bundleSpecificationImpl, dataInputStream);
        bundleSpecificationImpl.setSupplier(this.readBundleDescription(dataInputStream));
        bundleSpecificationImpl.setExported(dataInputStream.readBoolean());
        bundleSpecificationImpl.setOptional(dataInputStream.readBoolean());
        bundleSpecificationImpl.setAttributes(this.readMap(dataInputStream));
        return bundleSpecificationImpl;
    }

    private ExportPackageDescriptionImpl readExportPackageDesc(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        if (by == 2) {
            return (ExportPackageDescriptionImpl)this.getFromObjectTable(dataInputStream.readInt());
        }
        ExportPackageDescriptionImpl exportPackageDescriptionImpl = new ExportPackageDescriptionImpl();
        int n = dataInputStream.readInt();
        this.addToObjectTable(exportPackageDescriptionImpl, n);
        this.readBaseDescription(exportPackageDescriptionImpl, dataInputStream);
        exportPackageDescriptionImpl.setExporter(this.readBundleDescription(dataInputStream));
        exportPackageDescriptionImpl.setAttributes(this.readMap(dataInputStream));
        exportPackageDescriptionImpl.setDirectives(this.readMap(dataInputStream));
        exportPackageDescriptionImpl.setFragmentDeclaration(this.readExportPackageDesc(dataInputStream));
        return exportPackageDescriptionImpl;
    }

    private DisabledInfo readDisabledInfo(DataInputStream dataInputStream) throws IOException {
        return new DisabledInfo(this.readString(dataInputStream, false), this.readString(dataInputStream, false), this.readBundleDescription(dataInputStream));
    }

    private Map<String, Object> readMap(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n);
        int n2 = 0;
        while (n2 < n) {
            String string = this.readString(dataInputStream, false);
            Object object = null;
            byte by = dataInputStream.readByte();
            if (by == 0) {
                object = this.readString(dataInputStream, false);
            } else if (by == 1) {
                object = this.readList(dataInputStream);
            } else if (by == 2) {
                object = dataInputStream.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            } else if (by == 3) {
                object = new Integer(dataInputStream.readInt());
            } else if (by == 4) {
                object = new Long(dataInputStream.readLong());
            } else if (by == 5) {
                object = new Double(dataInputStream.readDouble());
            } else if (by == 6) {
                object = this.readVersion(dataInputStream);
            } else if (by == 7) {
                object = this.readString(dataInputStream, false);
                try {
                    Class<?> clazz = Class.forName("java.net.URI");
                    Class[] classArray = new Class[1];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz2;
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    object = constructor.newInstance(object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage(), exception);
                }
            } else if (by == 8) {
                byte by2 = dataInputStream.readByte();
                int n3 = dataInputStream.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n3);
                int n4 = 0;
                while (n4 < n3) {
                    switch (by2) {
                        case 0: {
                            arrayList.add(this.readString(dataInputStream, false));
                            break;
                        }
                        case 3: {
                            arrayList.add(new Integer(dataInputStream.readInt()));
                            break;
                        }
                        case 4: {
                            arrayList.add(new Long(dataInputStream.readLong()));
                            break;
                        }
                        case 5: {
                            arrayList.add(new Double(dataInputStream.readDouble()));
                            break;
                        }
                        case 6: {
                            arrayList.add(this.readVersion(dataInputStream));
                            break;
                        }
                        case 7: {
                            arrayList.add(this.readStateWire(dataInputStream));
                            break;
                        }
                        default: {
                            throw new IOException(new StringBuffer("Invalid type: ").append(by2).toString());
                        }
                    }
                    ++n4;
                }
                object = arrayList;
            }
            hashMap.put(string, object);
            ++n2;
        }
        return hashMap;
    }

    private Object readStateWire(DataInputStream dataInputStream) throws IOException {
        BaseDescription baseDescription;
        VersionConstraint versionConstraint;
        byte by = dataInputStream.readByte();
        switch (by) {
            case 0: {
                versionConstraint = this.readImportPackageSpec(dataInputStream);
                baseDescription = this.readExportPackageDesc(dataInputStream);
                break;
            }
            case 1: {
                versionConstraint = this.readBundleSpec(dataInputStream);
                baseDescription = this.readBundleDescription(dataInputStream);
                break;
            }
            case 2: {
                versionConstraint = this.readHostSpec(dataInputStream);
                baseDescription = this.readBundleDescription(dataInputStream);
                break;
            }
            case 3: {
                versionConstraint = this.readGenericSpecification(dataInputStream);
                baseDescription = this.readGenericDescription(dataInputStream);
                break;
            }
            default: {
                throw new IOException(new StringBuffer("Invalid wire type: ").append(by).toString());
            }
        }
        BundleDescriptionImpl bundleDescriptionImpl = this.readBundleDescription(dataInputStream);
        BundleDescriptionImpl bundleDescriptionImpl2 = this.readBundleDescription(dataInputStream);
        return new StateWire(bundleDescriptionImpl, versionConstraint, bundleDescriptionImpl2, baseDescription);
    }

    private String[] readList(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.readString(dataInputStream, false);
            ++n2;
        }
        return stringArray;
    }

    private void readBaseDescription(BaseDescriptionImpl baseDescriptionImpl, DataInputStream dataInputStream) throws IOException {
        baseDescriptionImpl.setName(this.readString(dataInputStream, false));
        baseDescriptionImpl.setVersion(this.readVersion(dataInputStream));
    }

    private ImportPackageSpecificationImpl readImportPackageSpec(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        if (by == 2) {
            return (ImportPackageSpecificationImpl)this.getFromObjectTable(dataInputStream.readInt());
        }
        ImportPackageSpecificationImpl importPackageSpecificationImpl = new ImportPackageSpecificationImpl();
        int n = dataInputStream.readInt();
        this.addToObjectTable(importPackageSpecificationImpl, n);
        this.readVersionConstraint(importPackageSpecificationImpl, dataInputStream);
        importPackageSpecificationImpl.setSupplier(this.readExportPackageDesc(dataInputStream));
        importPackageSpecificationImpl.setBundleSymbolicName(this.readString(dataInputStream, false));
        importPackageSpecificationImpl.setBundleVersionRange(this.readVersionRange(dataInputStream));
        importPackageSpecificationImpl.setAttributes(this.readMap(dataInputStream));
        importPackageSpecificationImpl.setDirectives(this.readMap(dataInputStream));
        return importPackageSpecificationImpl;
    }

    private HostSpecificationImpl readHostSpec(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        if (by == 2) {
            return (HostSpecificationImpl)this.getFromObjectTable(dataInputStream.readInt());
        }
        HostSpecificationImpl hostSpecificationImpl = new HostSpecificationImpl();
        int n = dataInputStream.readInt();
        this.addToObjectTable(hostSpecificationImpl, n);
        this.readVersionConstraint(hostSpecificationImpl, dataInputStream);
        int n2 = dataInputStream.readInt();
        if (n2 > 0) {
            BundleDescription[] bundleDescriptionArray = new BundleDescription[n2];
            int n3 = 0;
            while (n3 < bundleDescriptionArray.length) {
                bundleDescriptionArray[n3] = this.readBundleDescription(dataInputStream);
                ++n3;
            }
            hostSpecificationImpl.setHosts(bundleDescriptionArray);
        }
        hostSpecificationImpl.setAttributes(this.readMap(dataInputStream));
        return hostSpecificationImpl;
    }

    private GenericDescription readGenericDescription(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        if (by == 2) {
            return (GenericDescription)this.getFromObjectTable(dataInputStream.readInt());
        }
        int n = dataInputStream.readInt();
        GenericDescriptionImpl genericDescriptionImpl = new GenericDescriptionImpl();
        this.addToObjectTable(genericDescriptionImpl, n);
        this.readBaseDescription(genericDescriptionImpl, dataInputStream);
        genericDescriptionImpl.setSupplier(this.readBundleDescription(dataInputStream));
        genericDescriptionImpl.setType(this.readString(dataInputStream, false));
        Map<String, Object> map = this.readMap(dataInputStream);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (map != null) {
            for (String string : map.keySet()) {
                ((Dictionary)hashtable).put(string, map.get(string));
            }
        }
        genericDescriptionImpl.setAttributes(hashtable);
        Map<String, Object> map2 = this.readMap(dataInputStream);
        if (map2 != null) {
            genericDescriptionImpl.setDirectives((Map<String, String>)map2);
        }
        genericDescriptionImpl.setFragmentDeclaration(this.readGenericDescription(dataInputStream));
        return genericDescriptionImpl;
    }

    private GenericSpecification readGenericSpecification(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        if (by == 2) {
            return (GenericSpecification)this.getFromObjectTable(dataInputStream.readInt());
        }
        GenericSpecificationImpl genericSpecificationImpl = new GenericSpecificationImpl();
        int n = dataInputStream.readInt();
        this.addToObjectTable(genericSpecificationImpl, n);
        this.readVersionConstraint(genericSpecificationImpl, dataInputStream);
        genericSpecificationImpl.setType(this.readString(dataInputStream, false));
        int n2 = dataInputStream.readInt();
        GenericDescription[] genericDescriptionArray = n2 == 0 ? null : new GenericDescription[n2];
        int n3 = 0;
        while (n3 < n2) {
            genericDescriptionArray[n3] = this.readGenericDescription(dataInputStream);
            ++n3;
        }
        genericSpecificationImpl.setSupplers(genericDescriptionArray);
        genericSpecificationImpl.setResolution(dataInputStream.readInt());
        try {
            genericSpecificationImpl.setMatchingFilter(this.readString(dataInputStream, false), false);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return genericSpecificationImpl;
    }

    private NativeCodeSpecification readNativeCode(DataInputStream dataInputStream) throws IOException {
        if (!dataInputStream.readBoolean()) {
            return null;
        }
        NativeCodeSpecificationImpl nativeCodeSpecificationImpl = new NativeCodeSpecificationImpl();
        nativeCodeSpecificationImpl.setOptional(dataInputStream.readBoolean());
        int n = dataInputStream.readInt();
        NativeCodeDescription[] nativeCodeDescriptionArray = new NativeCodeDescriptionImpl[n];
        int n2 = 0;
        while (n2 < n) {
            nativeCodeDescriptionArray[n2] = this.readNativeCodeDescription(dataInputStream);
            ++n2;
        }
        nativeCodeSpecificationImpl.setPossibleSuppliers(nativeCodeDescriptionArray);
        n2 = dataInputStream.readInt();
        if (n2 >= 0) {
            nativeCodeSpecificationImpl.setSupplier(nativeCodeDescriptionArray[n2]);
        }
        return nativeCodeSpecificationImpl;
    }

    private NativeCodeDescriptionImpl readNativeCodeDescription(DataInputStream dataInputStream) throws IOException {
        NativeCodeDescriptionImpl nativeCodeDescriptionImpl = new NativeCodeDescriptionImpl();
        this.readBaseDescription(nativeCodeDescriptionImpl, dataInputStream);
        nativeCodeDescriptionImpl.setSupplier(this.readBundleDescription(dataInputStream));
        try {
            nativeCodeDescriptionImpl.setFilter(this.readString(dataInputStream, false));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        nativeCodeDescriptionImpl.setLanguages(this.readStringArray(dataInputStream));
        nativeCodeDescriptionImpl.setNativePaths(this.readStringArray(dataInputStream));
        nativeCodeDescriptionImpl.setOSNames(this.readStringArray(dataInputStream));
        nativeCodeDescriptionImpl.setOSVersions(this.readVersionRanges(dataInputStream));
        nativeCodeDescriptionImpl.setProcessors(this.readStringArray(dataInputStream));
        nativeCodeDescriptionImpl.setInvalidNativePaths(dataInputStream.readBoolean());
        return nativeCodeDescriptionImpl;
    }

    private VersionRange[] readVersionRanges(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        VersionRange[] versionRangeArray = new VersionRange[n];
        int n2 = 0;
        while (n2 < n) {
            versionRangeArray[n2] = this.readVersionRange(dataInputStream);
            ++n2;
        }
        return versionRangeArray;
    }

    private String[] readStringArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.readString(dataInputStream, false);
            ++n2;
        }
        return stringArray;
    }

    private void readVersionConstraint(VersionConstraintImpl versionConstraintImpl, DataInputStream dataInputStream) throws IOException {
        versionConstraintImpl.setName(this.readString(dataInputStream, false));
        versionConstraintImpl.setVersionRange(this.readVersionRange(dataInputStream));
    }

    private Version readVersion(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return Version.emptyVersion;
        }
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        String string = this.readString(dataInputStream, false);
        Version version = (Version)ObjectPool.intern(new Version(n, n2, n3, string));
        return version;
    }

    private VersionRange readVersionRange(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        return new VersionRange(this.readVersion(dataInputStream), dataInputStream.readBoolean(), this.readVersion(dataInputStream), dataInputStream.readBoolean());
    }

    public synchronized boolean loadStateDeprecated(StateImpl stateImpl, DataInputStream dataInputStream, long l) throws IOException {
        try {
            boolean bl = this.readStateDeprecated(stateImpl, dataInputStream, l);
            return bl;
        }
        finally {
            dataInputStream.close();
        }
    }

    public synchronized boolean loadState(StateImpl stateImpl, long l) throws IOException {
        return this.readState(stateImpl, l);
    }

    private String readString(DataInputStream dataInputStream, boolean bl) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        if (bl) {
            return dataInputStream.readUTF().intern();
        }
        return (String)ObjectPool.intern(dataInputStream.readUTF());
    }

    private byte readTag(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readByte();
    }

    private DataInputStream openLazyFile() throws IOException {
        if (this.lazyFile == null) {
            throw new IOException();
        }
        return new DataInputStream(new BufferedInputStream(secureAction.getFileInputStream(this.lazyFile), 4096));
    }

    boolean isLazyLoaded() {
        return this.lazyLoad;
    }

    boolean getAccessedFlag() {
        return this.accessedFlag;
    }

    void setAccessedFlag(boolean bl) {
        this.accessedFlag = bl;
    }

    void fullyLoad() {
        this.setAccessedFlag(true);
        DataInputStream dataInputStream = null;
        try {
            try {
                dataInputStream = this.openLazyFile();
                int n = 0;
                while (n < this.numBundles) {
                    this.readBundleDescriptionLazyData(dataInputStream, 0);
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage(), iOException);
            }
        }
        catch (Throwable throwable) {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (dataInputStream != null) {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    void fullyLoad(BundleDescriptionImpl bundleDescriptionImpl) throws IOException {
        this.setAccessedFlag(true);
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = this.openLazyFile();
            ArrayList<BundleDescriptionImpl> arrayList = new ArrayList<BundleDescriptionImpl>();
            this.addDependencies(bundleDescriptionImpl, arrayList);
            int[] nArray = this.getSkipBytes(arrayList);
            int n = 0;
            while (n < nArray.length) {
                this.readBundleDescriptionLazyData(dataInputStream, nArray[n]);
                ++n;
            }
        }
        finally {
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
    }

    private void addDependencies(BundleDescriptionImpl bundleDescriptionImpl, List<BundleDescriptionImpl> list) {
        Object object;
        if (list.contains(bundleDescriptionImpl) || bundleDescriptionImpl.isFullyLoaded()) {
            return;
        }
        Iterator<BundleDescriptionImpl> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (bundleDescriptionImpl.getLazyDataOffset() < ((BundleDescriptionImpl)object).getLazyDataOffset()) break;
            ++n;
        }
        if (n >= list.size()) {
            list.add(bundleDescriptionImpl);
        } else {
            list.add(n, bundleDescriptionImpl);
        }
        object = bundleDescriptionImpl.getBundleDependencies();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            this.addDependencies((BundleDescriptionImpl)iterator2.next(), list);
        }
    }

    private int[] getSkipBytes(List<BundleDescriptionImpl> list) {
        int[] nArray = new int[list.size()];
        int n = 0;
        while (n < nArray.length) {
            BundleDescriptionImpl bundleDescriptionImpl = list.get(n);
            if (n == 0) {
                nArray[n] = bundleDescriptionImpl.getLazyDataOffset();
            } else {
                BundleDescriptionImpl bundleDescriptionImpl2 = list.get(n - 1);
                nArray[n] = bundleDescriptionImpl.getLazyDataOffset() - bundleDescriptionImpl2.getLazyDataOffset() - bundleDescriptionImpl2.getLazyDataSize();
            }
            ++n;
        }
        return nArray;
    }

    void flushLazyObjectCache() {
        Iterator<Map.Entry<Integer, Object>> iterator = this.objectTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Object> entry = iterator.next();
            Object object = entry.getValue();
            if (!(object instanceof ExportPackageDescription) && !(object instanceof GenericDescription) && !(object instanceof ImportPackageSpecification) && !(object instanceof BundleSpecification) && !(object instanceof GenericSpecification)) continue;
            iterator.remove();
        }
    }
}

