/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;

class RequiresHolder {
    private final BundleSpecification[] requiredBundles;
    private final BundleDescription[] resolvedRequires;
    private final boolean isUsingResolved;
    private final Map<BundleDescription, Boolean> resolvedBundlesExported;

    RequiresHolder(BundleDescription bundleDescription, int n) {
        boolean bl = this.isUsingResolved = (n & 2) != 0;
        if (this.isUsingResolved) {
            this.requiredBundles = null;
            this.resolvedBundlesExported = new HashMap<BundleDescription, Boolean>();
            this.resolvedRequires = bundleDescription.getResolvedRequires();
            this.determineRequiresVisibility(bundleDescription);
        } else {
            this.requiredBundles = bundleDescription.getRequiredBundles();
            this.resolvedBundlesExported = null;
            this.resolvedRequires = null;
        }
    }

    BundleDescription getSupplier(int n) {
        if (this.isUsingResolved) {
            return this.resolvedRequires[n];
        }
        return (BundleDescription)this.requiredBundles[n].getSupplier();
    }

    boolean isExported(int n) {
        if (this.isUsingResolved) {
            return this.resolvedBundlesExported.get(this.resolvedRequires[n]);
        }
        return this.requiredBundles[n].isExported();
    }

    int getSize() {
        if (this.isUsingResolved) {
            return this.resolvedRequires.length;
        }
        return this.requiredBundles.length;
    }

    private void determineRequiresVisibility(BundleDescription bundleDescription) {
        BundleSpecification[] bundleSpecificationArray = bundleDescription.getRequiredBundles();
        HashSet<BundleDescription> hashSet = new HashSet<BundleDescription>();
        int n = 0;
        while (n < this.resolvedRequires.length) {
            hashSet.add(this.resolvedRequires[n]);
            ++n;
        }
        n = 0;
        while (n < bundleSpecificationArray.length) {
            if (bundleSpecificationArray[n].getSupplier() != null) {
                this.resolvedBundlesExported.put((BundleDescription)bundleSpecificationArray[n].getSupplier(), new Boolean(bundleSpecificationArray[n].isExported()));
                hashSet.remove(bundleSpecificationArray[n].getSupplier());
            }
            ++n;
        }
        BundleDescription[] bundleDescriptionArray = bundleDescription.getFragments();
        if (hashSet.size() > 0) {
            int n2 = 0;
            while (n2 < bundleDescriptionArray.length) {
                BundleSpecification[] bundleSpecificationArray2 = bundleDescriptionArray[n2].getRequiredBundles();
                int n3 = 0;
                while (n3 < bundleSpecificationArray2.length) {
                    if (hashSet.contains(bundleSpecificationArray2[n3].getSupplier())) {
                        this.resolvedBundlesExported.put((BundleDescription)bundleSpecificationArray2[n3].getSupplier(), new Boolean(bundleSpecificationArray2[n3].isExported()));
                        hashSet.remove(bundleSpecificationArray2[n3].getSupplier());
                    }
                    ++n3;
                }
                if (hashSet.size() == 0) break;
                ++n2;
            }
        }
    }
}

