/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeCodeDescriptionImpl
extends BaseDescriptionImpl
implements NativeCodeDescription {
    private static final VersionRange[] EMPTY_VERSIONRANGES = new VersionRange[0];
    private volatile Filter filter;
    private String[] languages;
    private String[] nativePaths;
    private String[] osNames;
    private VersionRange[] osVersions;
    private String[] processors;
    private BundleDescription supplier;
    private volatile boolean invalidNativePaths = false;

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLanguages() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.languages == null) {
                return BundleDescriptionImpl.EMPTY_STRING;
            }
            return this.languages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNativePaths() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.nativePaths == null) {
                return BundleDescriptionImpl.EMPTY_STRING;
            }
            return this.nativePaths;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getOSNames() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.osNames == null) {
                return BundleDescriptionImpl.EMPTY_STRING;
            }
            return this.osNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionRange[] getOSVersions() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.osVersions == null) {
                return EMPTY_VERSIONRANGES;
            }
            return this.osVersions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getProcessors() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.processors == null) {
                return BundleDescriptionImpl.EMPTY_STRING;
            }
            return this.processors;
        }
    }

    @Override
    public BundleDescription getSupplier() {
        return this.supplier;
    }

    @Override
    public int compareTo(NativeCodeDescription nativeCodeDescription) {
        Version version;
        State state = this.getSupplier().getContainingState();
        if (state == null) {
            return 0;
        }
        Dictionary[] dictionaryArray = state.getPlatformProperties();
        try {
            version = Version.parseVersion((String)dictionaryArray[0].get("org.osgi.framework.os.version"));
        }
        catch (Exception exception) {
            version = Version.emptyVersion;
        }
        VersionRange[] versionRangeArray = this.getOSVersions();
        VersionRange[] versionRangeArray2 = nativeCodeDescription.getOSVersions();
        Version version2 = this.getHighestVersionMatch(version, versionRangeArray);
        Version version3 = this.getHighestVersionMatch(version, versionRangeArray2);
        if (version2.compareTo(version3) < 0) {
            return -1;
        }
        return (this.getLanguages().length == 0 ? 0 : 1) - (nativeCodeDescription.getLanguages().length == 0 ? 0 : 1);
    }

    @Override
    public boolean hasInvalidNativePaths() {
        return this.invalidNativePaths;
    }

    private Version getHighestVersionMatch(Version version, VersionRange[] versionRangeArray) {
        Version version2 = Version.emptyVersion;
        int n = 0;
        while (n < versionRangeArray.length) {
            if (versionRangeArray[n].isIncluded(version) && version2.compareTo(versionRangeArray[n].getMinimum()) < 0) {
                version2 = versionRangeArray[n].getMinimum();
            }
            ++n;
        }
        return version2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getNativePaths();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = this.getProcessors();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringBuffer.append("; ");
            stringBuffer.append("processor");
            stringBuffer.append('=');
            stringBuffer.append(stringArray2[n2]);
            ++n2;
        }
        String[] stringArray3 = this.getOSNames();
        int n3 = 0;
        while (n3 < stringArray3.length) {
            stringBuffer.append("; ");
            stringBuffer.append("osname");
            stringBuffer.append('=');
            stringBuffer.append(stringArray3[n3]);
            ++n3;
        }
        VersionRange[] versionRangeArray = this.getOSVersions();
        int n4 = 0;
        while (n4 < versionRangeArray.length) {
            stringBuffer.append("; ");
            stringBuffer.append("osversion");
            stringBuffer.append("=\"");
            stringBuffer.append(versionRangeArray[n4].toString());
            stringBuffer.append('\"');
            ++n4;
        }
        String[] stringArray4 = this.getLanguages();
        int n5 = 0;
        while (n5 < stringArray4.length) {
            stringBuffer.append("; ");
            stringBuffer.append("language");
            stringBuffer.append('=');
            stringBuffer.append(stringArray4[n5]);
            ++n5;
        }
        Filter filter = this.getFilter();
        if (filter != null) {
            stringBuffer.append("; ");
            stringBuffer.append("selection-filter");
            stringBuffer.append("=\"");
            stringBuffer.append(filter.toString());
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    void setInvalidNativePaths(boolean bl) {
        this.invalidNativePaths = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOSNames(String[] stringArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.osNames = stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOSVersions(VersionRange[] versionRangeArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.osVersions = versionRangeArray;
        }
    }

    void setFilter(String string) throws InvalidSyntaxException {
        this.filter = string == null ? null : FilterImpl.newInstance(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLanguages(String[] stringArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.languages = stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNativePaths(String[] stringArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.nativePaths = stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProcessors(String[] stringArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.processors = stringArray;
        }
    }

    void setSupplier(BundleDescription bundleDescription) {
        this.supplier = bundleDescription;
    }

    @Override
    public Map<String, String> getDeclaredDirectives() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Map<String, Object> getDeclaredAttributes() {
        return Collections.EMPTY_MAP;
    }
}

