/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostSpecificationImpl
extends VersionConstraintImpl
implements HostSpecification {
    private BundleDescription[] hosts;
    private boolean multihost = false;
    private Map<String, Object> attributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> getAttributes() {
        Object object = this.monitor;
        synchronized (object) {
            return this.attributes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributes(Map<String, ?> map) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = map;
        }
    }

    @Override
    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        Object object;
        String[] stringArray;
        if (!(baseDescription instanceof BundleDescriptionImpl)) {
            return false;
        }
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)baseDescription;
        if (bundleDescriptionImpl.getHost() != null) {
            return false;
        }
        Map<String, Object> map = this.getAttributes();
        if (map != null) {
            stringArray = bundleDescriptionImpl.getAttributes();
            if (stringArray == null) {
                return false;
            }
            for (String string : map.keySet()) {
                Object object2 = map.get(string);
                object = stringArray.get(string);
                if (object != null && object2.equals(object)) continue;
                return false;
            }
        }
        if ((stringArray = (String[])bundleDescriptionImpl.getDirective("mandatory")) != null) {
            object = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                string = object[n2];
                if (!("bundle-version".equals(string) || map != null && map.get(string) != null)) {
                    return false;
                }
                ++n2;
            }
        }
        return this.getName() != null && this.getName().equals(bundleDescriptionImpl.getSymbolicName()) && (this.getVersionRange() == null || this.getVersionRange().isIncluded(bundleDescriptionImpl.getVersion()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription[] getHosts() {
        Object object = this.monitor;
        synchronized (object) {
            return this.hosts == null ? BundleDescriptionImpl.EMPTY_BUNDLEDESCS : this.hosts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResolved() {
        Object object = this.monitor;
        synchronized (object) {
            return this.hosts != null && this.hosts.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHosts(BundleDescription[] bundleDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.hosts = bundleDescriptionArray;
        }
    }

    public String toString() {
        return new StringBuffer("Fragment-Host: ").append(this.getName()).append("; bundle-version=\"").append(this.getVersionRange()).append("\"").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseDescription getSupplier() {
        Object object = this.monitor;
        synchronized (object) {
            block4: {
                if (this.hosts != null && this.hosts.length != 0) break block4;
                return null;
            }
            return this.hosts[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMultiHost() {
        Object object = this.monitor;
        synchronized (object) {
            return this.multihost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsMultiHost(boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            this.multihost = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, String> getInternalDirectives() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        Object object = this.monitor;
        synchronized (object) {
            hashMap.put("filter", this.createFilterDirective());
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFilterDirective() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&");
        Object object = this.monitor;
        synchronized (object) {
            HostSpecificationImpl.addFilterAttribute(stringBuffer, "osgi.wiring.host", this.getName());
            VersionRange versionRange = this.getVersionRange();
            if (versionRange != null && versionRange != VersionRange.emptyRange) {
                HostSpecificationImpl.addFilterAttribute(stringBuffer, "bundle-version", versionRange);
            }
            if (this.attributes != null) {
                HostSpecificationImpl.addFilterAttributes(stringBuffer, this.attributes);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    protected Map<String, Object> getInteralAttributes() {
        return Collections.EMPTY_MAP;
    }

    @Override
    protected String getInternalNameSpace() {
        return "osgi.wiring.host";
    }
}

