/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPackageDescriptionImpl
extends BaseDescriptionImpl
implements ExportPackageDescription {
    public static final String EQUINOX_EE = "x-equinox-ee";
    private static final Integer EQUINOX_EE_DEFAULT = new Integer(-1);
    private String[] uses;
    private Map<String, Object> attributes;
    private volatile BundleDescription exporter;
    private String exclude;
    private String include;
    private String[] friends;
    private String[] mandatory;
    private Boolean internal = Boolean.FALSE;
    private int equinox_ee = -1;
    private ExportPackageDescription fragmentDeclaration = null;

    public ExportPackageDescriptionImpl() {
    }

    public ExportPackageDescriptionImpl(BundleDescription bundleDescription, ExportPackageDescription exportPackageDescription) {
        this.setName(exportPackageDescription.getName());
        this.setVersion(exportPackageDescription.getVersion());
        this.setDirectives(exportPackageDescription.getDirectives());
        this.setAttributes(exportPackageDescription.getAttributes());
        this.setExporter(bundleDescription);
        this.fragmentDeclaration = exportPackageDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getDirectives() {
        Object object = this.monitor;
        synchronized (object) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(7);
            if (this.uses != null) {
                hashMap.put("uses", this.uses);
            }
            if (this.exclude != null) {
                hashMap.put("exclude", this.exclude);
            }
            if (this.include != null) {
                hashMap.put("include", this.include);
            }
            if (this.mandatory != null) {
                hashMap.put("mandatory", this.mandatory);
            }
            if (this.friends != null) {
                hashMap.put("x-friends", this.friends);
            }
            hashMap.put("x-internal", this.internal);
            hashMap.put(EQUINOX_EE, this.equinox_ee == -1 ? EQUINOX_EE_DEFAULT : new Integer(this.equinox_ee));
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getDeclaredDirectives() {
        HashMap<String, String> hashMap = new HashMap<String, String>(6);
        Object object = this.monitor;
        synchronized (object) {
            if (this.uses != null) {
                hashMap.put("uses", ExportPackageDescriptionImpl.toString(this.uses));
            }
            if (this.exclude != null) {
                hashMap.put("exclude", this.exclude);
            }
            if (this.include != null) {
                hashMap.put("include", this.include);
            }
            if (this.mandatory != null) {
                hashMap.put("mandatory", ExportPackageDescriptionImpl.toString(this.mandatory));
            }
            if (this.friends != null) {
                hashMap.put("x-friends", ExportPackageDescriptionImpl.toString(this.friends));
            }
            if (this.internal != null) {
                hashMap.put("x-internal", this.internal.toString());
            }
            return Collections.unmodifiableMap(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getDeclaredAttributes() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        Object object = this.monitor;
        synchronized (object) {
            String string;
            if (this.attributes != null) {
                hashMap.putAll(this.attributes);
            }
            hashMap.put("osgi.wiring.package", this.getName());
            hashMap.put("version", this.getVersion());
            Version version = this.getSupplier().getVersion();
            if (version != null) {
                hashMap.put("bundle-version", version);
            }
            if ((string = this.getSupplier().getSymbolicName()) != null) {
                hashMap.put("bundle-symbolic-name", string);
            }
            return Collections.unmodifiableMap(hashMap);
        }
    }

    static String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            stringBuffer.append(string).append(',');
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getDirective(String string) {
        Object object = this.monitor;
        synchronized (object) {
            if (string.equals("uses")) {
                return this.uses;
            }
            if (string.equals("exclude")) {
                return this.exclude;
            }
            if (string.equals("include")) {
                return this.include;
            }
            if (string.equals("mandatory")) {
                return this.mandatory;
            }
            if (string.equals("x-friends")) {
                return this.friends;
            }
            if (string.equals("x-internal")) {
                return this.internal;
            }
            if (string.equals(EQUINOX_EE)) {
                return this.equinox_ee == -1 ? EQUINOX_EE_DEFAULT : new Integer(this.equinox_ee);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setDirective(String string, Object object) {
        Object object2 = this.monitor;
        synchronized (object2) {
            if (string.equals("uses")) {
                this.uses = (String[])object;
                return this.uses;
            }
            if (string.equals("exclude")) {
                this.exclude = (String)object;
                return this.exclude;
            }
            if (string.equals("include")) {
                this.include = (String)object;
                return this.include;
            }
            if (string.equals("mandatory")) {
                this.mandatory = (String[])object;
                return this.mandatory;
            }
            if (string.equals("x-friends")) {
                this.friends = (String[])object;
                return this.friends;
            }
            if (string.equals("x-internal")) {
                this.internal = (Boolean)object;
                return this.internal;
            }
            if (string.equals(EQUINOX_EE)) {
                this.equinox_ee = (Integer)object;
                return object;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectives(Map<String, ?> map) {
        Object object = this.monitor;
        synchronized (object) {
            if (map == null) {
                return;
            }
            this.uses = (String[])map.get("uses");
            this.exclude = (String)map.get("exclude");
            this.include = (String)map.get("include");
            this.mandatory = (String[])map.get("mandatory");
            this.friends = (String[])map.get("x-friends");
            this.internal = (Boolean)map.get("x-internal");
            this.equinox_ee = (Integer)map.get(EQUINOX_EE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAttributes() {
        Object object = this.monitor;
        synchronized (object) {
            return this.attributes;
        }
    }

    @Override
    public BundleDescription getSupplier() {
        return this.getExporter();
    }

    @Override
    public BundleDescription getExporter() {
        return this.exporter;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAttributes(Map<String, ?> map) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = map;
        }
    }

    protected void setExporter(BundleDescription bundleDescription) {
        this.exporter = bundleDescription;
    }

    @Override
    public BaseDescription getFragmentDeclaration() {
        return this.fragmentDeclaration;
    }

    void setFragmentDeclaration(ExportPackageDescription exportPackageDescription) {
        this.fragmentDeclaration = exportPackageDescription;
    }

    public String toString() {
        return new StringBuffer("Export-Package: ").append(this.getName()).append("; version=\"").append(this.getVersion()).append("\"").toString();
    }

    @Override
    String getInternalNameSpace() {
        return "osgi.wiring.package";
    }
}

