/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.provisional.service.security;

import java.util.HashMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEvent;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationListener;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AuthorizationEngine {
    private EventManager manager = new EventManager();
    private EventDispatcher<AuthorizationListener, Object, AuthorizationEvent> dispatcher = new AuthEventDispatcher();
    private final ServiceTracker<AuthorizationListener, AuthorizationListener> listenerTracker;
    static /* synthetic */ Class class$0;

    public AuthorizationEngine(BundleContext bundleContext) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.service.security.AuthorizationListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.listenerTracker.open();
    }

    public final void authorize(SignedContent signedContent, Object object) {
        this.fireEvent(this.doAuthorize(signedContent, object));
    }

    private void fireEvent(AuthorizationEvent authorizationEvent) {
        ListenerQueue<AuthorizationListener, Object, AuthorizationEvent> listenerQueue;
        if (authorizationEvent == null) {
            return;
        }
        Object[] objectArray = this.listenerTracker.getServices();
        if (objectArray == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            listenerQueue = objectArray2[n2];
            hashMap.put((AuthorizationListener)((Object)listenerQueue), listenerQueue);
            ++n2;
        }
        listenerQueue = new ListenerQueue<AuthorizationListener, Object, AuthorizationEvent>(this.manager);
        listenerQueue.queueListeners(hashMap.entrySet(), this.dispatcher);
        listenerQueue.dispatchEventSynchronous(0, authorizationEvent);
    }

    protected abstract AuthorizationEvent doAuthorize(SignedContent var1, Object var2);

    public abstract int getStatus();

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AuthEventDispatcher
    implements EventDispatcher<AuthorizationListener, Object, AuthorizationEvent> {
        AuthEventDispatcher() {
        }

        @Override
        public void dispatchEvent(AuthorizationListener authorizationListener, Object object, int n, AuthorizationEvent authorizationEvent) {
            authorizationListener.authorizationEvent(authorizationEvent);
        }
    }
}

