/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.eclipse.osgi.internal.permadmin.SecurityRow;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTable
extends PermissionCollection {
    private static final long serialVersionUID = -1800193310096318060L;
    static final int GRANTED = 1;
    static final int DENIED = 2;
    static final int ABSTAIN = 4;
    static final int POSTPONED = 8;
    private final SecurityRow[] rows;
    private final SecurityAdmin securityAdmin;

    public SecurityTable(SecurityAdmin securityAdmin, SecurityRow[] securityRowArray) {
        if (securityRowArray == null) {
            throw new NullPointerException("rows cannot be null!!");
        }
        this.rows = securityRowArray;
        this.securityAdmin = securityAdmin;
    }

    boolean isEmpty() {
        return this.rows.length == 0;
    }

    int evaluate(BundlePermissions bundlePermissions, Permission permission) {
        if (this.isEmpty()) {
            return 4;
        }
        boolean bl = false;
        SecurityRow.Decision[] decisionArray = new SecurityRow.Decision[this.rows.length];
        int n = -1;
        int n2 = 0;
        while (n2 < this.rows.length) {
            try {
                decisionArray[n2] = this.rows[n2].evaluate(bundlePermissions, permission);
            }
            catch (Throwable throwable) {
                decisionArray[n2] = SecurityRow.DECISION_ABSTAIN;
            }
            if ((decisionArray[n2].decision & 4) == 0) {
                if ((decisionArray[n2].decision & 8) != 0) {
                    bl = true;
                } else {
                    if (!bl) {
                        return decisionArray[n2].decision;
                    }
                    n = n2;
                    break;
                }
            }
            ++n2;
        }
        if (bl) {
            n2 = n < 0 ? 2 : decisionArray[n].decision;
            boolean bl2 = true;
            int n3 = n < 0 ? decisionArray.length - 1 : n - 1;
            while (n3 >= 0 && bl2) {
                if (decisionArray[n3] != null && (decisionArray[n3].decision & 8) != 0) {
                    if ((decisionArray[n3].decision & n2) == 0) {
                        bl2 = false;
                    } else {
                        decisionArray[n3] = SecurityRow.DECISION_ABSTAIN;
                    }
                }
                --n3;
            }
            if (bl2) {
                return n2;
            }
            EquinoxSecurityManager equinoxSecurityManager = this.securityAdmin.getSupportedSecurityManager();
            if (equinoxSecurityManager == null) {
                return 4;
            }
            equinoxSecurityManager.addConditionsForDomain(decisionArray);
        }
        return bl ? 8 : 4;
    }

    SecurityRow getRow(int n) {
        return this.rows.length <= n || n < 0 ? null : this.rows[n];
    }

    SecurityRow getRow(String string) {
        int n = 0;
        while (n < this.rows.length) {
            if (string.equals(this.rows[n].getName())) {
                return this.rows[n];
            }
            ++n;
        }
        return null;
    }

    SecurityRow[] getRows() {
        return this.rows;
    }

    String[] getEncodedRows() {
        String[] stringArray = new String[this.rows.length];
        int n = 0;
        while (n < this.rows.length) {
            stringArray[n] = this.rows[n].getEncoded();
            ++n;
        }
        return stringArray;
    }

    @Override
    public void add(Permission permission) {
        throw new SecurityException();
    }

    @Override
    public Enumeration<Permission> elements() {
        return BundlePermissions.EMPTY_ENUMERATION;
    }

    @Override
    public boolean implies(Permission permission) {
        return (this.evaluate(null, permission) & 1) != 0;
    }
}

