/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.security.BasicPermission;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.PackagePermission;

public class PermissionChecker {
    private boolean checkPermissions = false;
    private ResolverImpl resolver;

    public PermissionChecker(boolean bl, ResolverImpl resolverImpl) {
        this.checkPermissions = bl;
        this.resolver = resolverImpl;
    }

    public boolean checkPermission(VersionConstraint versionConstraint, BaseDescription baseDescription) {
        if (!this.checkPermissions) {
            return true;
        }
        boolean bl = false;
        BasicPermission basicPermission = null;
        BasicPermission basicPermission2 = null;
        Bundle bundle = null;
        Bundle bundle2 = baseDescription.getSupplier().getBundle();
        int n = 0;
        if (versionConstraint instanceof ImportPackageSpecification) {
            n = 128;
            basicPermission = new PackagePermission(baseDescription.getName(), "exportonly");
            basicPermission2 = bundle2 != null ? new PackagePermission(versionConstraint.getName(), bundle2, "import") : new PackagePermission(versionConstraint.getName(), "import");
        } else if (versionConstraint instanceof BundleSpecification || versionConstraint instanceof HostSpecification) {
            boolean bl2 = versionConstraint instanceof BundleSpecification;
            n = bl2 ? 512 : 4096;
            basicPermission = new BundlePermission(baseDescription.getName(), bl2 ? "provide" : "host");
            basicPermission2 = new BundlePermission(versionConstraint.getName(), bl2 ? "require" : "fragment");
        } else if (versionConstraint instanceof GenericSpecification) {
            n = 524288;
            GenericDescription genericDescription = (GenericDescription)baseDescription;
            basicPermission = new CapabilityPermission(genericDescription.getType(), "provide");
            basicPermission2 = new CapabilityPermission(genericDescription.getType(), genericDescription.getDeclaredAttributes(), bundle2, "require");
        }
        bundle = versionConstraint.getBundle().getBundle();
        if (bundle2 != null && (bundle2.getState() & 1) == 0 && !(bl = bundle2.hasPermission(basicPermission))) {
            switch (n) {
                case 128: {
                    n = 256;
                    break;
                }
                case 512: 
                case 4096: {
                    n = n == 512 ? 1024 : 2048;
                    break;
                }
                case 524288: {
                    n = 1024;
                }
            }
            this.resolver.getState().addResolverError(versionConstraint.getBundle(), n, basicPermission.toString(), versionConstraint);
        }
        if (bl && bundle != null && (bundle.getState() & 1) == 0 && !(bl = bundle.hasPermission(basicPermission2))) {
            this.resolver.getState().addResolverError(versionConstraint.getBundle(), n, basicPermission2.toString(), versionConstraint);
        }
        return bl;
    }

    boolean checkPackagePermission(ExportPackageDescription exportPackageDescription) {
        if (!this.checkPermissions) {
            return true;
        }
        exportPackageDescription.getSupplier().getBundle();
        Bundle bundle = exportPackageDescription.getSupplier().getBundle();
        return bundle == null ? false : bundle.hasPermission(new PackagePermission(exportPackageDescription.getName(), "exportonly"));
    }

    boolean checkCapabilityPermission(GenericDescription genericDescription) {
        if (!this.checkPermissions) {
            return true;
        }
        Bundle bundle = genericDescription.getSupplier().getBundle();
        return bundle == null ? false : bundle.hasPermission(new CapabilityPermission(genericDescription.getType(), "provide"));
    }
}

