/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.GenericSpecification;

public class GenericConstraint
extends ResolverConstraint {
    private boolean supplierHasUses;

    GenericConstraint(ResolverBundle resolverBundle, GenericSpecification genericSpecification) {
        super(resolverBundle, genericSpecification);
    }

    boolean isOptional() {
        return (((GenericSpecification)this.constraint).getResolution() & 1) != 0;
    }

    boolean isMultiple() {
        return !this.supplierHasUses && (((GenericSpecification)this.constraint).getResolution() & 2) != 0;
    }

    public String getNameSpace() {
        return ((GenericSpecification)this.getVersionConstraint()).getType();
    }

    public VersionSupplier[] getMatchingCapabilities() {
        VersionSupplier[] versionSupplierArray;
        if (this.isMultiple()) {
            return this.getPossibleSuppliers();
        }
        VersionSupplier versionSupplier = this.getSelectedSupplier();
        if (versionSupplier == null) {
            versionSupplierArray = null;
        } else {
            VersionSupplier[] versionSupplierArray2 = new VersionSupplier[1];
            versionSupplierArray = versionSupplierArray2;
            versionSupplierArray2[0] = versionSupplier;
        }
        return versionSupplierArray;
    }

    void addPossibleSupplier(VersionSupplier versionSupplier) {
        this.supplierHasUses |= ((GenericCapability)versionSupplier).getUsesDirective() != null;
        super.addPossibleSupplier(versionSupplier);
    }

    void clearPossibleSuppliers() {
        super.clearPossibleSuppliers();
        this.supplierHasUses = false;
    }

    boolean supplierHasUses() {
        return this.supplierHasUses;
    }
}

