/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPolicy
implements IBuddyPolicy {
    public static final byte BOOT = 0;
    public static final byte EXT = 1;
    public static final byte APP = 2;
    private static SystemPolicy[] instances = new SystemPolicy[3];
    private ClassLoader classLoader;
    static /* synthetic */ Class class$0;

    public static SystemPolicy getInstance(final byte by) {
        if (instances[by] == null) {
            SystemPolicy.instances[by] = new SystemPolicy();
            SystemPolicy.instances[by].classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return SystemPolicy.createClassLoader(by);
                }
            });
        }
        return instances[by];
    }

    public SystemPolicy() {
    }

    public SystemPolicy(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static ClassLoader createClassLoader(byte by) {
        switch (by) {
            case 2: {
                if (ClassLoader.getSystemClassLoader() != null) {
                    return ClassLoader.getSystemClassLoader();
                }
                return new ParentClassLoader();
            }
            case 0: {
                return new ParentClassLoader();
            }
            case 1: {
                if (ClassLoader.getSystemClassLoader() != null) {
                    return ClassLoader.getSystemClassLoader().getParent();
                }
                return new ParentClassLoader();
            }
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String string) {
        try {
            return this.classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public URL loadResource(String string) {
        return this.classLoader.getResource(string);
    }

    @Override
    public Enumeration<URL> loadResources(String string) {
        try {
            return this.classLoader.getResources(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static class ParentClassLoader
    extends ClassLoader {
        protected ParentClassLoader() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(clazz.getClassLoader());
        }
    }
}

