/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.buddy;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.buddy.DependentPolicy;
import org.eclipse.osgi.internal.loader.buddy.GlobalPolicy;
import org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;
import org.eclipse.osgi.internal.loader.buddy.RegisteredPolicy;
import org.eclipse.osgi.internal.loader.buddy.SystemPolicy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyHandler
implements SynchronousBundleListener {
    private static final String DEPENDENT_POLICY = "dependent";
    private static final String GLOBAL_POLICY = "global";
    private static final String REGISTERED_POLICY = "registered";
    private static final String APP_POLICY = "app";
    private static final String EXT_POLICY = "ext";
    private static final String BOOT_POLICY = "boot";
    private static final String PARENT_POLICY = "parent";
    private final BundleLoader policedLoader;
    private volatile Object[] policies = null;
    private final ThreadLocal<Set<String>> beingLoaded;
    private final PackageAdmin packageAdmin;

    public PolicyHandler(BundleLoader bundleLoader, String string, PackageAdmin packageAdmin) {
        this.policedLoader = bundleLoader;
        this.policies = PolicyHandler.getArrayFromList(string);
        this.beingLoaded = new ThreadLocal();
        this.packageAdmin = packageAdmin;
    }

    static Object[] getArrayFromList(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) continue;
            arrayList.add(string2);
        }
        return arrayList.isEmpty() ? new Object[]{} : arrayList.toArray(new Object[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBuddyPolicy getPolicyImplementation(Object[] objectArray, int n) {
        Object[] objectArray2 = objectArray;
        synchronized (objectArray) {
            block12: {
                if (n < objectArray.length) break block12;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            if (objectArray[n] instanceof String) {
                String string = (String)objectArray[n];
                if (REGISTERED_POLICY.equals(string)) {
                    objectArray[n] = new RegisteredPolicy(this.policedLoader);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (BOOT_POLICY.equals(string)) {
                    objectArray[n] = SystemPolicy.getInstance((byte)0);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (APP_POLICY.equals(string)) {
                    objectArray[n] = SystemPolicy.getInstance((byte)2);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (EXT_POLICY.equals(string)) {
                    objectArray[n] = SystemPolicy.getInstance((byte)1);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (DEPENDENT_POLICY.equals(string)) {
                    objectArray[n] = new DependentPolicy(this.policedLoader);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (GLOBAL_POLICY.equals(string)) {
                    objectArray[n] = new GlobalPolicy(this.packageAdmin);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (PARENT_POLICY.equals(string)) {
                    objectArray[n] = new SystemPolicy(this.policedLoader.getParentClassLoader());
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (IBuddyPolicy)objectArray[n];
        }
    }

    public Class<?> doBuddyClassLoading(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        Class<?> clazz = null;
        Object[] objectArray = this.policies;
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n && clazz == null) {
            IBuddyPolicy iBuddyPolicy = this.getPolicyImplementation(objectArray, n2);
            if (iBuddyPolicy != null) {
                clazz = iBuddyPolicy.loadClass(string);
            }
            ++n2;
        }
        this.stopLoading(string);
        return clazz;
    }

    public URL doBuddyResourceLoading(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        URL uRL = null;
        Object[] objectArray = this.policies;
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n && uRL == null) {
            IBuddyPolicy iBuddyPolicy = this.getPolicyImplementation(objectArray, n2);
            if (iBuddyPolicy != null) {
                uRL = iBuddyPolicy.loadResource(string);
            }
            ++n2;
        }
        this.stopLoading(string);
        return uRL;
    }

    public Enumeration<URL> doBuddyResourcesLoading(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        ArrayList<URL> arrayList = null;
        Object[] objectArray = this.policies;
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enumeration<URL> enumeration;
            IBuddyPolicy iBuddyPolicy = this.getPolicyImplementation(objectArray, n2);
            if (iBuddyPolicy != null && (enumeration = iBuddyPolicy.loadResources(string)) != null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<URL>(n);
                }
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    if (arrayList.contains(uRL)) continue;
                    arrayList.add(uRL);
                }
            }
            ++n2;
        }
        this.stopLoading(string);
        return arrayList == null || arrayList.isEmpty() ? null : Collections.enumeration(arrayList);
    }

    private boolean startLoading(String string) {
        Set<String> set = this.beingLoaded.get();
        if (set != null && set.contains(string)) {
            return false;
        }
        if (set == null) {
            set = new HashSet<String>(3);
            this.beingLoaded.set(set);
        }
        set.add(string);
        return true;
    }

    private void stopLoading(String string) {
        this.beingLoaded.get().remove(string);
    }

    public void open(BundleContext bundleContext) {
        bundleContext.addBundleListener(this);
    }

    public void close(BundleContext bundleContext) {
        bundleContext.removeBundleListener(this);
    }

    @Override
    public void bundleChanged(BundleEvent bundleEvent) {
        if ((bundleEvent.getType() & 0x60) == 0) {
            return;
        }
        try {
            String string = this.policedLoader.getBundle().getBundleData().getManifest().get("Eclipse-BuddyPolicy");
            this.policies = PolicyHandler.getArrayFromList(string);
        }
        catch (BundleException bundleException) {}
    }
}

