/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalPolicy
implements IBuddyPolicy {
    private PackageAdmin admin;

    public GlobalPolicy(PackageAdmin packageAdmin) {
        this.admin = packageAdmin;
    }

    @Override
    public Class<?> loadClass(String string) {
        ExportedPackage exportedPackage = this.admin.getExportedPackage(BundleLoader.getPackageName(string));
        if (exportedPackage == null) {
            return null;
        }
        try {
            return exportedPackage.getExportingBundle().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public URL loadResource(String string) {
        ExportedPackage exportedPackage = this.admin.getExportedPackage(BundleLoader.getResourcePackageName(string));
        if (exportedPackage == null) {
            return null;
        }
        return exportedPackage.getExportingBundle().getResource(string);
    }

    @Override
    public Enumeration<URL> loadResources(String string) {
        ExportedPackage[] exportedPackageArray = this.admin.getExportedPackages(BundleLoader.getResourcePackageName(string));
        if (exportedPackageArray == null || exportedPackageArray.length == 0) {
            return null;
        }
        Enumeration<URL> enumeration = null;
        int n = 0;
        while (n < exportedPackageArray.length) {
            try {
                enumeration = BundleLoader.compoundEnumerations(enumeration, exportedPackageArray[n].getExportingBundle().getResources(string));
            }
            catch (IOException iOException) {}
            ++n;
        }
        return enumeration;
    }
}

