/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.loader.SingleSourcePackage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageSource
implements KeyedElement {
    protected String id;

    public PackageSource(String string) {
        this.id = string.intern();
    }

    public String getId() {
        return this.id;
    }

    public abstract SingleSourcePackage[] getSuppliers();

    @Override
    public boolean compare(KeyedElement keyedElement) {
        return this.id.equals(((PackageSource)keyedElement).getId());
    }

    @Override
    public int getKeyHashCode() {
        return this.id.hashCode();
    }

    @Override
    public Object getKey() {
        return this.id;
    }

    public boolean isNullSource() {
        return false;
    }

    public boolean isFriend(String string) {
        return true;
    }

    public abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    public abstract URL getResource(String var1);

    public abstract Enumeration<URL> getResources(String var1) throws IOException;

    public boolean hasCommonSource(PackageSource packageSource) {
        if (packageSource == null) {
            return false;
        }
        if (this == packageSource) {
            return true;
        }
        SingleSourcePackage[] singleSourcePackageArray = this.getSuppliers();
        SingleSourcePackage[] singleSourcePackageArray2 = packageSource.getSuppliers();
        if (singleSourcePackageArray == null || singleSourcePackageArray2 == null) {
            return false;
        }
        int n = 0;
        while (n < singleSourcePackageArray.length) {
            int n2 = 0;
            while (n2 < singleSourcePackageArray2.length) {
                if (singleSourcePackageArray2[n2].equals(singleSourcePackageArray[n])) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public abstract Collection<String> listResources(String var1, String var2);
}

