/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor.weaving;

import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.internal.baseadaptor.weaving.WovenClassImpl;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeavingHookConfigurator
implements HookConfigurator,
ClassLoadingHook,
ClassLoadingStatsHook {
    private BaseAdaptor adaptor;
    private final Map<ServiceRegistration<?>, Boolean> blackList = Collections.synchronizedMap(new WeakHashMap());
    private final ThreadLocal<List<WovenClassImpl>> wovenClassStack = new ThreadLocal();

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        this.adaptor = hookRegistry.getAdaptor();
        hookRegistry.addClassLoadingHook(this);
        hookRegistry.addClassLoadingStatsHook(this);
    }

    private ServiceRegistry getRegistry() {
        return ((Framework)this.adaptor.getEventPublisher()).getServiceRegistry();
    }

    @Override
    public byte[] processClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        ServiceRegistry serviceRegistry = this.getRegistry();
        if (serviceRegistry == null) {
            return null;
        }
        ClassLoaderDelegate classLoaderDelegate = classpathManager.getBaseClassLoader().getDelegate();
        if (!(classLoaderDelegate instanceof BundleLoader)) {
            IllegalStateException illegalStateException = new IllegalStateException("Could not obtain loader");
            this.adaptor.getEventPublisher().publishFrameworkEvent(2, classpathManager.getBaseData().getBundle(), illegalStateException);
            return null;
        }
        BundleLoader bundleLoader = (BundleLoader)classLoaderDelegate;
        WovenClassImpl wovenClassImpl = new WovenClassImpl(string, byArray, classpathEntry.getDomain(), bundleLoader, serviceRegistry, this.blackList);
        List<WovenClassImpl> list = this.wovenClassStack.get();
        if (list == null) {
            list = new ArrayList<WovenClassImpl>(6);
            this.wovenClassStack.set(list);
        }
        list.add(wovenClassImpl);
        try {
            return wovenClassImpl.callHooks();
        }
        catch (Throwable throwable) {
            ServiceRegistration<?> serviceRegistration = wovenClassImpl.getErrorHook();
            Bundle bundle = serviceRegistration != null ? serviceRegistration.getReference().getBundle() : classpathManager.getBaseData().getBundle();
            this.adaptor.getEventPublisher().publishFrameworkEvent(2, bundle, throwable);
            ClassFormatError classFormatError = new ClassFormatError("Unexpected error from weaving hook.");
            classFormatError.initCause(throwable);
            throw classFormatError;
        }
    }

    @Override
    public boolean addClassPathEntry(ArrayList<ClasspathEntry> arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        return false;
    }

    @Override
    public String findLibrary(BaseData baseData, String string) {
        return null;
    }

    @Override
    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    @Override
    public BaseClassLoader createClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, BaseData baseData, String[] stringArray) {
        return null;
    }

    @Override
    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData baseData) {
    }

    @Override
    public void preFindLocalClass(String string, ClasspathManager classpathManager) {
    }

    @Override
    public void postFindLocalClass(String string, Class<?> clazz, ClasspathManager classpathManager) {
    }

    @Override
    public void preFindLocalResource(String string, ClasspathManager classpathManager) {
    }

    @Override
    public void postFindLocalResource(String string, URL uRL, ClasspathManager classpathManager) {
    }

    @Override
    public void recordClassDefine(String string, Class<?> clazz, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        List<WovenClassImpl> list = this.wovenClassStack.get();
        if (list == null || list.size() == 0) {
            return;
        }
        WovenClassImpl wovenClassImpl = list.remove(list.size() - 1);
        wovenClassImpl.setWeavingCompleted(clazz);
    }
}

