/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor.weaving;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.osgi.internal.baseadaptor.weaving.WovenClassImpl;
import org.eclipse.osgi.internal.resolver.StateBuilder;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.ManifestElement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicImportList
extends AbstractList<String>
implements RandomAccess {
    private final List<String> imports = new ArrayList<String>(0);
    private final WovenClassImpl wovenClass;

    public DynamicImportList(WovenClassImpl wovenClassImpl) {
        this.wovenClass = wovenClassImpl;
    }

    @Override
    public String get(int n) {
        return this.imports.get(n);
    }

    @Override
    public int size() {
        return this.imports.size();
    }

    @Override
    public String set(int n, String string) {
        this.wovenClass.checkPermission();
        this.validateSyntax(string);
        return this.imports.set(n, string);
    }

    @Override
    public void add(int n, String string) {
        this.wovenClass.checkPermission();
        this.validateSyntax(string);
        this.imports.add(n, string);
    }

    @Override
    public String remove(int n) {
        this.wovenClass.checkPermission();
        return this.imports.remove(n);
    }

    private void validateSyntax(String string) {
        try {
            ManifestElement[] manifestElementArray = ManifestElement.parseHeader("Import-Package", string);
            StateBuilder.checkImportExportSyntax("Import-Package", manifestElementArray, false, false, false);
            ArrayList<ImportPackageSpecification> arrayList = new ArrayList<ImportPackageSpecification>(manifestElementArray.length);
            ManifestElement[] manifestElementArray2 = manifestElementArray;
            int n = manifestElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement manifestElement = manifestElementArray2[n2];
                StateBuilder.addImportPackages(manifestElement, arrayList, 2, true);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(throwable);
            throw illegalArgumentException;
        }
    }
}

