/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFileWrapperChain;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.baseadaptor.loader.ParallelClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoader
extends ClassLoader
implements ParallelClassLoader {
    protected static final PermissionCollection ALLPERMISSIONS;
    private static final String CLASS_CERTIFICATE_SUPPORT = "osgi.support.class.certificate";
    private static final String CLASS_LOADER_TYPE = "osgi.classloader.type";
    private static final String CLASS_LOADER_TYPE_PARALLEL = "parallel";
    private static final boolean CLASS_CERTIFICATE;
    private static final boolean PARALLEL_CAPABLE;
    private static final Enumeration<URL> EMPTY_ENUMERATION;
    protected ClassLoaderDelegate delegate;
    protected ProtectionDomain domain;
    protected ClasspathManager manager;
    static /* synthetic */ Class class$0;

    static {
        boolean bl;
        block6: {
            EMPTY_ENUMERATION = Collections.enumeration(Collections.EMPTY_LIST);
            CLASS_CERTIFICATE = Boolean.valueOf(FrameworkProperties.getProperty(CLASS_CERTIFICATE_SUPPORT, "true"));
            AllPermission allPermission = new AllPermission();
            ALLPERMISSIONS = allPermission.newPermissionCollection();
            if (ALLPERMISSIONS != null) {
                ALLPERMISSIONS.add(allPermission);
            }
            boolean bl2 = CLASS_LOADER_TYPE_PARALLEL.equals(FrameworkProperties.getProperty(CLASS_LOADER_TYPE, CLASS_LOADER_TYPE_PARALLEL));
            bl = false;
            try {
                if (!bl2) break block6;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.ClassLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Method method = clazz.getDeclaredMethod("registerAsParallelCapable", null);
                method.setAccessible(true);
                bl = (Boolean)method.invoke(null, null);
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        PARALLEL_CAPABLE = bl;
    }

    public DefaultClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, ProtectionDomain protectionDomain, BaseData baseData, String[] stringArray) {
        super(classLoader);
        this.delegate = classLoaderDelegate;
        this.domain = protectionDomain;
        this.manager = new ClasspathManager(baseData, stringArray, this);
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (Debug.DEBUG_LOADER) {
            Debug.println(new StringBuffer("BundleClassLoader[").append(this.delegate).append("].loadClass(").append(string).append(")").toString());
        }
        try {
            Class<?> clazz = this.delegate.findClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        catch (Error error) {
            if (Debug.DEBUG_LOADER) {
                Debug.println(new StringBuffer("BundleClassLoader[").append(this.delegate).append("].loadClass(").append(string).append(") failed.").toString());
                Debug.printStackTrace(error);
            }
            throw error;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Debug.DEBUG_LOADER) {
                Debug.println(new StringBuffer("BundleClassLoader[").append(this.delegate).append("].loadClass(").append(string).append(") failed.").toString());
                Debug.printStackTrace(classNotFoundException);
            }
            throw classNotFoundException;
        }
    }

    @Override
    public URL getResource(String string) {
        URL uRL;
        if (Debug.DEBUG_LOADER) {
            Debug.println(new StringBuffer("BundleClassLoader[").append(this.delegate).append("].getResource(").append(string).append(")").toString());
        }
        if ((uRL = this.delegate.findResource(string)) != null) {
            return uRL;
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println(new StringBuffer("BundleClassLoader[").append(this.delegate).append("].getResource(").append(string).append(") failed.").toString());
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String string) throws IOException {
        Enumeration<URL> enumeration = this.delegate.findResources(string);
        if (enumeration == null) {
            return EMPTY_ENUMERATION;
        }
        return enumeration;
    }

    @Override
    protected String findLibrary(String string) {
        return this.manager.findLibrary(string);
    }

    @Override
    public ProtectionDomain getDomain() {
        return this.domain;
    }

    @Override
    public ClasspathEntry createClassPathEntry(BundleFile bundleFile, ProtectionDomain protectionDomain) {
        return new ClasspathEntry(bundleFile, DefaultClassLoader.createProtectionDomain(bundleFile, protectionDomain));
    }

    @Override
    public Class<?> defineClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry) {
        return this.defineClass(string, byArray, 0, byArray.length, classpathEntry.getDomain());
    }

    @Override
    public Class<?> publicFindLoaded(String string) {
        return this.findLoadedClass(string);
    }

    @Override
    public Object publicGetPackage(String string) {
        return this.getPackage(string);
    }

    @Override
    public Object publicDefinePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        return this.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
    }

    @Override
    public void initialize() {
        this.manager.initialize();
    }

    @Override
    public URL findLocalResource(String string) {
        return this.manager.findLocalResource(string);
    }

    @Override
    public Enumeration<URL> findLocalResources(String string) {
        return this.manager.findLocalResources(string);
    }

    @Override
    public Class<?> findLocalClass(String string) throws ClassNotFoundException {
        return this.manager.findLocalClass(string);
    }

    @Override
    public void close() {
        this.manager.close();
    }

    @Override
    public void attachFragment(BundleData bundleData, ProtectionDomain protectionDomain, String[] stringArray) {
        this.manager.attachFragment(bundleData, protectionDomain, stringArray);
    }

    @Override
    public ClassLoaderDelegate getDelegate() {
        return this.delegate;
    }

    public static ProtectionDomain createProtectionDomain(BundleFile bundleFile, ProtectionDomain protectionDomain) {
        try {
            Object object;
            PermissionCollection permissionCollection = protectionDomain != null ? protectionDomain.getPermissions() : ALLPERMISSIONS;
            Certificate[] certificateArray = null;
            SignedContent signedContent = null;
            if (bundleFile instanceof BundleFileWrapperChain) {
                object = (SignerInfo[])bundleFile;
                while (object != null && !(object.getWrapped() instanceof SignedContent)) {
                    object = object.getNext();
                }
                SignedContent signedContent2 = signedContent = object == null ? null : (SignedContent)((Object)object.getWrapped());
            }
            if (CLASS_CERTIFICATE && signedContent != null && signedContent.isSigned() && ((SignerInfo[])(object = signedContent.getSignerInfos())).length > 0) {
                certificateArray = object[0].getCertificateChain();
            }
            return new BundleProtectionDomain(permissionCollection, new CodeSource(bundleFile.getBaseFile().toURL(), certificateArray), null);
        }
        catch (MalformedURLException malformedURLException) {
            return protectionDomain;
        }
    }

    @Override
    public ClasspathManager getClasspathManager() {
        return this.manager;
    }

    @Override
    public Bundle getBundle() {
        return this.manager.getBaseData().getBundle();
    }

    @Override
    public boolean isParallelCapable() {
        return PARALLEL_CAPABLE;
    }

    @Override
    public List<URL> findEntries(String string, String string2, int n) {
        return this.manager.findEntries(string, string2, n);
    }

    @Override
    public Collection<String> listResources(String string, String string2, int n) {
        return this.delegate.listResources(string, string2, n);
    }

    @Override
    public Collection<String> listLocalResources(String string, String string2, int n) {
        return this.manager.listLocalResources(string, string2, n);
    }
}

