/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.osgi.util.ManifestElement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClassLoadingHook
implements ClassLoadingHook {
    private static final String[] LIB_EXTENSIONS;
    private static final String[] EMPTY_STRINGS;

    static {
        EMPTY_STRINGS = new String[0];
        String[] stringArray = ManifestElement.getArrayFromList(FrameworkProperties.getProperty("osgi.framework.library.extensions", FrameworkProperties.getProperty("org.osgi.framework.library.extensions")), ",");
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() > 0 && stringArray[n].charAt(0) != '.') {
                stringArray[n] = new StringBuffer(String.valueOf('.')).append(stringArray[n]).toString();
            }
            ++n;
        }
        LIB_EXTENSIONS = stringArray;
    }

    public static String[] mapLibraryNames(String string) {
        int n = string.lastIndexOf(46);
        if (LIB_EXTENSIONS.length == 0 || n < 0) {
            return EMPTY_STRINGS;
        }
        String string2 = string.substring(0, n);
        String[] stringArray = new String[LIB_EXTENSIONS.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = new StringBuffer(String.valueOf(string2)).append(LIB_EXTENSIONS[n2]).toString();
            ++n2;
        }
        return stringArray;
    }

    @Override
    public String findLibrary(BaseData baseData, String string) {
        String string2 = System.mapLibraryName(string);
        String string3 = null;
        if (Debug.DEBUG_LOADER) {
            Debug.println(new StringBuffer("  mapped library name: ").append(string2).toString());
        }
        if ((string3 = this.findNativePath(baseData, string2)) == null) {
            String[] stringArray = BaseClassLoadingHook.mapLibraryNames(string2);
            int n = 0;
            while (n < stringArray.length && string3 == null) {
                string3 = this.findNativePath(baseData, stringArray[n]);
                ++n;
            }
        }
        if (string3 == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println(new StringBuffer("  library does not exist: ").append(string2).toString());
            }
            string3 = this.findNativePath(baseData, string);
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println(new StringBuffer("  returning library: ").append(string3).toString());
        }
        return string3;
    }

    private String findNativePath(BaseData baseData, String string) {
        String[] stringArray;
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((stringArray = this.getNativePaths(baseData)) == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2;
            n = stringArray[n2].lastIndexOf(47);
            String string3 = string2 = n < 0 ? stringArray[n2] : stringArray[n2].substring(n + 1);
            if (string2.equals(string)) {
                Object object;
                if (stringArray[n2].startsWith("external:")) {
                    object = BaseStorageHook.substituteVars(stringArray[n2].substring("external:".length()));
                    File file = new File((String)object);
                    return file.getAbsolutePath();
                }
                object = baseData.getBundleFile().getFile(stringArray[n2], true);
                if (object != null) {
                    return ((File)object).getAbsolutePath();
                }
            }
            ++n2;
        }
        return null;
    }

    private String[] getNativePaths(BaseData baseData) {
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
        return baseStorageHook != null ? baseStorageHook.getNativePaths() : null;
    }

    @Override
    public boolean addClassPathEntry(ArrayList<ClasspathEntry> arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        return false;
    }

    @Override
    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    @Override
    public byte[] processClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        return null;
    }

    @Override
    public BaseClassLoader createClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, BaseData baseData, String[] stringArray) {
        return null;
    }

    @Override
    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData baseData) {
    }
}

