/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMap<K, V>
implements Collection<K> {
    final List<K> keys;
    final List<V> values;

    public ArrayMap(int n) {
        this.keys = new ArrayList<K>(n);
        this.values = new ArrayList<V>(n);
    }

    public ArrayMap(List<K> list, List<V> list2) {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("Keys and values size must be equal.");
        }
        this.keys = list;
        this.values = list2;
    }

    public V get(K k) {
        int n = this.keys.indexOf(k);
        if (n < 0) {
            return null;
        }
        return this.values.get(n);
    }

    public void put(K k, V v) {
        int n = this.keys.indexOf(k);
        if (n > 0) {
            this.values.set(n, v);
        } else {
            this.keys.add(k);
            this.values.add(v);
        }
    }

    @Override
    public boolean remove(Object object) {
        int n = this.keys.indexOf(object);
        if (n < 0) {
            return false;
        }
        this.keys.remove(n);
        this.values.remove(n);
        return true;
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    public List<K> getKeys() {
        return new ArrayList<K>(this.keys);
    }

    public List<V> getValues() {
        return new ArrayList<V>(this.values);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.keys.contains(object);
    }

    @Override
    public Iterator<K> iterator() {
        final Iterator<K> iterator = this.keys.iterator();
        final Iterator<V> iterator2 = this.values.iterator();
        return new Iterator<K>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public K next() {
                iterator2.next();
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator2.remove();
                iterator.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.keys.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.keys.toArray(TArray);
    }

    @Override
    public boolean add(K k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends K> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Object[] objectArray;
        boolean bl = false;
        Object[] objectArray2 = objectArray = this.keys.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (!collection.contains(object)) {
                bl |= this.remove(object);
            }
            ++n2;
        }
        return bl;
    }

    public K getKey(int n) {
        return this.keys.get(n);
    }

    public V getValue(int n) {
        return this.values.get(n);
    }
}

