/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;

public class ObjectPool {
    private static String OPTION_DEBUG_OBJECTPOOL_ADDS = "org.eclipse.osgi/debug/objectPool/adds";
    private static String OPTION_DEBUG_OBJECTPOOL_DUPS = "org.eclipse.osgi/debug/objectPool/dups";
    private static final boolean DEBUG_OBJECTPOOL_ADDS;
    private static final boolean DEBUG_OBJECTPOOL_DUPS;
    private static Map<Object, WeakReference<Object>> objectCache;

    static {
        objectCache = new WeakHashMap<Object, WeakReference<Object>>();
        FrameworkDebugOptions frameworkDebugOptions = FrameworkDebugOptions.getDefault();
        if (frameworkDebugOptions != null) {
            DEBUG_OBJECTPOOL_ADDS = frameworkDebugOptions.getBooleanOption(OPTION_DEBUG_OBJECTPOOL_ADDS, false);
            DEBUG_OBJECTPOOL_DUPS = frameworkDebugOptions.getBooleanOption(OPTION_DEBUG_OBJECTPOOL_DUPS, false);
        } else {
            DEBUG_OBJECTPOOL_ADDS = false;
            DEBUG_OBJECTPOOL_DUPS = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object intern(Object object) {
        Map<Object, WeakReference<Object>> map = objectCache;
        synchronized (map) {
            WeakReference<Object> weakReference = objectCache.get(object);
            if (weakReference != null) {
                Object t = weakReference.get();
                if (t != null) {
                    object = t;
                    if (DEBUG_OBJECTPOOL_DUPS) {
                        Debug.println("[ObjectPool] Found duplicate object: " + ObjectPool.getObjectString(object));
                    }
                }
            } else {
                objectCache.put(object, new WeakReference<Object>(object));
                if (DEBUG_OBJECTPOOL_ADDS) {
                    Debug.println("[ObjectPool] Added unique object to pool: " + ObjectPool.getObjectString(object) + " Pool size: " + objectCache.size());
                }
            }
        }
        return object;
    }

    private static String getObjectString(Object object) {
        return "[(" + object.getClass().getName() + ") " + object.toString() + "]";
    }
}

