/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Headers<K, V>
extends Dictionary<K, V>
implements Map<K, V> {
    private boolean readOnly = false;
    private K[] headers;
    private V[] values;
    private int size = 0;

    public Headers(int n) {
        Object[] objectArray = new Object[n];
        this.headers = objectArray;
        Object[] objectArray2 = new Object[n];
        this.values = objectArray2;
    }

    public Headers(Dictionary<? extends K, ? extends V> dictionary) {
        this(dictionary.size());
        Enumeration<K> enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            K k = enumeration.nextElement();
            this.set(k, dictionary.get(k));
        }
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return new ArrayEnumeration<K>(this.headers, this.size);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return new ArrayEnumeration<V>(this.values, this.size);
    }

    private int getIndex(Object object) {
        boolean bl = object instanceof String;
        int n = 0;
        while (n < this.size) {
            if (bl && this.headers[n] instanceof String ? ((String)this.headers[n]).equalsIgnoreCase((String)object) : this.headers[n].equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private V remove(int n) {
        V v = this.values[n];
        int n2 = n;
        while (n2 < this.size) {
            if (n2 == this.headers.length - 1) {
                this.headers[n2] = null;
                this.values[n2] = null;
            } else {
                this.headers[n2] = this.headers[n2 + 1];
                this.values[n2] = this.values[n2 + 1];
            }
            ++n2;
        }
        if (n < this.size) {
            --this.size;
        }
        return v;
    }

    private void add(K k, V v) {
        if (this.size == this.headers.length) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = objectArray2 = new Object[this.headers.length + 10];
            Object[] objectArray4 = objectArray = new Object[this.values.length + 10];
            System.arraycopy(this.headers, 0, objectArray3, 0, this.headers.length);
            System.arraycopy(this.values, 0, objectArray4, 0, this.values.length);
            this.headers = objectArray3;
            this.values = objectArray4;
        }
        this.headers[this.size] = k;
        this.values[this.size] = v;
        ++this.size;
    }

    @Override
    public synchronized V get(Object object) {
        int n = -1;
        n = this.getIndex(object);
        if (n != -1) {
            return this.values[n];
        }
        return null;
    }

    public synchronized V set(K object, V v, boolean bl) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (object instanceof String) {
            String string = ((String)object).intern();
            object = string;
        }
        int n = this.getIndex(object);
        if (v == null) {
            if (n != -1) {
                return this.remove(n);
            }
        } else {
            if (n != -1) {
                if (!bl) {
                    throw new IllegalArgumentException(NLS.bind(Msg.HEADER_DUPLICATE_KEY_EXCEPTION, object));
                }
                V v2 = this.values[n];
                this.values[n] = v;
                return v2;
            }
            this.add(object, v);
        }
        return null;
    }

    public synchronized V set(K k, V v) {
        return this.set(k, v, false);
    }

    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public synchronized V put(K k, V v) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        return this.set(k, v, true);
    }

    @Override
    public V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.values.toString();
    }

    public static Headers<String, String> parseManifest(InputStream inputStream) throws BundleException {
        Headers<String, String> headers = new Headers<String, String>(10);
        try {
            ManifestElement.parseBundleManifest(inputStream, headers);
        }
        catch (IOException iOException) {
            throw new BundleException(Msg.MANIFEST_IOEXCEPTION, 3, iOException);
        }
        headers.setReadOnly();
        return headers;
    }

    @Override
    public synchronized void clear() {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        return this.getIndex(object) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayEnumeration<E>
    implements Enumeration<E> {
        private E[] array;
        int cur = 0;

        public ArrayEnumeration(E[] EArray, int n) {
            Object[] objectArray = new Object[n];
            this.array = objectArray;
            System.arraycopy(EArray, 0, this.array, 0, this.array.length);
        }

        @Override
        public boolean hasMoreElements() {
            return this.cur < this.array.length;
        }

        @Override
        public E nextElement() {
            return this.array[this.cur++];
        }
    }
}

